/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Vector;
import oracle.charts.axischart.internal.AxisUtil;
import oracle.charts.axischart.internal.CalendarUtil;
import oracle.charts.axischart.internal.ChartDescription;
import oracle.charts.axischart.internal.DimensionElement;
import oracle.charts.axischart.internal.MillisecondsCalendar;
import oracle.charts.axischart.internal.NLSTimeUtil;
import oracle.charts.types.GridDesc;
import oracle.charts.types.TimeAxisDesc;
import oracle.charts.types.TimeBandDesc;
import oracle.viz.util.svg.SVGChartGraphics;

public final class XLabel {
    ChartDescription Ch;
    int[] xval_int;
    int dateFormatStyleDefault = 2;
    double x_coordinate_spread;
    double sc_Displaywidth;
    double sc_Displayheight;
    Vector FreqDim;
    MillisecondsCalendar C = new MillisecondsCalendar();
    private static final int LABEL_CENTER = 1;
    private static final int LABEL_LEFT = 2;
    private static final int LABEL_CENTER_PERIOD = 3;
    private static final int LABEL_TIMESTAMP_ALIGN = 4;
    private static final int LABEL_TIMESTAMP_INTERVAL_ALIGN = 5;
    public static final int LABEL_SECONDS = 1;
    public static final int LABEL_MINUTES = 2;
    public static final int LABEL_HOURS = 3;
    public static final int LABEL_DAYS = 4;
    public static final int LABEL_WEEKS = 5;
    public static final int LABEL_MONTHS = 6;
    public static final int LABEL_ANNUAL = 8;
    public static final int LABEL_DAY_OF_WEEK = 10;
    public static final int LABEL_SHORT_MONTHS = 62;
    public static final int LABEL_ONE_CHAR_MONTHS = 61;
    public static final int LABEL_SHORT_ANNUAL = 81;
    public static int LABEL_ANNUAL_CHOICE = 8;
    public static int LABEL_MONTH_CHOICE = 6;
    boolean test = false;
    boolean testXLabel = false;
    public boolean userDefinedDescriptorSet = false;
    public Color gridColor = Color.gray;
    public Color timeBandColor = Color.gray;
    public TimeBandDesc timeBandDesc;
    public TimeAxisDesc timeAxisD = new TimeAxisDesc();
    public FontMetrics fontmet;
    public int firstLevelField_default = 0;
    public int lastLevelField_default = 5;
    public int firstLevelField = this.firstLevelField_default;
    public int lastLevelField = this.lastLevelField_default;
    public boolean extendedLabels = false;
    int levelDifference = 0;
    public int firstLevelField_extended = this.firstLevelField;
    public int minNumLabelingLines = 0;
    public boolean drawGrid = true;
    boolean drawHash = true;
    public boolean containsDayLabels = false;
    Locale chartLocale;
    NLSTimeUtil NLSTime = new NLSTimeUtil();
    public Vector XLabelDimension = new Vector();
    Vector NewXHashMarks = new Vector();
    public boolean prependHoursToMinutes = false;
    public boolean prependHoursMinutesToSeconds = false;
    public int hour_field = TimeAxisDesc.HOUR_FIELD;
    public static final int[] relabelYear = new int[]{1, 1, 2, 5, 5, 5, 10, 10, 10, 10, 10, 15, 15, 15, 15, 15, 20, 20, 20, 20, 20, 25, 25, 25, 25, 25, 30, 30, 30, 30, 30, 35, 35, 35, 35, 35, 40, 40, 40, 40, 40, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 75, 75, 75, 75, 75, 80, 80, 80, 80, 80, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    public static final int[] relabelHours = new int[]{1, 2, 2, 3, 4, 6, 6, 8, 8};
    public static final int[] relabelDays = new int[]{1, 2, 2, 3};
    final int[] relabelHoursHash = new int[]{1, 2, 2, 3, 4, 6, 6, 8, 8, 12, 12, 12, 12};
    final int[] relabelMonthsHash = new int[]{1, 3, 3, 3, 6, 6, 6, 12, 12, 12, 12, 12, 12};
    final int[] relabelDayHash = new int[]{1, 2, 7, 7, 7, 7, 7, 7};
    final int[] relabelMinutesHash = new int[]{1, 2, 5, 5, 5, 5, 10, 10, 10, 10, 10, 15, 15, 15, 15, 15, 20, 20, 20, 20, 20, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30};
    public static final int[] relabelMinutes = new int[]{1, 2, 5, 5, 5, 5, 10, 10, 10, 10, 10, 15, 15, 15, 15, 15, 20, 20, 20, 20, 20, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30};
    int minHashSpacing = 8;

    public final void initChDesc(ChartDescription ch) {
        this.Ch = ch;
    }

    public final void initxval_int(int[] x) {
        this.xval_int = x;
    }

    public final void print_xval_int() {
        int i = 0;
        while (i < this.xval_int.length) {
            System.out.print(this.xval_int[i] + " ");
            ++i;
        }
        System.out.println();
    }

    public final void init_x_coordinate_spread(double spread) {
        this.x_coordinate_spread = spread;
    }

    public final void init_sc_widthheight(double width, double height) {
        this.sc_Displaywidth = width;
        this.sc_Displayheight = height;
    }

    public final void init_FreqDim(Vector f) {
        this.FreqDim = f;
    }

    public final void init_Cal(MillisecondsCalendar c) {
        this.C = c;
    }

    public XLabel(Locale chtLocale) {
        this.chartLocale = chtLocale;
        this.NLSTime.deriveDelimeter(chtLocale);
    }

    public void setChartLocale(Locale chtLocale) {
        this.chartLocale = chtLocale;
        this.NLSTime.deriveDelimeter(chtLocale);
    }

    private int getIntervals(double availableWidth, int minimumWidth) {
        double numIntervals = (double)minimumWidth / availableWidth;
        int numIntervals_int = (int)numIntervals + 1;
        return numIntervals_int;
    }

    public void dumpXLabels() {
        System.out.println("*** dumpXL *** " + this.XLabelDimension.size());
        int i = 0;
        while (i < this.XLabelDimension.size()) {
            LineLabel LL = (LineLabel)this.XLabelDimension.elementAt(i);
            LL.dumpLineLabels();
            ++i;
        }
        System.out.println();
    }

    public void dumpXLabels(String fcn) {
        System.out.println("*** dumpXL *** " + fcn + " " + this.XLabelDimension.size());
        int i = 0;
        while (i < this.XLabelDimension.size()) {
            LineLabel LL = (LineLabel)this.XLabelDimension.elementAt(i);
            LL.dumpLineLabels();
            ++i;
        }
        System.out.println();
    }

    public void ExtendFirstLabel(int lineLabelIndex) {
        String previousLevelLabel;
        if (this.XLabelDimension.size() <= lineLabelIndex) {
            return;
        }
        LineLabel LL = (LineLabel)this.XLabelDimension.elementAt(lineLabelIndex);
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(LL.level);
        if (LL.VLabel.size() < 1) {
            return;
        }
        int start_index = ((Label)LL.VLabel.elementAt((int)0)).start_index;
        this.C.setTime(this.Ch.TStamps[start_index]);
        if (LL.level - 1 > 0) {
            if (lineLabelIndex > 0) {
                LineLabel PrevLL = (LineLabel)this.XLabelDimension.elementAt(lineLabelIndex - 1);
                if (PrevLL.VLabel.size() > 0) {
                    DimensionElement prev = (DimensionElement)this.FreqDim.elementAt(PrevLL.level);
                    int calendar_field = prev.field;
                    start_index = ((Label)PrevLL.VLabel.elementAt((int)0)).start_index;
                    this.C.setTime(this.Ch.TStamps[start_index]);
                    int field_modulus = this.C.get(calendar_field);
                    previousLevelLabel = this.labelToString(PrevLL.level, field_modulus, 0);
                } else {
                    previousLevelLabel = this.labelToString(LL.level - 1, 0);
                }
            } else {
                previousLevelLabel = this.labelToString(LL.level - 1, 0);
            }
        } else {
            return;
        }
        switch (e.label) {
            case 8: {
                break;
            }
            case 81: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                String temp = ((Label)LL.VLabel.elementAt((int)0)).labelString;
                if (e.label == 2 && this.prependHoursMinutesToSeconds || e.label == 3 && (this.prependHoursToMinutes || this.prependHoursMinutesToSeconds)) break;
                if (this.test) {
                    System.out.println("ExtendFirstLabel: LABEL_HOURS " + temp);
                }
                if (this.test) {
                    System.out.println("ExtendFirstLabel [" + ((Label)LL.VLabel.elementAt((int)0)).start_index + "," + ((Label)LL.VLabel.elementAt((int)0)).index + "]");
                }
                if (e.label == 3 && e.field == 10) {
                    if (temp.startsWith("12")) {
                        if (previousLevelLabel.equals("00") || previousLevelLabel.equals("0")) break;
                        ((Label)LL.VLabel.elementAt((int)0)).labelString = "12" + this.NLSTime.delimeterMinute + this.padZero(previousLevelLabel);
                        break;
                    }
                    ((Label)LL.VLabel.elementAt((int)0)).labelString = temp + this.NLSTime.delimeterMinute + this.padZero(previousLevelLabel);
                    break;
                }
                ((Label)LL.VLabel.elementAt((int)0)).labelString = temp + this.NLSTime.delimeterMinute + this.padZero(previousLevelLabel);
                break;
            }
        }
    }

    public void ExtendMinutes(int lineLabelIndex) {
        if (lineLabelIndex != 0) {
            return;
        }
        LineLabel minutesLL = (LineLabel)this.XLabelDimension.elementAt(lineLabelIndex);
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(minutesLL.level);
        if (e.label != 2) {
            return;
        }
        String hoursLabel = "";
        LineLabel hoursLL = (LineLabel)this.XLabelDimension.elementAt(lineLabelIndex + 1);
        int num_minutes_labels = minutesLL.VLabel.size();
        int num_hours_labels = hoursLL.VLabel.size();
        if (num_hours_labels <= 0) {
            return;
        }
        int k = 0;
        int j = 0;
        while (j < num_hours_labels) {
            int hour_interval_end = ((Label)hoursLL.VLabel.elementAt((int)j)).index;
            hoursLabel = ((Label)hoursLL.VLabel.elementAt((int)j)).labelString;
            while (k < num_minutes_labels && ((Label)minutesLL.VLabel.elementAt((int)k)).start_index < hour_interval_end) {
                this.extendMinutesLabel(minutesLL, hoursLabel, k);
                ++k;
            }
            ++j;
        }
        if (k < num_minutes_labels) {
            this.extendMinutesLabel(minutesLL, hoursLabel, num_minutes_labels - 1);
        }
        hoursLL.VLabel.removeAllElements();
    }

    public void extendMinutesLabel(LineLabel minutesLL, String hoursLabel, int k) {
        String minutesLabel = this.padZero(((Label)minutesLL.VLabel.elementAt((int)k)).labelString);
        if (hoursLabel.length() <= 2) {
            ((Label)minutesLL.VLabel.elementAt((int)k)).labelString = hoursLabel + this.NLSTime.delimeterMinute + minutesLabel;
            if (minutesLabel.equals("00")) {
                ((Label)minutesLL.VLabel.elementAt(k)).setGridThreshold();
            }
        } else if (minutesLabel.equals("00")) {
            ((Label)minutesLL.VLabel.elementAt((int)k)).labelString = hoursLabel;
            ((Label)minutesLL.VLabel.elementAt(k)).setGridThreshold();
        } else {
            String newhoursLabel = hoursLabel.substring(0, 2);
            ((Label)minutesLL.VLabel.elementAt((int)k)).labelString = newhoursLabel + this.NLSTime.delimeterMinute + minutesLabel;
        }
    }

    public void ExtendSeconds(int lineLabelIndex) {
        if (lineLabelIndex != 0) {
            return;
        }
        LineLabel secondsLL = (LineLabel)this.XLabelDimension.elementAt(lineLabelIndex);
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(secondsLL.level);
        if (e.label != 1) {
            return;
        }
        String hoursLabel = "";
        String minutesLabel = "";
        LineLabel minutesLL = (LineLabel)this.XLabelDimension.elementAt(lineLabelIndex + 1);
        LineLabel hoursLL = (LineLabel)this.XLabelDimension.elementAt(lineLabelIndex + 2);
        int num_seconds_labels = secondsLL.VLabel.size();
        int num_minutes_labels = minutesLL.VLabel.size();
        int num_hours_labels = hoursLL.VLabel.size();
        if (num_minutes_labels <= 0) {
            return;
        }
        if (num_hours_labels <= 0) {
            return;
        }
        int j = 0;
        int k = 0;
        int i = 0;
        while (i < num_hours_labels) {
            int hour_interval_end = ((Label)hoursLL.VLabel.elementAt((int)i)).index;
            hoursLabel = ((Label)hoursLL.VLabel.elementAt((int)i)).labelString;
            while (j < num_minutes_labels && ((Label)minutesLL.VLabel.elementAt((int)j)).start_index < hour_interval_end) {
                int minute_interval_end = ((Label)minutesLL.VLabel.elementAt((int)j)).index;
                minutesLabel = this.padZero(((Label)minutesLL.VLabel.elementAt((int)j)).labelString);
                while (k < num_seconds_labels && ((Label)secondsLL.VLabel.elementAt((int)k)).start_index < minute_interval_end && ((Label)secondsLL.VLabel.elementAt((int)k)).start_index < hour_interval_end) {
                    this.extendSecondsLabel(secondsLL, hoursLabel, minutesLabel, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (k < num_seconds_labels) {
            minutesLabel = this.padZero(((Label)minutesLL.VLabel.elementAt((int)(num_minutes_labels - 1))).labelString);
            this.extendSecondsLabel(secondsLL, hoursLabel, minutesLabel, num_seconds_labels - 1);
        }
        hoursLL.VLabel.removeAllElements();
        minutesLL.VLabel.removeAllElements();
    }

    public void extendSecondsLabel(LineLabel secondsLL, String hoursLabel, String minutesLabel, int k) {
        String secondsLabel = this.padZero(((Label)secondsLL.VLabel.elementAt((int)k)).labelString);
        if (hoursLabel.length() <= 2) {
            ((Label)secondsLL.VLabel.elementAt((int)k)).labelString = hoursLabel + this.NLSTime.delimeterMinute + minutesLabel + this.NLSTime.delimeterSecond + secondsLabel;
            if (secondsLabel.equals("00")) {
                ((Label)secondsLL.VLabel.elementAt(k)).setGridThreshold();
            }
        } else if (minutesLabel.equals("00") && secondsLabel.equals("00")) {
            ((Label)secondsLL.VLabel.elementAt((int)k)).labelString = hoursLabel;
        } else {
            String newhoursLabel = hoursLabel.substring(0, 2);
            ((Label)secondsLL.VLabel.elementAt((int)k)).labelString = newhoursLabel + this.NLSTime.delimeterMinute + minutesLabel + this.NLSTime.delimeterSecond + secondsLabel;
            if (secondsLabel.equals("00")) {
                ((Label)secondsLL.VLabel.elementAt(k)).setGridThreshold();
            }
        }
    }

    private String padZero(String str) {
        if (str.length() == 1) {
            return "0" + str;
        }
        return str;
    }

    private boolean Merge2Levels(LineLabel lastV, LineLabel firstIV) {
        boolean merged = false;
        int interval_end = ((Label)lastV.VLabel.elementAt((int)0)).index;
        int x_width = AxisUtil.getLabelWidth(this.xval_int, 0, interval_end, this.Ch.XAxisCount, this.Ch.border_left, (int)this.sc_Displaywidth, this.x_coordinate_spread);
        if (this.test) {
            System.out.println("Merge2Labels: x_width " + x_width);
        }
        String labelStringV = ((Label)lastV.VLabel.elementAt((int)0)).labelString;
        String labelStringIV = ((Label)firstIV.VLabel.elementAt((int)0)).labelString;
        String newLabelString = labelStringV + " " + labelStringIV;
        int newLabelWidth = this.fontmet.stringWidth(newLabelString);
        if (this.test) {
            System.out.println("Merge2Levels: Label width " + newLabelWidth);
        }
        if (newLabelWidth < x_width) {
            ((Label)lastV.VLabel.elementAt((int)0)).labelString = newLabelString;
            firstIV.VLabel.removeAllElements();
            merged = true;
        }
        return merged;
    }

    private boolean Merge2EqualLevels(LineLabel l1, LineLabel l2) {
        boolean merged = false;
        int interval_end = ((Label)l1.VLabel.elementAt((int)0)).index;
        int x_width = AxisUtil.getLabelWidth(this.xval_int, 0, interval_end, this.Ch.XAxisCount, this.Ch.border_left, (int)this.sc_Displaywidth, this.x_coordinate_spread);
        String labelString1 = ((Label)l1.VLabel.elementAt((int)0)).labelString;
        String labelString2 = ((Label)l2.VLabel.elementAt((int)0)).labelString;
        String newLabelString = labelString1 + " " + labelString2;
        int newLabelWidth = this.fontmet.stringWidth(newLabelString);
        if (this.test) {
            System.out.println("Merge2Levels: Label width " + newLabelWidth);
        }
        if (newLabelWidth < x_width) {
            int i = 0;
            while (i < l1.VLabel.size()) {
                labelString1 = ((Label)l1.VLabel.elementAt((int)i)).labelString;
                labelString2 = ((Label)l2.VLabel.elementAt((int)i)).labelString;
                ((Label)l1.VLabel.elementAt((int)i)).labelString = newLabelString = labelString1 + " " + labelString2;
                ++i;
            }
            merged = true;
            l2.VLabel.removeAllElements();
        }
        return merged;
    }

    private boolean Merge3Levels(LineLabel lastV, LineLabel firstIV, LineLabel lastIV) {
        boolean merged = false;
        int interval_end = ((Label)lastV.VLabel.elementAt((int)0)).index;
        int x_width = AxisUtil.getLabelWidth(this.xval_int, 0, interval_end, this.Ch.XAxisCount, this.Ch.border_left, (int)this.sc_Displaywidth, this.x_coordinate_spread);
        if (this.test) {
            System.out.println("Merge3Labels: x_width " + x_width);
        }
        String labelStringV = ((Label)lastV.VLabel.elementAt((int)0)).labelString;
        String labelStringIV = ((Label)firstIV.VLabel.elementAt((int)0)).labelString;
        String labelStringIV2 = ((Label)lastIV.VLabel.elementAt((int)0)).labelString;
        String newLabelString = DateFormat.getDateInstance(this.dateFormatStyleDefault, this.chartLocale).format(this.Ch.TStamps[0]);
        int newLabelWidth = this.fontmet.stringWidth(newLabelString);
        if (this.test) {
            System.out.println("Merge3Levels: Label width " + newLabelWidth);
        }
        if (newLabelWidth < x_width) {
            ((Label)lastV.VLabel.elementAt((int)0)).labelString = newLabelString;
            firstIV.VLabel.removeAllElements();
            lastIV.VLabel.removeAllElements();
            merged = true;
        }
        return merged;
    }

    public void FoldLabels(GridDesc userXGrid) {
        LineLabel LL;
        if (this.testXLabel) {
            System.out.println();
            System.out.println("FoldLabels()");
            this.dumpXLabels();
        }
        int lastVariableLevel = -1;
        int firstInvariantLevel = -1;
        int i = 0;
        while (i < this.XLabelDimension.size()) {
            LL = (LineLabel)this.XLabelDimension.elementAt(i);
            if (LL.VLabel.size() > 1) {
                lastVariableLevel = i;
            } else if (LL.VLabel.size() == 1) {
                firstInvariantLevel = i;
                break;
            }
            ++i;
        }
        if (this.XLabelDimension.size() - 1 < 0) {
            return;
        }
        LineLabel lastIV = (LineLabel)this.XLabelDimension.elementAt(this.XLabelDimension.size() - 1);
        if (lastIV.VLabel.size() == 0) {
            i = this.XLabelDimension.size() - 1;
            while (i >= 0) {
                LL = (LineLabel)this.XLabelDimension.elementAt(i);
                if (LL.VLabel.size() == 0) {
                    this.XLabelDimension.removeElementAt(i);
                }
                --i;
            }
            return;
        }
        if (lastVariableLevel == -1 && firstInvariantLevel != -1) {
            this.FoldInvariantLabels(firstInvariantLevel);
        }
        if (lastVariableLevel != -1 && firstInvariantLevel != -1) {
            LineLabel lastV = (LineLabel)this.XLabelDimension.elementAt(lastVariableLevel);
            LineLabel firstIV = (LineLabel)this.XLabelDimension.elementAt(firstInvariantLevel);
            boolean folded = false;
            boolean test = false;
            if (test) {
                System.out.println("FoldLabels: firstIV/LastV " + firstIV.dimensionName + " " + lastV.dimensionName);
            }
            boolean equalMonthDay = false;
            if (firstIV.dimensionName.equals("YEAR") && lastV.dimensionName.equals("MONTH")) {
                if (test) {
                    System.out.println("FoldLabels: YEAR/MONTH");
                }
                LineLabel firstLabel = (LineLabel)this.XLabelDimension.elementAt(this.XLabelDimension.size() - 1);
                LineLabel lastLabel = (LineLabel)this.XLabelDimension.elementAt(0);
                if (firstLabel.dimensionName.equals("YEAR") && lastLabel.dimensionName.equals("DAY_OF_MONTH")) {
                    LineLabel MonthLL = (LineLabel)this.XLabelDimension.elementAt(1);
                    LineLabel DayLL = (LineLabel)this.XLabelDimension.elementAt(0);
                    if (MonthLL.VLabel.size() == DayLL.VLabel.size() && (equalMonthDay = this.Merge2EqualLevels(MonthLL, DayLL))) {
                        MonthLL.alignTStampLabels = true;
                    }
                }
                if (!equalMonthDay) {
                    folded = this.Merge2Levels(lastV, firstIV);
                }
            } else if (firstIV.dimensionName.equals("MONTH") && lastV.dimensionName.equals("DAY_OF_MONTH")) {
                if (test) {
                    System.out.println("FoldLabels: lastIV " + lastIV.dimensionName);
                }
                if (lastIV.dimensionName.equals("YEAR")) {
                    folded = this.Merge3Levels(lastV, firstIV, lastIV);
                    if (!folded) {
                        folded = this.Merge2Levels(lastV, firstIV);
                        if (test) {
                            System.out.println("FoldLabels: finish Merge2");
                        }
                        if (folded) {
                            Label L = (Label)lastIV.VLabel.elementAt(0);
                            firstIV.VLabel.addElement(L);
                            lastIV.VLabel.removeAllElements();
                        }
                    }
                } else {
                    if (test) {
                        System.out.println("FoldLabels: MONTH/DAY");
                    }
                    folded = this.Merge2Levels(lastV, firstIV);
                }
            }
            if (test) {
                System.out.println("Folded : " + folded);
            }
            if (!folded) {
                this.FoldInvariantLabels(firstInvariantLevel);
            }
        }
        i = this.XLabelDimension.size() - 1;
        while (i >= 0) {
            LL = (LineLabel)this.XLabelDimension.elementAt(i);
            if (LL.VLabel.size() == 0) {
                this.XLabelDimension.removeElementAt(i);
            }
            --i;
        }
        if (this.test) {
            System.out.println("######## " + this.XLabelDimension.size());
        }
        int gridDimensions = 0;
        if (this.XLabelDimension.size() > 1) {
            i = 0;
            while (i < this.XLabelDimension.size()) {
                LL = (LineLabel)this.XLabelDimension.elementAt(i);
                DimensionElement e = (DimensionElement)this.FreqDim.elementAt(LL.level);
                if (i == 0 && LL.matchTStamps) {
                    e.gridline = userXGrid.getGridStyle();
                } else if (e.gridOn) {
                    ++gridDimensions;
                    e.gridline = userXGrid.getGridStyle();
                }
                if (e.field == 12 && this.prependHoursToMinutes || e.field == 13 && this.prependHoursMinutesToSeconds) {
                    ++gridDimensions;
                }
                ++i;
            }
        }
        if (gridDimensions > 1) {
            LL = (LineLabel)this.XLabelDimension.elementAt(this.XLabelDimension.size() - 1);
            DimensionElement e = (DimensionElement)this.FreqDim.elementAt(LL.level);
            if (this.test) {
                System.out.println("######## " + this.XLabelDimension.size() + " " + LL.level);
            }
            e.gridline = userXGrid.getGridStyleThreshold();
        }
        if (this.testXLabel) {
            System.out.println("*** dumpXL after fold ***");
        }
        if (this.testXLabel) {
            this.dumpXLabels();
        }
    }

    public void FoldInvariantLabels(int firstInvariantLevel) {
        LineLabel LL;
        String IVLabels = "";
        String temp = "";
        String previousDim = "";
        String tempMinute = "";
        boolean test = false;
        boolean[] dim = new boolean[]{false, false, false};
        int lev = firstInvariantLevel;
        while (lev < this.XLabelDimension.size()) {
            LL = (LineLabel)this.XLabelDimension.elementAt(lev);
            if (LL.VLabel.size() > 0) {
                if (!dim[0] && LL.dimensionName.equals("DAY_OF_MONTH")) {
                    dim[0] = true;
                } else if (dim[0] && !dim[1] && LL.dimensionName.equals("MONTH")) {
                    dim[1] = true;
                } else {
                    if (dim[0] && dim[1] && !dim[2] && LL.dimensionName.equals("YEAR")) {
                        dim[2] = true;
                        break;
                    }
                    temp = ((Label)LL.VLabel.elementAt((int)0)).labelString;
                    if (test) {
                        System.out.println("Fold Scan: " + temp + " dim " + LL.dimensionName);
                    }
                }
            }
            ++lev;
        }
        boolean invariantYYMMDD = false;
        if (dim[0] && dim[1] && dim[2]) {
            invariantYYMMDD = true;
        }
        lev = firstInvariantLevel;
        while (lev < this.XLabelDimension.size()) {
            LL = (LineLabel)this.XLabelDimension.elementAt(lev);
            if (LL.VLabel.size() > 0) {
                temp = ((Label)LL.VLabel.elementAt((int)0)).labelString;
                if (test) {
                    System.out.println("Folded: " + temp + " dim " + LL.dimensionName);
                }
                if (!temp.equals("")) {
                    if (previousDim.equals("MINUTE") && LL.dimensionName.equals("HOUR") || previousDim.equals("SECOND") && LL.dimensionName.equals("MINUTE")) {
                        if (!this.prependHoursToMinutes && !this.prependHoursMinutesToSeconds) {
                            int spaceIndex;
                            String temp2 = "";
                            temp2 = temp.length() > 2 ? ((spaceIndex = temp.indexOf(32)) == -1 ? temp : temp.substring(0, spaceIndex) + this.NLSTime.delimeterMinute + tempMinute + temp.substring(spaceIndex)) : temp + this.NLSTime.delimeterMinute + tempMinute;
                            IVLabels = IVLabels.equals("") ? temp2 : IVLabels + " " + temp2;
                        }
                    } else if (LL.dimensionName.equals("MINUTE")) {
                        tempMinute = this.padZero(temp);
                    } else if (!(LL.dimensionName.equals("HOUR") && this.prependHoursToMinutes || LL.dimensionName.equals("MINUTE") && this.prependHoursMinutesToSeconds)) {
                        if (IVLabels.equals("")) {
                            if (!invariantYYMMDD) {
                                IVLabels = temp;
                            } else if (LL.dimensionName.equals("YEAR")) {
                                IVLabels = DateFormat.getDateInstance(this.dateFormatStyleDefault, this.chartLocale).format(this.Ch.TStamps[0]);
                            }
                        } else if (!invariantYYMMDD) {
                            IVLabels = IVLabels + " " + temp;
                        } else {
                            if (!(LL.dimensionName.equals("DAY_OF_MONTH") || LL.dimensionName.equals("MONTH") || LL.dimensionName.equals("YEAR"))) {
                                IVLabels = IVLabels + " " + temp;
                            }
                            if (LL.dimensionName.equals("YEAR")) {
                                IVLabels = IVLabels + " " + DateFormat.getDateInstance(this.dateFormatStyleDefault, this.chartLocale).format(this.Ch.TStamps[0]);
                            }
                        }
                    }
                }
            }
            previousDim = LL.dimensionName;
            ++lev;
        }
        LineLabel firstIV = (LineLabel)this.XLabelDimension.elementAt(firstInvariantLevel);
        ((Label)firstIV.VLabel.elementAt((int)0)).labelString = IVLabels;
        if (test) {
            System.out.println("@@@@@@@@@@Folded [" + ((Label)firstIV.VLabel.elementAt((int)0)).start_index + "," + ((Label)firstIV.VLabel.elementAt((int)0)).index + "]");
        }
        ((Label)firstIV.VLabel.elementAt((int)0)).index = this.Ch.TStampsCount - 1;
        if (test) {
            System.out.println("@@@@@@@@@@Folded [" + ((Label)firstIV.VLabel.elementAt((int)0)).start_index + "," + ((Label)firstIV.VLabel.elementAt((int)0)).index + "]");
        }
        lev = firstInvariantLevel + 1;
        while (lev < this.XLabelDimension.size()) {
            if (test) {
                System.out.println("Folded !folded2: " + lev);
            }
            LL = (LineLabel)this.XLabelDimension.elementAt(lev);
            LL.VLabel.removeAllElements();
            ++lev;
        }
    }

    private void paintXHashMarks(Graphics2D g2, SVGChartGraphics svgG, GridDesc userXGrid) {
        HashMarks HM = (HashMarks)this.NewXHashMarks.elementAt(0);
        int minorTickHeight = 3;
        if (HM.VMarks.size() > 0) {
            boolean marks_up = true;
            if (this.Ch.containsBarType) {
                marks_up = false;
            }
            int tickHeight = minorTickHeight;
            if (marks_up) {
                tickHeight = -minorTickHeight;
            }
            Color c = userXGrid.getColor();
            int k = 0;
            while (k < HM.VMarks.size()) {
                int index = ((Mark)HM.VMarks.elementAt((int)k)).index;
                g2.setColor(c);
                g2.drawLine(this.xval_int[index], this.Ch.displayHeight - this.Ch.border_bottom + tickHeight, this.xval_int[index], this.Ch.displayHeight - this.Ch.border_bottom);
                ++k;
            }
        }
    }

    public int getLastLevelXPosition(Graphics2D g2, double leftAlignment) {
        boolean count = false;
        if (this.XLabelDimension.size() <= 1) {
            return -1;
        }
        int lastLevel = this.XLabelDimension.size() - 1;
        LineLabel LL = (LineLabel)this.XLabelDimension.elementAt(lastLevel);
        int num_labels = LL.VLabel.size();
        if (num_labels == 1) {
            String labelString = ((Label)LL.VLabel.elementAt((int)0)).labelString;
            int labelWidth = this.fontmet.stringWidth(labelString);
            int start_index = ((Label)LL.VLabel.elementAt((int)0)).start_index;
            int startString = this.Ch.border_left;
            if (this.Ch.continuousTimeXAxis) {
                startString = (int)leftAlignment;
                return startString + labelWidth;
            }
            return startString + labelWidth;
        }
        return -1;
    }

    private void paintXLabels(Graphics2D g2, SVGChartGraphics svgG, boolean drawLabelOnly, GridDesc userXGrid, BasicStroke defaultStroke, BasicStroke dashedStroke, BasicStroke dashedStroke2) {
        if (!this.timeAxisD.getDrawLabel()) {
            return;
        }
        int labelHeight = this.fontmet.getHeight();
        boolean test = false;
        if (test) {
            System.out.println();
        }
        if (test) {
            System.out.println("*** paintXLabels ***");
        }
        int lastVariableLevel = -1;
        int firstInvariantLevel = -1;
        int label_justify = 1;
        DimensionElement first = (DimensionElement)this.FreqDim.elementAt(this.firstLevelField);
        if (this.Ch.containsIntervalGraphic && first.period > 1 && !this.Ch.subFrequency) {
            label_justify = 3;
        }
        int dayOfWeekOffset = 0;
        int lev = 0;
        while (lev < this.XLabelDimension.size()) {
            LineLabel LL = (LineLabel)this.XLabelDimension.elementAt(lev);
            DimensionElement e = (DimensionElement)this.FreqDim.elementAt(LL.level);
            if (lev > 0) {
                label_justify = 2;
            }
            if (test) {
                System.out.println("paintXLabels() Level " + lev + " match " + LL.matchTStamps);
            }
            if (lev == 0 && LL.alignTStampLabels && !this.Ch.useIntervalMethod()) {
                label_justify = 4;
            }
            if (lev == 0 && LL.alignTStampLabels && this.Ch.useIntervalMethod()) {
                label_justify = 5;
            }
            if (lev == 0 && this.Ch.continuousTimeXAxis && !LL.alignTStampLabels) {
                label_justify = 3;
            }
            if (lev == 0 && LL.matchTStamps) {
                first.gridOn = false;
            }
            if (e.field == 12 && this.prependHoursToMinutes || e.field == 13 && this.prependHoursMinutesToSeconds) {
                e.gridOn = true;
                e.gridline = userXGrid.getGridStyle();
                if (this.Ch.containsIntervalGraphic) {
                    label_justify = 5;
                }
            }
            int yLocation = 0;
            int lineOffset = 0;
            int topDelta = 2 * labelHeight / 3;
            g2.setFont(this.timeAxisD.getFont());
            g2.setColor(this.timeAxisD.getColor());
            if (this.timeAxisD.getDayOfWeek() && e.field == 5) {
                lineOffset = (lev + 1) * labelHeight;
                yLocation = this.timeAxisD.getAxisAlignment() == 1 ? this.Ch.displayHeight - this.Ch.border_bottom + lineOffset : this.Ch.border_top - lineOffset + topDelta;
                this.LabelOneLine(g2, drawLabelOnly, LL.VLabel2, LL.level, label_justify, yLocation, userXGrid, defaultStroke, dashedStroke, dashedStroke2);
                dayOfWeekOffset = 1;
            }
            lineOffset = (lev + 1 + dayOfWeekOffset) * labelHeight;
            yLocation = this.timeAxisD.getAxisAlignment() == 1 ? this.Ch.displayHeight - this.Ch.border_bottom + lineOffset : this.Ch.border_top - lineOffset + topDelta;
            this.LabelOneLine(g2, drawLabelOnly, LL.VLabel, LL.level, label_justify, yLocation, userXGrid, defaultStroke, dashedStroke, dashedStroke2);
            if (this.Ch.continuousTimeXAxis && lev == 0) {
                this.labelHash(g2, LL.VLabel);
            }
            ++lev;
        }
    }

    private void LabelOneLine(Graphics2D g2, boolean drawLabelOnly, Vector vLab, int llLevel, int label_justify, int yLocation, GridDesc userXGrid, BasicStroke defaultStroke, BasicStroke dashedStroke, BasicStroke dashedStroke2) {
        int delta = 0;
        boolean label_skip = false;
        boolean label_skip_first = false;
        int num_labels = vLab.size();
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(llLevel);
        if (num_labels > 0) {
            int end_index = 0;
            int start_index = 0;
            int k = 0;
            while (k < num_labels) {
                if (this.test) {
                    System.out.println("k = " + k);
                }
                String labelString = ((Label)vLab.elementAt((int)k)).labelString;
                end_index = ((Label)vLab.elementAt((int)k)).index;
                start_index = ((Label)vLab.elementAt((int)k)).start_index;
                boolean off_cycle = ((Label)vLab.elementAt((int)k)).off_cycle;
                if (!drawLabelOnly) {
                    if (this.drawGrid && !off_cycle && k > 0 && e.gridOn) {
                        boolean thresholdGridStyle = ((Label)vLab.elementAt((int)k)).thresholdGridStyle;
                        this.XLabelBottomGrid(g2, llLevel, start_index, thresholdGridStyle, userXGrid, defaultStroke, dashedStroke, dashedStroke2);
                    }
                } else {
                    if (this.test) {
                        System.out.print("  paintXLabels: [" + start_index + "," + end_index + "]");
                    }
                    int x_width = label_justify == 4 ? this.getLabelWidthBorder(start_index, end_index) : AxisUtil.getLabelWidth(this.xval_int, start_index, end_index, this.Ch.XAxisCount, this.Ch.border_left, (int)this.sc_Displaywidth, this.x_coordinate_spread);
                    if (this.test) {
                        System.out.print(" x_width " + x_width);
                    }
                    int labelWidth = this.fontmet.stringWidth(labelString);
                    if (this.test) {
                        System.out.println(" *** width of ." + labelString + ". is " + labelWidth);
                    }
                    label_skip = false;
                    int labelWidthLimitStart = labelWidth;
                    int labelWidthLimitEnd = labelWidth;
                    if (label_skip_first) {
                        label_skip = true;
                        label_skip_first = false;
                    } else if (k == 0 && x_width < labelWidthLimitStart) {
                        label_skip_first = true;
                        if (this.test) {
                            System.out.println("paintXLabels: skipping 0 ." + labelString + ".");
                        }
                    } else if (k == num_labels - 1) {
                        if (num_labels >= 2) {
                            String prev_labelString = ((Label)vLab.elementAt((int)(k - 1))).labelString;
                            int prev_end_index = ((Label)vLab.elementAt((int)(k - 1))).index;
                            int prev_start_index = ((Label)vLab.elementAt((int)(k - 1))).start_index;
                            if (start_index < prev_end_index) {
                                int prev_labelWidth = this.fontmet.stringWidth(prev_labelString);
                                int lastLabelRightPosition = this.xval_int[prev_start_index] + labelWidth;
                                if (this.xval_int[start_index] <= lastLabelRightPosition) {
                                    label_skip = true;
                                }
                            }
                            if (this.test) {
                                System.out.println("[" + prev_start_index + "," + prev_end_index + "]");
                            }
                            if (this.test) {
                                System.out.println("[" + start_index + "," + end_index + "]");
                            }
                        }
                        if (x_width + this.Ch.border_right < labelWidthLimitEnd) {
                            label_skip = true;
                            if (this.test) {
                                System.out.println("paintXLabels: skipping k (end)." + labelString + "." + "width " + x_width);
                            }
                        } else if (this.xval_int[start_index] > this.Ch.displayWidth - this.Ch.border_right) {
                            label_skip = true;
                        }
                    }
                    switch (label_justify) {
                        case 2: {
                            delta = 0;
                            break;
                        }
                        case 5: {
                            int interval_width = start_index + 1 < this.xval_int.length ? this.xval_int[start_index + 1] - this.xval_int[start_index] : (start_index > 0 ? this.xval_int[start_index] - this.xval_int[start_index - 1] : this.getLabelWidthBorder(start_index, end_index));
                            if (interval_width < 0) {
                                interval_width = 0;
                            }
                            delta = -(labelWidth / 2) + interval_width / 2;
                            break;
                        }
                        case 4: {
                            if (this.xval_int.length == 1) {
                                delta = 0;
                                break;
                            }
                            delta = -(labelWidth / 2);
                            break;
                        }
                        case 1: {
                            if (x_width > labelWidth) {
                                delta = (x_width - labelWidth) / 2;
                                break;
                            }
                            delta = 0;
                            break;
                        }
                        case 3: {
                            delta = x_width > labelWidth ? (x_width - labelWidth) / 2 : 0;
                        }
                    }
                    if (!label_skip) {
                        int xLocation = this.xval_int[start_index] + delta;
                        if (k == 0 && xLocation < 0) {
                            xLocation = 0;
                        }
                        g2.drawString(labelString, xLocation, yLocation);
                    }
                }
                ++k;
            }
        }
    }

    private void labelHash(Graphics2D g2, Vector vLab) {
        int num_labels = vLab.size();
        int yLocation = this.Ch.displayHeight - this.Ch.border_bottom;
        if (num_labels > 0) {
            g2.setColor(Color.gray);
            int end_index = 0;
            int start_index = 0;
            int k = 0;
            while (k < num_labels) {
                end_index = ((Label)vLab.elementAt((int)k)).index;
                start_index = ((Label)vLab.elementAt((int)k)).start_index;
                if (this.xval_int[start_index] <= this.Ch.displayWidth - this.Ch.border_right) {
                    g2.drawLine(this.xval_int[start_index], yLocation, this.xval_int[start_index], yLocation - 3);
                }
                ++k;
            }
        }
    }

    private void insertInvariantLabels() {
        int lev = 0;
        String labelstring = "";
        int lastVariableLevel = this.getLastVariableLevel();
        int firstInvariantLevel = 0;
        lev = firstInvariantLevel = lastVariableLevel + 1;
        while (lev <= this.lastLevelField) {
            int index;
            DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
            if (this.test) {
                System.out.println("insertInvariantLabel(): lev: " + lev + " " + current.name);
            }
            int calendar_field = current.field;
            this.C.setTime(this.Ch.TStamps[0]);
            int field_modulus = this.C.get(calendar_field);
            if (labelstring.length() != 0) {
                labelstring = labelstring + " ";
            }
            labelstring = this.labelToString(lev, 0);
            if (this.test) {
                System.out.println("insertInvariantLabel(): label is: " + labelstring);
            }
            if ((index = lev - this.firstLevelField + this.levelDifference) < this.XLabelDimension.size()) {
                LineLabel LL = (LineLabel)this.XLabelDimension.elementAt(index);
                LL.VLabel.addElement(new Label(0, this.Ch.TStamps.length - 1, labelstring));
            }
            ++lev;
        }
    }

    private void initXLabels() {
        this.XLabelDimension = new Vector();
        if (this.XLabelDimension.size() != 0) {
            System.out.println("*** ERROR XLabelDim not cleared! ***");
            System.exit(1);
        }
        int firstLevelFieldTemp = this.firstLevelField;
        if (this.extendedLabels && this.firstLevelField_extended < this.firstLevelField) {
            firstLevelFieldTemp = this.firstLevelField_extended;
        }
        int lev = firstLevelFieldTemp;
        while (lev <= this.lastLevelField) {
            DimensionElement e = (DimensionElement)this.FreqDim.elementAt(lev);
            this.XLabelDimension.addElement(new LineLabel(lev, e.name));
            ++lev;
        }
    }

    private void initXHashMarks() {
        this.NewXHashMarks.removeAllElements();
        int lev = this.firstLevelField;
        while (lev <= this.lastLevelField) {
            this.NewXHashMarks.addElement(new HashMarks(lev));
            ++lev;
        }
    }

    public void setNoGrid() {
        this.drawGrid = false;
    }

    public void setNoHashMarks() {
        this.drawHash = false;
    }

    public String longestMonthLabelToString() {
        String labelString = null;
        String maxLabelString = null;
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(4);
        this.C.setTime(this.Ch.TStamps[0]);
        int start_year = this.C.get(1);
        int start_month = this.C.get(2);
        this.C.setTime(this.Ch.TStamps[this.Ch.TStampsCount - 1]);
        int end_year = this.C.get(1);
        int end_month = this.C.get(2);
        int year_count = end_year - start_year;
        int month_count = year_count * 12 + end_month + 1 - start_month;
        if (month_count > 12) {
            month_count = 12;
        }
        if (this.test) {
            System.out.println("months " + start_month + " " + end_month);
        }
        if (this.test) {
            System.out.println("years " + start_year + " " + end_year);
        }
        if (this.test) {
            System.out.println("************ months **** " + month_count);
        }
        int maxStringLength = 0;
        int i = 0;
        while (i < month_count) {
            labelString = e.fieldLabels[(start_month + i) % 12];
            if (maxStringLength < labelString.length()) {
                maxStringLength = labelString.length();
                maxLabelString = labelString;
            }
            ++i;
        }
        return maxLabelString;
    }

    public String labelToString(int current_level_field, int start_position) {
        Object labelstring = null;
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(current_level_field);
        int field_modulus = e.field_modulus;
        return this.labelToString(current_level_field, field_modulus, start_position);
    }

    public String labelToString(int current_level_field, int field_modulus, int start_position) {
        boolean test = false;
        String labelstring = null;
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(current_level_field);
        switch (e.label) {
            case 3: {
                if (test) {
                    System.out.println("labelToString: HOURS");
                }
                labelstring = Integer.toString(field_modulus);
                switch (e.field) {
                    case 10: {
                        if (field_modulus != 0) break;
                        int hour_of_day = this.C.get(11);
                        e.ampmIndex = hour_of_day >= 12 ? 1 : 0;
                        labelstring = Integer.toString(12) + " " + e.ampmLabels[e.ampmIndex];
                        break;
                    }
                }
                break;
            }
            case 6: 
            case 61: 
            case 62: {
                if (test) {
                    System.out.println("labelToString: MONTHS");
                }
                labelstring = e.fieldLabels[field_modulus];
                break;
            }
            case 81: {
                if (test) {
                    System.out.println("labelToString: YEARS");
                }
                labelstring = Integer.toString(field_modulus);
                if (start_position == 0 || labelstring.length() != 4) break;
                labelstring = "'" + labelstring.substring(2, 4);
                break;
            }
            default: {
                labelstring = Integer.toString(field_modulus);
            }
        }
        return labelstring;
    }

    private String labelToStringWeek(int current_level_field, int field_modulus) {
        String labelstring = null;
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(current_level_field);
        e = (DimensionElement)this.FreqDim.elementAt(3);
        switch (e.label) {
            case 4: {
                labelstring = e.fieldLabels[field_modulus];
                break;
            }
        }
        return labelstring;
    }

    private String labelToStringWeek() {
        Object labelstring = null;
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(3);
        return this.labelToStringWeek(3, e.field_modulus2);
    }

    private int getLabelDelta(String labelstring, int last_index, int index, int label_justify) {
        int x_width = this.xval_int[index] - this.xval_int[last_index];
        int delta = 0;
        int labelWidth = this.fontmet.stringWidth(labelstring);
        switch (label_justify) {
            case 2: {
                delta = 0;
                break;
            }
            case 1: {
                delta = x_width > labelWidth ? (x_width - labelWidth) / 2 : 0;
            }
        }
        return delta;
    }

    private void XLabelBottomUserDefined(Graphics2D g2) {
        int delta = 0;
        int labelHeight = this.fontmet.getHeight();
        int k = 0;
        g2.setFont(this.timeAxisD.getFont());
        g2.setColor(this.timeAxisD.getColor());
        int i = 0;
        while (i < this.Ch.TStampsCount) {
            if (!this.Ch.UserXLabel[k].tstamp.after(this.Ch.TStamps[i])) {
                int labelWidth = this.fontmet.stringWidth(this.Ch.UserXLabel[k].str);
                if (i + 1 < this.xval_int.length) {
                    int interval_width = this.xval_int[i + 1] - this.xval_int[i];
                    delta = (interval_width - labelWidth) / 2;
                }
                g2.drawString(this.Ch.UserXLabel[k].str, this.xval_int[i] + delta, this.Ch.displayHeight - this.Ch.border_bottom + labelHeight);
                if (k == this.Ch.UserXLabel.length) {
                    return;
                }
                ++k;
            }
            if (k >= this.Ch.UserXLabel.length) break;
            ++i;
        }
    }

    private int getLabelWidthBorder(int start_index, int end_index) {
        if (this.Ch.containsEnabledBarType() && this.Ch.useIntervalMethod()) {
            return AxisUtil.getLabelWidth(this.xval_int, start_index, end_index, this.Ch.XAxisCount, this.Ch.border_left, (int)this.sc_Displaywidth, this.x_coordinate_spread);
        }
        boolean x_width = false;
        if (start_index == this.xval_int.length - 1 || end_index >= this.xval_int.length) {
            return 2 * this.Ch.border_right;
        }
        return AxisUtil.getLabelWidth(this.xval_int, start_index, end_index, this.Ch.XAxisCount, this.Ch.border_left, (int)this.sc_Displaywidth, this.x_coordinate_spread);
    }

    private void XLabelBottomGrid(Graphics2D g2, int current_level_field, int index, boolean thresholdGridStyle, GridDesc userXGrid, BasicStroke defaultStroke, BasicStroke dashedStroke, BasicStroke dashedStroke2) {
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(current_level_field);
        if (e.gridOn) {
            g2.setColor(userXGrid.getColor());
            int switchFlag = e.gridline;
            if (thresholdGridStyle) {
                switchFlag = userXGrid.getGridStyleThreshold();
            }
            switch (switchFlag) {
                case 1: {
                    g2.setStroke(defaultStroke);
                    break;
                }
                case 2: {
                    g2.setStroke(dashedStroke);
                    break;
                }
                case 3: {
                    g2.setStroke(dashedStroke2);
                }
            }
            g2.drawLine(this.xval_int[index], this.Ch.border_top, this.xval_int[index], this.Ch.displayHeight - this.Ch.border_bottom);
            g2.setStroke(defaultStroke);
        }
    }

    private double getXIntervalWidth(int iwidth) {
        if (this.test) {
            System.out.println(" getXIntervalWidth: iwidth = " + iwidth);
        }
        double width = iwidth;
        if (this.test) {
            System.out.println(" getXIntervalWidth:  = " + this.sc_Displaywidth + " " + this.Ch.TStampsCount);
        }
        width = width * this.sc_Displaywidth / (double)this.Ch.XAxisCount;
        return width;
    }

    public double estimateWidth(int level) {
        if (!this.timeAxisD.getDrawLabel()) {
            return 0.0;
        }
        if (this.Ch.TStampsCount == 1) {
            return this.getXIntervalWidth(1);
        }
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(level);
        int checkLevels = 5 - level + 1;
        DimensionElement[] e2 = new DimensionElement[checkLevels];
        int[] calendar_field2 = new int[checkLevels];
        int[] field_modulus2 = new int[checkLevels];
        int z = 0;
        while (z < checkLevels) {
            e2[z] = (DimensionElement)this.FreqDim.elementAt(level + z);
            calendar_field2[z] = e2[z].field;
            ++z;
        }
        Calendar Ctemp = Calendar.getInstance();
        Ctemp.setTime(this.Ch.TStamps[0]);
        int calendar_field = e.field;
        int field_modulus = Ctemp.get(calendar_field);
        int z2 = 0;
        while (z2 < checkLevels) {
            field_modulus2[z2] = Ctemp.get(calendar_field2[z2]);
            ++z2;
        }
        int i = 0;
        while (this.noChange(checkLevels, Ctemp, calendar_field2, field_modulus2)) {
            if (i == this.Ch.TStampsCount - 1) {
                if (this.test) {
                    System.out.println("estimateWidth(): i == Ch.TStampsCount " + i + " " + this.getXIntervalWidth(i));
                }
                return this.getXIntervalWidth(i);
            }
            Ctemp.setTime(this.Ch.TStamps[++i]);
        }
        if (this.test) {
            System.out.println("estimateWidth(): first change " + i);
        }
        field_modulus = Ctemp.get(calendar_field);
        int z3 = 0;
        while (z3 < checkLevels) {
            field_modulus2[z3] = Ctemp.get(calendar_field2[z3]);
            ++z3;
        }
        int start_index = i;
        while (this.noChange(checkLevels, Ctemp, calendar_field2, field_modulus2)) {
            if (i == this.Ch.TStampsCount - 1) {
                int last_interval;
                if (this.test) {
                    System.out.println("estimateWidth(): i == Ch.TStampsCount (2) " + i + " " + start_index + " " + this.getXIntervalWidth(i));
                }
                if ((last_interval = i - start_index) > start_index) {
                    return this.getXIntervalWidth(last_interval);
                }
                return this.getXIntervalWidth(start_index);
            }
            Ctemp.setTime(this.Ch.TStamps[++i]);
        }
        if (this.test) {
            System.out.println("estimateWidth(): next change " + i);
            System.out.println("estimateWidth(): i " + i + " " + start_index);
        }
        return this.getXIntervalWidth(i - start_index);
    }

    private boolean noChange(int checkLevels, Calendar Ctemp, int[] calendar_field2, int[] field_modulus2) {
        int z = 0;
        while (z < checkLevels) {
            if (Ctemp.get(calendar_field2[z]) != field_modulus2[z]) {
                return false;
            }
            ++z;
        }
        return true;
    }

    public int estimateTimestampDifference(int lev) {
        if (this.Ch.TStampsCount < 3) {
            return -1;
        }
        DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
        int calendar_field = current.field;
        this.C.setTime(this.Ch.TStamps[1]);
        int field_modulus1 = this.C.get(calendar_field);
        this.C.setTime(this.Ch.TStamps[2]);
        int field_modulus2 = this.C.get(calendar_field);
        if (field_modulus2 < field_modulus1) {
            switch (current.field) {
                case 12: 
                case 13: {
                    field_modulus2 += 60;
                    break;
                }
                case 11: {
                    field_modulus2 += 24;
                    break;
                }
                case 10: {
                    field_modulus2 += 24;
                    break;
                }
                case 5: {
                    field_modulus2 += 31;
                    break;
                }
                case 2: {
                    field_modulus2 += 12;
                }
            }
        }
        return Math.abs(field_modulus2 - field_modulus1);
    }

    protected int estimateFrequency() {
        if (this.Ch.TStampsCount == 2) {
            return this.getTimeSpanFrequency();
        }
        if (this.Ch.TStampsCount < 3) {
            return -1;
        }
        boolean field_change = false;
        int lev = this.firstLevelField;
        while (lev <= this.lastLevelField) {
            DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
            int calendar_field = current.field;
            this.C.setTime(this.Ch.TStamps[0]);
            int field_modulus = this.C.get(calendar_field);
            this.C.setTime(this.Ch.TStamps[1]);
            int field_modulus1 = this.C.get(calendar_field);
            this.C.setTime(this.Ch.TStamps[2]);
            int field_modulus2 = this.C.get(calendar_field);
            if (field_modulus != field_modulus1 && field_modulus1 != field_modulus2) {
                field_change = true;
                if (!this.test) break;
                System.out.println("estimateFrequency(): change at" + lev);
                break;
            }
            ++lev;
        }
        if (!field_change) {
            return -1;
        }
        return lev;
    }

    public int getTimeSpanFrequency() {
        boolean field_change = false;
        int lev = this.firstLevelField;
        while (lev <= this.lastLevelField) {
            DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
            int calendar_field = current.field;
            if (this.Ch.TStamps.length > 1) {
                this.C.setTime(this.Ch.TStamps[1]);
            } else {
                this.C.setTime(this.Ch.TStamps[0]);
            }
            int field_modulus = this.C.get(calendar_field);
            this.C.setTime(this.Ch.TStamps[this.Ch.TStampsCount - 1]);
            int field_modulus1 = this.C.get(calendar_field);
            if (field_modulus != field_modulus1) {
                field_change = true;
                break;
            }
            if (this.Ch.TStampsCount >= 3) {
                this.C.setTime(this.Ch.TStamps[2]);
                int field_modulus2 = this.C.get(calendar_field);
                if (field_modulus2 != field_modulus) {
                    field_change = true;
                    break;
                }
            }
            ++lev;
        }
        if (!field_change) {
            return -1;
        }
        return lev;
    }

    public int getLastVariableLevel() {
        if (this.test) {
            System.out.println("getLastVariableLevel()");
        }
        int firstLevelFieldTemp = this.firstLevelField;
        if (this.extendedLabels && this.firstLevelField_extended < this.firstLevelField) {
            firstLevelFieldTemp = this.firstLevelField_extended;
        }
        int lev = this.lastLevelField;
        while (lev >= firstLevelFieldTemp) {
            DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
            int calendar_field = current.field;
            if (this.test) {
                System.out.println("getLastVariableLevel(): check level " + lev);
            }
            this.C.setTime(this.Ch.TStamps[0]);
            int field_modulus = this.C.get(calendar_field);
            this.C.setTime(this.Ch.TStamps[this.Ch.TStampsCount - 1]);
            int field_modulus_last_tstamp = this.C.get(calendar_field);
            if (field_modulus != field_modulus_last_tstamp) {
                if (this.test) {
                    System.out.println(field_modulus + "  !=  " + field_modulus_last_tstamp);
                }
                if (!this.test) break;
                System.out.println("getLastVariableLevel(): Return " + current.name);
                break;
            }
            if (this.test) {
                System.out.println(field_modulus + "  ==  " + field_modulus_last_tstamp);
            }
            --lev;
        }
        return lev;
    }

    private String getInvariantLabel() {
        String labelstring = "";
        int lastVariableLevel = this.getLastVariableLevel();
        int firstInvariantLevel = 0;
        int lev = firstInvariantLevel = lastVariableLevel + 1;
        while (lev <= this.lastLevelField) {
            DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
            int calendar_field = current.field;
            this.C.setTime(this.Ch.TStamps[0]);
            int field_modulus = this.C.get(calendar_field);
            if (labelstring.length() != 0) {
                labelstring = labelstring + " ";
            }
            labelstring = labelstring + this.labelToString(lev, 0);
            if (this.test) {
                System.out.println("getInvariantLabel(): label is: " + labelstring);
            }
            ++lev;
        }
        return labelstring;
    }

    public void drawBuffer(Graphics2D g2, SVGChartGraphics svgG, boolean drawLabelsOnly, GridDesc userXGrid, BasicStroke defaultStroke, BasicStroke dashedStroke, BasicStroke dashedStroke2) {
        if (this.Ch.UserXLabelSet) {
            if (drawLabelsOnly) {
                this.XLabelBottomUserDefined(g2);
            }
        } else {
            boolean test = false;
            if (test) {
                this.dumpXLabels();
            }
            if (this.Ch.TStampsCount != 0 && this.timeAxisD.getDrawLabel()) {
                this.paintXLabels(g2, svgG, drawLabelsOnly, userXGrid, defaultStroke, dashedStroke, dashedStroke2);
                if (!this.Ch.containsBarType && !this.Ch.continuousTimeXAxis) {
                    this.paintXHashMarks(g2, svgG, userXGrid);
                }
            }
        }
    }

    private void setHashPeriod() {
        int numIntervals_int;
        int level = this.firstLevelField - 1;
        if (level < 0) {
            return;
        }
        HashMarks HM = (HashMarks)this.NewXHashMarks.elementAt(0);
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(level);
        double availableWidth = this.estimateWidth(level);
        if (availableWidth >= (double)this.minHashSpacing) {
            return;
        }
        if (this.test) {
            System.out.println("smartHashMarks(): availableWidth " + availableWidth);
        }
        if ((numIntervals_int = this.getIntervals(availableWidth, this.minHashSpacing)) < 0) {
            this.drawHash = false;
            return;
        }
        if (this.test) {
            System.out.println("smartHashMarks(): intervals " + numIntervals_int);
        }
        switch (e.field) {
            case 13: {
                if (numIntervals_int < this.relabelMinutesHash.length) {
                    HM.period = this.relabelMinutesHash[numIntervals_int];
                    break;
                }
                this.drawHash = false;
                break;
            }
            case 12: {
                if (numIntervals_int < this.relabelMinutesHash.length) {
                    HM.period = this.relabelMinutesHash[numIntervals_int];
                    break;
                }
                this.drawHash = false;
                break;
            }
            case 10: 
            case 11: {
                if (numIntervals_int < this.relabelHoursHash.length) {
                    HM.period = this.relabelHoursHash[numIntervals_int];
                    break;
                }
                this.drawHash = false;
                break;
            }
            case 5: {
                if (numIntervals_int < this.relabelDayHash.length) {
                    HM.period = this.relabelDayHash[numIntervals_int];
                    break;
                }
                this.drawHash = false;
                break;
            }
            case 2: {
                if (numIntervals_int < this.relabelMonthsHash.length) {
                    HM.period = this.relabelMonthsHash[numIntervals_int];
                    break;
                }
                this.drawHash = false;
                break;
            }
        }
        if (this.test) {
            System.out.println("smartHashMarks(): new period " + HM.period);
        }
    }

    public void SmartHashMarks() {
        this.initXHashMarks();
        if (this.Ch.continuousTimeXAxis) {
            return;
        }
        this.NewXHashMarks.addElement(new HashMarks(0));
        HashMarks HM = (HashMarks)this.NewXHashMarks.elementAt(0);
        if (this.firstLevelField - 1 < 0) {
            return;
        }
        DimensionElement first = (DimensionElement)this.FreqDim.elementAt(this.firstLevelField - 1);
        int calendar_field = first.field;
        this.C.setTime(this.Ch.TStamps[0]);
        first.field_modulus = this.C.get(calendar_field);
        if (this.test) {
            System.out.println("smartHashMarks(): first_fm " + first.field_modulus);
        }
        this.setHashPeriod();
        if (this.drawHash) {
            if (HM.period != 1) {
                this.C.setTime(this.Ch.TStamps[0]);
                int temp_field_modulus = this.C.get(calendar_field);
                HM.period_counter = (temp_field_modulus + 1) % HM.period;
                if (this.test) {
                    System.out.println("smartHashMarks(): temp_fm " + temp_field_modulus);
                }
                if (this.test) {
                    System.out.println("smartHashMarks(): period_counter " + HM.period_counter);
                }
            }
            int i = 1;
            while (i < this.Ch.TStampsCount) {
                this.C.setTime(this.Ch.TStamps[i]);
                if (this.C.get(calendar_field) != first.field_modulus) {
                    if (HM.period_counter == 0) {
                        if (this.test) {
                            System.out.println("smartHash(): " + this.Ch.TStamps[i]);
                        }
                        if (this.test) {
                            System.out.println("smartHash(): " + i);
                        }
                        HM.VMarks.addElement(new Mark(i));
                        if (this.test) {
                            System.out.println("smartHashMarks(): [" + i + "]");
                        }
                    }
                    HM.period_counter = (HM.period_counter + 1) % HM.period;
                }
                first.field_modulus = this.C.get(calendar_field);
                ++i;
            }
        }
    }

    public void SmartLabel() {
        int lev;
        LineLabel LL;
        boolean testSmartLabel = false;
        boolean test = false;
        if (!this.timeAxisD.getDrawLabel()) {
            return;
        }
        if (this.FreqDim.size() < 1) {
            return;
        }
        boolean delta = false;
        int calendar_field = 0;
        int calendar_field2 = 0;
        DimensionElement firstExtended = (DimensionElement)this.FreqDim.elementAt(this.firstLevelField);
        boolean handleExtendedLabels = false;
        this.levelDifference = 0;
        if (this.extendedLabels && this.firstLevelField_extended < this.firstLevelField) {
            handleExtendedLabels = true;
            this.levelDifference = this.firstLevelField - this.firstLevelField_extended;
            firstExtended = (DimensionElement)this.FreqDim.elementAt(this.firstLevelField_extended);
        }
        DimensionElement first = (DimensionElement)this.FreqDim.elementAt(this.firstLevelField);
        int secondLevelField = this.firstLevelField + 1;
        if (secondLevelField > this.lastLevelField_default) {
            secondLevelField = this.lastLevelField_default;
        }
        calendar_field = first.field;
        this.C.setTime(this.Ch.TStamps[0]);
        first.updateFieldModulus(this.C);
        if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && first.field == 5) {
            first.updateFieldModulus2(this.C);
        }
        first.period_counter = 0;
        boolean last_i = false;
        int[] last_index = new int[this.FreqDim.size()];
        int i = 0;
        while (i < this.FreqDim.size()) {
            last_index[i] = 0;
            ++i;
        }
        this.initXLabels();
        if (this.XLabelDimension.size() < 1) {
            return;
        }
        if (handleExtendedLabels && (firstExtended.label == 3 || firstExtended.label == 2 || firstExtended.label == 1)) {
            LineLabel LL2 = (LineLabel)this.XLabelDimension.elementAt(0);
            LL2.alignTStampLabels = true;
        }
        if (this.testXLabel) {
            System.out.println("*** dumpXL start ***");
            this.dumpXLabels("afterInit");
        }
        this.C.setTime(this.Ch.TStamps[0]);
        long prevMillis = this.C.getTimeInMillis();
        int temp_field_modulus = this.C.get(calendar_field);
        int field_modulus_interval_begin = this.C.get(calendar_field);
        int field_modulus_interval_begin2 = 0;
        if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && calendar_field == 5) {
            field_modulus_interval_begin2 = this.C.get(calendar_field2);
        }
        last_index[this.firstLevelField] = 0;
        int field_modulus_interval_begin_extended = this.C.get(calendar_field);
        if (first.period != 1) {
            this.C.setTime(this.Ch.TStamps[0]);
            temp_field_modulus = this.C.get(calendar_field);
            first.period_counter = (temp_field_modulus + 1) % first.period;
        }
        if (this.Ch.continuousTimeXAxis || this.firstLevelField == this.estimateFrequency()) {
            LL = (LineLabel)this.XLabelDimension.elementAt(0 + this.levelDifference);
            LL.matchTStamps = true;
            LL.alignTStampLabels = true;
        }
        if (first.period != 1 || first.label == 3 || first.label == 2 || first.label == 1) {
            LL = (LineLabel)this.XLabelDimension.elementAt(0 + this.levelDifference);
            LL.alignTStampLabels = true;
        }
        int periodTrigger = first.period;
        if (first.field == 10 && periodTrigger == 8) {
            periodTrigger = 4;
        }
        long spanMillis = 0L;
        long maxMillisInterval = CalendarUtil.getMillis(first.field);
        String labelstring = "";
        i = 1;
        while (i < this.Ch.TStampsCount) {
            this.C.setTime(this.Ch.TStamps[i]);
            long currentMillis = this.C.getTimeInMillis();
            spanMillis = currentMillis - prevMillis;
            if (this.C.get(first.field) != first.field_modulus || spanMillis > maxMillisInterval) {
                prevMillis = currentMillis;
                if (first.period_counter == 0) {
                    if (this.Ch.dls && first.field == 10 && (first.field_modulus + 1) % periodTrigger != 0) {
                        --first.period_counter;
                    } else {
                        labelstring = this.labelToString(this.firstLevelField, field_modulus_interval_begin, last_index[this.firstLevelField]);
                        LL = (LineLabel)this.XLabelDimension.elementAt(0 + this.levelDifference);
                        if (!this.timeAxisD.getDayOfWeekOnly() || first.field != 5) {
                            LL.VLabel.addElement(new Label(last_index[this.firstLevelField], i, labelstring));
                        }
                        if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && first.field == 5) {
                            labelstring = this.labelToStringWeek(this.firstLevelField, field_modulus_interval_begin2);
                            if (this.timeAxisD.getDayOfWeekOnly()) {
                                LL.VLabel.addElement(new Label(last_index[this.firstLevelField], i, labelstring));
                            } else {
                                LL.VLabel2.addElement(new Label(last_index[this.firstLevelField], i, labelstring));
                            }
                        }
                        if (handleExtendedLabels) {
                            this.addExtendedLabels(this.firstLevelField, i, last_index[this.firstLevelField], false);
                        }
                    }
                }
                boolean anyField = false;
                int firstLevelFieldTemp = this.firstLevelField;
                lev = this.lastLevelField;
                while (lev >= firstLevelFieldTemp + 1) {
                    DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
                    if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && current.field == 5) {
                        current.updateFieldModulus2(this.C);
                    }
                    if (this.C.get(current.field) != current.field_modulus || anyField) {
                        anyField = true;
                        labelstring = this.labelToString(lev, last_index[lev]);
                        LL = (LineLabel)this.XLabelDimension.elementAt(lev - this.firstLevelField + this.levelDifference);
                        if (!this.timeAxisD.getDayOfWeekOnly() || current.field != 5) {
                            LL.VLabel.addElement(new Label(last_index[lev], i, labelstring));
                        }
                        if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && current.field == 5) {
                            labelstring = this.labelToStringWeek();
                            if (this.timeAxisD.getDayOfWeekOnly()) {
                                LL.VLabel.addElement(new Label(last_index[lev], i, labelstring));
                            } else {
                                LL.VLabel2.addElement(new Label(last_index[lev], i, labelstring));
                            }
                        }
                        current.updateFieldModulus(this.C);
                        if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && current.field == 5) {
                            current.updateFieldModulus2(this.C);
                        }
                        last_index[lev] = i;
                    }
                    --lev;
                }
                first.updateFieldModulus(this.C);
                if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && calendar_field == 5) {
                    first.updateFieldModulus2(this.C);
                }
                if (first.period_counter == 0) {
                    field_modulus_interval_begin = first.field_modulus;
                    if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && calendar_field == 5) {
                        field_modulus_interval_begin2 = first.field_modulus2;
                    }
                    last_index[this.firstLevelField] = i;
                }
                first.period_counter = (first.period_counter + 1) % first.period;
            }
            ++i;
        }
        if (this.testXLabel) {
            System.out.println("*** dumpXL middle SmartLabel() ***");
        }
        if (this.testXLabel) {
            this.dumpXLabels();
        }
        int lastVariableLevel = this.getLastVariableLevel();
        if (first.period > 1) {
            labelstring = this.labelToString(this.firstLevelField, field_modulus_interval_begin, last_index[this.firstLevelField]);
            LL = (LineLabel)this.XLabelDimension.elementAt(0 + this.levelDifference);
            if (!this.timeAxisD.getDayOfWeekOnly() || first.field != 5) {
                LL.VLabel.addElement(new Label(last_index[this.firstLevelField], i, labelstring));
            }
            if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && first.field == 5) {
                labelstring = this.labelToStringWeek(this.firstLevelField, field_modulus_interval_begin2);
                if (this.timeAxisD.getDayOfWeekOnly()) {
                    LL.VLabel.addElement(new Label(last_index[this.firstLevelField], i, labelstring));
                } else {
                    LL.VLabel2.addElement(new Label(last_index[this.firstLevelField], i, labelstring));
                }
            }
            if (handleExtendedLabels) {
                this.addExtendedLabels(this.firstLevelField, i, last_index[this.firstLevelField], false);
            }
            if (first.field_modulus != field_modulus_interval_begin) {
                labelstring = this.labelToString(this.firstLevelField, first.field_modulus, last_index[this.firstLevelField]);
                if (!this.timeAxisD.getDayOfWeekOnly() || first.field != 5) {
                    LL.VLabel.addElement(new Label(i - 1, i, labelstring));
                }
                if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && first.field == 5) {
                    labelstring = this.labelToStringWeek(this.firstLevelField, first.field_modulus2);
                    if (this.timeAxisD.getDayOfWeekOnly()) {
                        LL.VLabel.addElement(new Label(i - 1, i, labelstring));
                    } else {
                        LL.VLabel2.addElement(new Label(i - 1, i, labelstring));
                    }
                }
                if (handleExtendedLabels) {
                    if (LL.VLabel.size() >= 2) {
                        int penultimate_index = LL.VLabel.size() - 2;
                        --((Label)LL.VLabel.elementAt((int)penultimate_index)).index;
                    }
                    this.addExtendedLabels(this.firstLevelField, i, i - 1, true);
                }
                ((Label)LL.VLabel.elementAt(LL.VLabel.size() - 1)).setOffCycle();
            }
            if (this.testXLabel) {
                System.out.println("*** dumpXL interval end SmartLabel() ***");
            }
            if (this.testXLabel) {
                this.dumpXLabels();
            }
        }
        int firstLevelFieldTemp = this.firstLevelField;
        if (first.period > 1) {
            firstLevelFieldTemp = this.firstLevelField + 1;
        }
        if (this.testXLabel) {
            System.out.println("*** flf ***" + this.firstLevelField);
        }
        if (this.testXLabel) {
            System.out.println("*** lvf ***" + lastVariableLevel);
        }
        int minIndex = 0;
        lev = firstLevelFieldTemp;
        while (lev <= lastVariableLevel) {
            DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
            if (current.period_counter == 0) {
                labelstring = lev == this.firstLevelField ? this.labelToString(this.firstLevelField, field_modulus_interval_begin, last_index[this.firstLevelField]) : this.labelToString(lev, last_index[lev]);
                LL = (LineLabel)this.XLabelDimension.elementAt(lev - this.firstLevelField + this.levelDifference);
                minIndex = last_index[lev];
                if (!this.timeAxisD.getDayOfWeekOnly() || current.field != 5) {
                    LL.VLabel.addElement(new Label(minIndex, i, labelstring));
                }
                if ((this.timeAxisD.getDayOfWeek() || this.timeAxisD.getDayOfWeekOnly()) && current.field == 5) {
                    labelstring = lev == this.firstLevelField ? this.labelToStringWeek(this.firstLevelField, field_modulus_interval_begin2) : this.labelToStringWeek(lev, current.field_modulus2);
                    if (this.timeAxisD.getDayOfWeekOnly()) {
                        LL.VLabel.addElement(new Label(minIndex, i, labelstring));
                    } else {
                        LL.VLabel2.addElement(new Label(minIndex, i, labelstring));
                    }
                }
                if (handleExtendedLabels) {
                    if (LL.VLabel.size() >= 2) {
                        int penultimate_index = LL.VLabel.size() - 2;
                        --((Label)LL.VLabel.elementAt((int)penultimate_index)).index;
                    }
                    this.addExtendedLabels(this.firstLevelField, i, minIndex, true);
                }
            }
            ++lev;
        }
        this.insertInvariantLabels();
        if (this.testXLabel) {
            this.dumpXLabels("after SmartLabel()");
        }
        LineLabel lastIV = (LineLabel)this.XLabelDimension.elementAt(this.XLabelDimension.size() - 1);
    }

    private void addExtendedLabels(int firstLevelField, int i, int index_interval_begin, boolean lastLabel) {
        if (this.extendedLabels) {
            if (index_interval_begin < this.Ch.TStamps.length) {
                this.C.setTime(this.Ch.TStamps[index_interval_begin]);
            }
            int lev = firstLevelField - 1;
            while (lev >= this.firstLevelField_extended) {
                DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
                int current_field_modulus = this.C.get(current.field);
                String labelstring = this.labelToString(lev, current_field_modulus, index_interval_begin);
                LineLabel LL = (LineLabel)this.XLabelDimension.elementAt(lev - this.firstLevelField_extended);
                LL.VLabel.addElement(new Label(index_interval_begin, i, labelstring));
                if (lastLabel) {
                    ((Label)LL.VLabel.elementAt(LL.VLabel.size() - 1)).setOffCycle();
                    if (LL.VLabel.size() >= 2) {
                        int penultimate_index = LL.VLabel.size() - 2;
                        --((Label)LL.VLabel.elementAt((int)penultimate_index)).index;
                    }
                }
                --lev;
            }
            if (i < this.Ch.TStamps.length) {
                this.C.setTime(this.Ch.TStamps[i]);
            }
        }
    }

    private final class Mark {
        int index;

        public Mark(int index) {
            this.index = index;
        }
    }

    private final class Label {
        int index;
        int start_index;
        String labelString;
        boolean off_cycle = false;
        boolean thresholdGridStyle = false;

        public Label(int index) {
            this.index = index;
        }

        public Label(int index, String labelString) {
            this.index = index;
            this.labelString = labelString;
        }

        public Label(int start_index, int index, String labelString) {
            this.start_index = start_index;
            this.index = index;
            this.labelString = labelString;
        }

        public void setOffCycle() {
            this.off_cycle = true;
        }

        public void setGridThreshold() {
            this.thresholdGridStyle = true;
        }
    }

    private final class LineLabel {
        int level;
        Vector VLabel = new Vector();
        Vector VLabel2 = new Vector();
        String dimensionName = "";
        boolean matchTStamps = false;
        boolean alignTStampLabels = false;

        public LineLabel(int level, String name) {
            this.level = level;
            this.dimensionName = name;
        }

        public void dumpLineLabels() {
            System.out.print(" Level " + this.level + " " + this.dimensionName + " size is " + this.VLabel.size());
            int i = 0;
            while (i < this.VLabel.size()) {
                System.out.print(" [" + ((Label)this.VLabel.elementAt((int)i)).start_index + "," + ((Label)this.VLabel.elementAt((int)i)).index + "]: " + ((Label)this.VLabel.elementAt((int)i)).labelString);
                if (i % 5 == 0 && i > 0) {
                    System.out.println();
                    System.out.print("        ");
                }
                ++i;
            }
            i = 0;
            while (i < this.VLabel2.size()) {
                System.out.print(" *[" + ((Label)this.VLabel2.elementAt((int)i)).start_index + "," + ((Label)this.VLabel2.elementAt((int)i)).index + "]: " + ((Label)this.VLabel2.elementAt((int)i)).labelString);
                if (i % 5 == 0 && i > 0) {
                    System.out.println();
                    System.out.print("        ");
                }
                ++i;
            }
            System.out.println();
        }
    }

    private final class HashMarks {
        int level;
        Vector VMarks = new Vector();
        int period = 1;
        int period_counter = 0;

        public HashMarks(int level) {
            this.level = level;
        }
    }
}

