/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.text.NumberFormat;
import java.util.Locale;
import oracle.charts.internal.TimeIntervalFormat;
import oracle.charts.types.NumAxisDesc;
import oracle.charts.types.UserDefinedFormat;

public final class NumericalFormat {
    private static String formatDoubleWithMaxFrac(Locale chartLocale, NumberFormat yLabelNumberFormat, Double tempDouble) {
        String ylabel;
        if (yLabelNumberFormat.getMaximumFractionDigits() == 0) {
            if (tempDouble.longValue() <= Integer.MAX_VALUE && tempDouble.longValue() >= Integer.MIN_VALUE) {
                NumberFormat nf = NumberFormat.getIntegerInstance(chartLocale);
                ylabel = nf.format(tempDouble);
            } else {
                ylabel = yLabelNumberFormat.format(tempDouble);
            }
        } else {
            ylabel = yLabelNumberFormat.format(tempDouble);
        }
        return ylabel;
    }

    public static String formatNumber(Locale chartLocale, NumAxisDesc numAxisD, NumberFormat continuousAxisNumberFormat, Double tempDouble, boolean isIntegerLabels, int sigDigits) {
        String ylabel2;
        if (continuousAxisNumberFormat != null) {
            String ylabel2 = continuousAxisNumberFormat.format(tempDouble);
            return ylabel2;
        }
        NumberFormat yLabelNumberFormat = numAxisD.getNumberFormat();
        UserDefinedFormat yLabelUserFormat = numAxisD.getUserDefinedFormat();
        boolean timeIntervalFormat = numAxisD.getTimeIntervalFormat();
        long tempLong = tempDouble.longValue();
        if (timeIntervalFormat) {
            ylabel2 = TimeIntervalFormat.formatNumber(numAxisD.getTimeIntervalFormatNLSPosDays(), numAxisD.getTimeIntervalFormatNLSNegDays(), tempDouble);
        } else if (yLabelNumberFormat != null) {
            ylabel2 = NumericalFormat.formatDoubleWithMaxFrac(chartLocale, yLabelNumberFormat, tempDouble);
        } else if (yLabelUserFormat != null) {
            ylabel2 = yLabelUserFormat.formatNumber(tempDouble);
        } else if (isIntegerLabels) {
            if (tempLong <= Integer.MAX_VALUE && tempLong >= Integer.MIN_VALUE) {
                NumberFormat nf = NumberFormat.getIntegerInstance(chartLocale);
                ylabel2 = nf.format(tempDouble);
            } else {
                ylabel2 = Long.toString(tempLong);
            }
        } else {
            NumberFormat nf = NumberFormat.getInstance(chartLocale);
            nf.setMaximumFractionDigits(sigDigits);
            nf.setMinimumFractionDigits(sigDigits);
            ylabel2 = nf.format(tempDouble);
        }
        return ylabel2;
    }

    public static String formatNumber2(Locale chartLocale, NumAxisDesc numAxisD, Double tempDouble) {
        NumberFormat yLabelNumberFormat = numAxisD.getNumberFormat();
        UserDefinedFormat yLabelUserFormat = numAxisD.getUserDefinedFormat();
        boolean timeIntervalFormat = numAxisD.getTimeIntervalFormat();
        String ylabel = timeIntervalFormat ? TimeIntervalFormat.formatNumber(numAxisD.getTimeIntervalFormatNLSPosDays(), numAxisD.getTimeIntervalFormatNLSNegDays(), tempDouble) : (yLabelUserFormat != null ? yLabelUserFormat.formatNumber(tempDouble) : (yLabelNumberFormat != null ? NumericalFormat.formatDoubleWithMaxFrac(chartLocale, yLabelNumberFormat, tempDouble) : Double.toString(tempDouble.longValue())));
        return ylabel;
    }

    public static String formatPointLabel(Locale chartLocale, NumAxisDesc numAxisD, Double tempDouble) {
        String ylabel;
        NumberFormat yLabelNumberFormat = numAxisD.getNumberFormat();
        UserDefinedFormat yLabelUserFormat = numAxisD.getUserDefinedFormat();
        if (numAxisD.getTimeIntervalFormat()) {
            ylabel = TimeIntervalFormat.formatNumber(numAxisD.getTimeIntervalFormatNLSPosDays(), numAxisD.getTimeIntervalFormatNLSNegDays(), tempDouble);
        } else if (yLabelUserFormat != null) {
            ylabel = yLabelUserFormat.formatNumber(tempDouble);
        } else if (yLabelNumberFormat != null) {
            ylabel = yLabelNumberFormat.format(tempDouble);
        } else {
            NumberFormat nf = NumberFormat.getInstance(chartLocale);
            ylabel = nf.format(tempDouble);
        }
        return ylabel;
    }
}

