/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.Allocation;
import oracle.AWXML.AllocationArgument;
import oracle.AWXML.AllocationHierarchySpecification;
import oracle.AWXML.AllocationOperator;
import oracle.AWXML.BaseObject;
import oracle.AWXML.Dimension;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.Parameter;
import oracle.AWXML.SolveDefinition;

public class AllocationDefinition
extends SolveDefinition {
    protected Vector m_allocations = new Vector(0);
    protected String m_sourceVal = "CURRENT";
    protected String m_deadLock = "SKIP";
    protected String m_childLock = "DETECT";

    public AllocationDefinition() {
    }

    public AllocationDefinition(BaseObject baseObject) {
        super(baseObject);
    }

    public String getSourceVal() {
        return this.m_sourceVal;
    }

    public void setSourceVal(String string) {
        this.m_sourceVal = string;
    }

    public String getDeadLock() {
        return this.m_deadLock;
    }

    public void setDeadLock(String string) {
        this.m_deadLock = string;
    }

    public String getChildLock() {
        return this.m_childLock;
    }

    public void setChildLock(String string) {
        this.m_childLock = string;
    }

    public String WriteToXML() {
        String string = null;
        string = AllocationDefinition.TAB() + this.WriteElementStart("AllocationDefinition");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + AllocationDefinition.TAB() + this.WriteElementEndTag("AllocationDefinition") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        if (this.m_sourceVal != null) {
            string = string == null ? this.WriteAsAttribute("SourceVal", this.m_sourceVal) : string + this.WriteAsAttribute("SourceVal", this.m_sourceVal);
        }
        if (this.m_childLock != null) {
            string = string == null ? this.WriteAsAttribute("ChildLock", this.m_childLock) : string + this.WriteAsAttribute("ChildLock", this.m_childLock);
        }
        if (this.m_deadLock != null) {
            string = string == null ? this.WriteAsAttribute("DeadLock", this.m_deadLock) : string + this.WriteAsAttribute("DeadLock", this.m_deadLock);
        }
        return string;
    }

    public String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_allocations.iterator();
        while (iterator.hasNext()) {
            Allocation allocation = (Allocation)iterator.next();
            if (string == null) {
                string = AllocationDefinition.TAB() + this.WriteElementStart("Allocation") + s_EndTag + s_NEWLINE;
                ++s_Indent;
                string = string + allocation.WriteToXML();
                --s_Indent;
                string = string + AllocationDefinition.TAB() + this.WriteElementEndTag("Allocation") + s_NEWLINE;
                continue;
            }
            string = string + AllocationDefinition.TAB() + this.WriteElementStart("Allocation") + s_EndTag + s_NEWLINE;
            ++s_Indent;
            string = string + allocation.WriteToXML();
            --s_Indent;
            string = string + AllocationDefinition.TAB() + this.WriteElementEndTag("Allocation") + s_NEWLINE;
        }
        return string;
    }

    public void addAllocation(Allocation allocation) {
        this.m_allocations.add(allocation);
        allocation.setOwner(this);
    }

    public void addAllocationAfter(Allocation allocation, BaseObject baseObject) {
        int n;
        if (baseObject instanceof Allocation) {
            n = this.m_allocations.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "ALLOCATIONSPECIFICATIONS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{allocation.getId(), "ALLOCATION"});
        }
        this.m_allocations.add(n + 1, allocation);
        allocation.setOwner(this);
    }

    public void addAllocationBefore(Allocation allocation, BaseObject baseObject) {
        int n;
        if (baseObject instanceof Allocation) {
            n = this.m_allocations.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "ALLOCATIONSPECIFICATIONS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{allocation.getId(), "ALLOCATION"});
        }
        this.m_allocations.add(n, allocation);
        allocation.setOwner(this);
    }

    public void addAllocationFirst(Allocation allocation) {
        this.m_allocations.add(0, allocation);
        allocation.setOwner(this);
    }

    public void removeAllocation(Allocation allocation) {
        this.m_allocations.remove(allocation);
    }

    public Vector getAllocations() {
        return this.m_allocations;
    }

    public AllocationHierarchySpecification createAllocateHierarchySpecification() {
        AllocationHierarchySpecification allocationHierarchySpecification = new AllocationHierarchySpecification(this);
        this.addAllocation(allocationHierarchySpecification);
        allocationHierarchySpecification.setName("Relation" + this.m_allocations.size());
        allocationHierarchySpecification.setCalculationOrder(this.m_allocations.size());
        return allocationHierarchySpecification;
    }

    public AllocationHierarchySpecification createAllocateHierarchySpecificationAfter(Allocation allocation) {
        AllocationHierarchySpecification allocationHierarchySpecification = new AllocationHierarchySpecification(this);
        this.addAllocationAfter(allocationHierarchySpecification, allocation);
        allocationHierarchySpecification.setName("Relation" + this.m_allocations.size());
        allocationHierarchySpecification.setCalculationOrder(this.m_allocations.size());
        return allocationHierarchySpecification;
    }

    public AllocationHierarchySpecification createAllocateHierarchySpecificationBefore(Allocation allocation) {
        AllocationHierarchySpecification allocationHierarchySpecification = new AllocationHierarchySpecification(this);
        this.addAllocationBefore(allocationHierarchySpecification, allocation);
        allocationHierarchySpecification.setName("Relation" + this.m_allocations.size());
        allocationHierarchySpecification.setCalculationOrder(this.m_allocations.size());
        return allocationHierarchySpecification;
    }

    public AllocationHierarchySpecification createAllocateHierarchySpecificationFirst() {
        AllocationHierarchySpecification allocationHierarchySpecification = new AllocationHierarchySpecification(this);
        this.addAllocationFirst(allocationHierarchySpecification);
        allocationHierarchySpecification.setName("Relation" + this.m_allocations.size());
        allocationHierarchySpecification.setCalculationOrder(this.m_allocations.size());
        return allocationHierarchySpecification;
    }

    public String Create(AWConnection aWConnection) {
        String string = "success";
        String string2 = aWConnection.executeCommand("call create_allocdefinition(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + this.quoteValue(this.getChildLock()) + "," + this.quoteValue(this.getDeadLock()) + "," + this.quoteValue(this.getSourceVal()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-120000", new Object[]{this.getId(), this.m_commandResultText});
        }
        Object var4_4 = null;
        boolean bl = true;
        Iterator iterator = this.m_allocations.iterator();
        while (iterator.hasNext()) {
            Allocation allocation = (Allocation)iterator.next();
            allocation.Create(aWConnection);
        }
        return string;
    }

    public String Delete(AWConnection aWConnection) {
        String string = aWConnection.executeCommand("call delete_allocdefinition(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-120001", new Object[]{this.getId(), this.m_commandResultText});
        }
        return "success";
    }

    public void readAWDefinitions(AWConnection aWConnection, boolean bl) {
        if (!this.m_dataRead) {
            this.m_dataRead = true;
            aWConnection.limitDimension(AW.s_solveDfnObj, "TO", this.getId());
            aWConnection.limitDimension(AW.s_genericAllocationPropObj, "TO", "CHILDLOCK");
            String string = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_genericAllocationCatalogObj);
            if (!string.equalsIgnoreCase("NA")) {
                this.setChildLock(string);
            }
            aWConnection.limitDimension(AW.s_genericAllocationPropObj, "TO", "DEADLOCK");
            String string2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_genericAllocationCatalogObj);
            if (!string2.equalsIgnoreCase("NA")) {
                this.setDeadLock(string2);
            }
            aWConnection.limitDimension(AW.s_genericAllocationPropObj, "TO", "SOURCEVAL");
            String string3 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_genericAllocationCatalogObj);
            if (!string3.equalsIgnoreCase("NA")) {
                this.setSourceVal(string3);
            }
            aWConnection.executeCommand("LIMIT " + AW.getCurAW().getName() + "!" + AW.s_allDimsObj + " TO " + AW.getCurAW().getName() + "!" + AW.s_solveDfnSolveOrderObj);
            Vector vector = aWConnection.getDimensionValues(AW.s_allDimsObj);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Parameter parameter;
                AllocationArgument allocationArgument;
                Object object;
                Object object2;
                String string4 = (String)iterator.next();
                aWConnection.limitDimension(AW.s_allDimsObj, "TO", string4);
                AllocationHierarchySpecification allocationHierarchySpecification = this.createAllocateHierarchySpecification();
                Dimension dimension = AW.s_curAW.findDimension(this.getLogicalNamePart(string4));
                allocationHierarchySpecification.setDimension(dimension);
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "TARGET_LIST");
                String string5 = aWConnection.getValue(AW.s_allocSolveDefCatalogObj);
                if (!string5.toUpperCase().equals("NA")) {
                    object2 = dimension.FindHierarchy(dimension.getLogicalNamePart(string5));
                    allocationHierarchySpecification.setHierarchy((Hierarchy)object2);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "OPERATOR");
                object2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!((String)object2).toUpperCase().equals("NA")) {
                    object = allocationHierarchySpecification.createAllocationOperator();
                    ((AllocationOperator)object).setOpcode((String)object2);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "NAOPERATOR");
                object = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!((String)object).toUpperCase().equals("NA")) {
                    allocationHierarchySpecification.setNaOperator((String)object);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "REMOPERATOR");
                String string6 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string6.toUpperCase().equals("NA")) {
                    allocationHierarchySpecification.setRemOperator(string6);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "FLOOR");
                String string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("FLOOR");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "CEILING");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("CEILING");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "MIN");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("MIN");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "MAX");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("MAX");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "NAHANDLE");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("NAHANDLE");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "ADD_ASSIGN");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("ADD_ASSIGN");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "PROTECT_LIST");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("PROTECT_LIST");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "READWRITE_WRITE");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("READWRITE_WRITE");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "WEIGHTBY");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.createAllocationArgument();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("WEIGHTBY");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "ADD_MULTIPLY");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("ADD_MULTIPLY");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "WNAFILL");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (!string7.toUpperCase().equals("NA")) {
                    allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                    parameter = allocationArgument.createParameter();
                    parameter.setKeyWord("WNAFILL");
                    parameter.setValue(string7);
                }
                aWConnection.limitDimension(AW.s_allocSolveDefPropObj, "TO", "DIM_VSET");
                string7 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_allocSolveDefCatalogObj);
                if (string7.toUpperCase().equals("NA")) continue;
                allocationArgument = allocationHierarchySpecification.getAllocationArguments() == null ? allocationHierarchySpecification.createAllocationArgument() : allocationHierarchySpecification.getAllocationArguments();
                parameter = allocationArgument.createParameter();
                parameter.setKeyWord("DIM_VSET");
                parameter.setValue(string7);
            }
        }
    }

    public boolean validateDimension(Dimension dimension) {
        boolean bl = true;
        Iterator iterator = this.m_allocations.iterator();
        while (iterator.hasNext()) {
            Allocation allocation = (Allocation)iterator.next();
            if (!(allocation instanceof AllocationHierarchySpecification) || dimension != ((AllocationHierarchySpecification)allocation).getDimension()) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

