/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.PlatformUtils;

public final class FontSizeOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "FontSizeOptions";
    private static final String FONT_FAMILY = "fontFamily";
    private static final String FONT_SIZE = "fontSize";
    private static final String SHOW_ONLY_FIXED_WIDTH = "showOnlyFixedWidth";

    public FontSizeOptions() {
        this(HashStructure.newInstance());
    }

    private FontSizeOptions(HashStructure hash) {
        super(hash);
        String defaultFontFamily = PlatformUtils.isMac() ? "Monospaced" : "DialogInput";
        this._hash.getString(FONT_FAMILY, defaultFontFamily);
    }

    public static FontSizeOptions getInstance(PropertyStorage prefs) {
        return new FontSizeOptions(FontSizeOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public String getFontFamily() {
        return this._hash.getString(FONT_FAMILY);
    }

    public void setFontFamily(String fontFamily) {
        this._hash.putString(FONT_FAMILY, fontFamily);
    }

    public int getFontSize() {
        return this._hash.getInt(FONT_SIZE, 12);
    }

    public void setFontSize(int fontSize) {
        this._hash.putInt(FONT_SIZE, fontSize);
    }

    public boolean getShowOnlyFixedWidth() {
        return this._hash.getBoolean(SHOW_ONLY_FIXED_WIDTH, false);
    }

    public void setShowOnlyFixedWidth(boolean showOnlyFixedWidth) {
        this._hash.putBoolean(SHOW_ONLY_FIXED_WIDTH, showOnlyFixedWidth);
    }
}

