/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.AbstractBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicScrollBarUI;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.ScrollTipRenderer;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public class ScrollTipPlugin
implements EditorPlugin {
    private JComponent panel;
    private ScrollTipRenderer renderer;
    private BasicEditorPane editor;
    private int previousLine = -1;
    private ScrollBarAdjustmentListener sbListener;
    public static String SHOW_SCROLLTIP_PLUGIN_PROPERTY = "scrollpeek";
    private static int HIDE_DELAY = 1000;
    private static int SHOW_DELAY = 125;
    private static int SCROLL_SPEED_THRESHOLD = 4;
    private static int MINIMUM_LINES = 80;
    private static Color BACKGROUND_COLOR = new Color(245, 245, 245, 200);
    private static Color FOREGROUND_COLOR = new Color(200, 200, 200);
    private Timer hideTimer = new Timer(HIDE_DELAY, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScrollTipPlugin.this.hidePeek();
        }
    });
    private Timer showTimer = new ShowTimer();

    public ScrollTipPlugin() {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setOpaque(false);
        this.panel.setBorder(new PointyBorder());
        this.panel.setVisible(false);
    }

    public void setRenderer(ScrollTipRenderer renderer) {
        this.renderer = renderer;
    }

    public void install(final BasicEditorPane editor) {
        this.editor = editor;
        editor.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                editor.removeAncestorListener((AncestorListener)this);
                ScrollTipPlugin.this.attachScrollbarListener(editor);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void attachScrollbarListener(BasicEditorPane editor) {
        Object comp = editor;
        while (!(comp instanceof JScrollPane)) {
            if ((comp = comp.getParent()) != null) continue;
            return;
        }
        JScrollPane sp = (JScrollPane)comp;
        JScrollBar sb = sp.getVerticalScrollBar();
        this.sbListener = new ScrollBarAdjustmentListener(sb);
        sb.addAdjustmentListener(this.sbListener);
    }

    private void scrollAdjustment(AdjustmentEvent e) {
        try {
            if (!DisplayOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getShowScrollTip()) {
                return;
            }
            JScrollBar sb = (JScrollBar)e.getSource();
            if (!sb.isShowing() || !sb.isValid()) {
                return;
            }
            if (this.renderer == null) {
                return;
            }
            if (this.isDragging(sb) != Boolean.TRUE) {
                return;
            }
            if (this.editor.getLineCount() < MINIMUM_LINES) {
                return;
            }
            Rectangle thumbR = this.getThumbBounds(sb);
            if (thumbR != null) {
                Rectangle visR = this.editor.getVisibleRect();
                if (visR.height == this.editor.getHeight()) {
                    return;
                }
                int startOffset = this.editor.viewToModel(visR.getLocation());
                int line = this.editor.getLineFromOffset(startOffset);
                if (line > this.previousLine + 1 || line < this.previousLine - 1) {
                    Point endP = visR.getLocation();
                    endP.y += visR.height - 2;
                    int endOffset = this.editor.viewToModel(endP);
                    JComponent c = this.renderer.getRenderer(this.editor, startOffset, endOffset);
                    if (c != null) {
                        c.setForeground(new Color(32, 32, 32));
                        if (c.getParent() != this.panel) {
                            this.panel.removeAll();
                            this.panel.add(c);
                        }
                        c.invalidate();
                        if (this.panel.isVisible()) {
                            if (this.hideTimer.isRunning()) {
                                this.hideTimer.restart();
                            } else {
                                this.hideTimer.start();
                            }
                        }
                        if (!this.panel.isShowing()) {
                            Ide.getMainWindow().getLayeredPane().add((Component)this.panel, new Integer(JLayeredPane.POPUP_LAYER - 10));
                        }
                        if (!this.showTimer.isRunning() && !this.panel.isVisible()) {
                            this.showTimer.restart();
                        }
                    } else {
                        this.hidePeek();
                    }
                }
                this.previousLine = line;
                this.panel.setSize(Math.max(250, this.panel.getPreferredSize().width), this.panel.getPreferredSize().height);
                this.panel.setSize(250, this.panel.getPreferredSize().height);
                Point p = SwingUtilities.convertPoint(sb.getParent(), sb.getLocation(), Ide.getMainWindow().getLayeredPane());
                String prop = System.getProperty(SHOW_SCROLLTIP_PLUGIN_PROPERTY);
                if (prop != null && prop.equals("moves")) {
                    p.x -= this.panel.getWidth();
                    p.y = p.y + thumbR.y - this.panel.getHeight() + PointyBorder.INDENT + PointyBorder.CORNER_INDENT + PointyBorder.POINT_Y_GAP + PointyBorder.POINT_HEIGHT / 2;
                } else {
                    CodeEditor ce = CodeEditor.getCodeEditor(this.editor);
                    if (ce.getGutter() != null) {
                        p.x += -this.panel.getWidth();
                    }
                    if (ce.getToolbar() != null && ce.getToolbar().isVisible()) {
                        p.y += ce.getToolbar().getHeight() + 2;
                    }
                }
                this.panel.setLocation(p);
                this.panel.repaint();
                sb.repaint();
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private void hidePeek() {
        this.showTimer.stop();
        this.panel.setVisible(false);
        if (this.panel.getParent() != null) {
            this.panel.getParent().remove(this.panel);
        }
    }

    private Rectangle getThumbBounds(JScrollBar sb) {
        if (sb.getUI() instanceof BasicScrollBarUI) {
            BasicScrollBarUI ui = (BasicScrollBarUI)sb.getUI();
            try {
                Method method = BasicScrollBarUI.class.getDeclaredMethod("getThumbBounds", null);
                method.setAccessible(true);
                Object result = method.invoke((Object)ui, null);
                return (Rectangle)result;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private Boolean isDragging(JScrollBar sb) {
        if (sb.getUI() instanceof BasicScrollBarUI) {
            BasicScrollBarUI ui = (BasicScrollBarUI)sb.getUI();
            try {
                Field field = BasicScrollBarUI.class.getDeclaredField("isDragging");
                field.setAccessible(true);
                Boolean result = field.getBoolean(ui);
                return result;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public void deinstall(BasicEditorPane editor) {
        if (this.sbListener != null && this.sbListener.getScrollBar() != null) {
            this.sbListener.getScrollBar().removeAdjustmentListener(this.sbListener);
        }
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private class ShowAction
    implements ActionListener {
        private int lineAtLastCheck = -1;
        long timeToShow = -1L;

        private ShowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (System.currentTimeMillis() > this.timeToShow) {
                if (Math.abs(ScrollTipPlugin.this.previousLine - this.lineAtLastCheck) > SCROLL_SPEED_THRESHOLD && ScrollTipPlugin.this.panel.getParent() != null) {
                    ScrollTipPlugin.this.panel.setVisible(true);
                    if (ScrollTipPlugin.this.hideTimer.isRunning()) {
                        ScrollTipPlugin.this.hideTimer.restart();
                    } else {
                        ScrollTipPlugin.this.hideTimer.start();
                    }
                }
                ScrollTipPlugin.this.showTimer.stop();
            }
            this.lineAtLastCheck = ScrollTipPlugin.this.previousLine;
        }
    }

    private class ShowTimer
    extends Timer {
        private ShowAction showAction;

        private ShowTimer() {
            super(25, null);
            this.showAction = new ShowAction();
            this.addActionListener(this.showAction);
        }

        @Override
        public void start() {
            this.showAction.timeToShow = System.currentTimeMillis() + (long)SHOW_DELAY;
            super.start();
        }
    }

    private static class PointyBorder
    extends AbstractBorder {
        private static Insets INSETS = new Insets(4, 6, 4, 10);
        private static int CORNER_INDENT = 4;
        private static int INDENT = 2;
        private static int POINT_Y_GAP = 0;
        private static int POINT_HEIGHT = 8;

        private PointyBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return INSETS;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath gp = new GeneralPath();
            gp.moveTo(CORNER_INDENT + INDENT, INDENT);
            gp.lineTo(width - PointyBorder.INSETS.right - CORNER_INDENT + INDENT, INDENT);
            gp.quadTo(width - PointyBorder.INSETS.right + INDENT, INDENT, width - PointyBorder.INSETS.right + INDENT, CORNER_INDENT + INDENT);
            String prop = System.getProperty(SHOW_SCROLLTIP_PLUGIN_PROPERTY);
            if (prop != null && prop.equals("moves")) {
                gp.lineTo(width - PointyBorder.INSETS.right + INDENT, height - CORNER_INDENT - INDENT - POINT_Y_GAP - POINT_HEIGHT);
                gp.lineTo(width - INDENT, height - CORNER_INDENT - INDENT - POINT_Y_GAP - POINT_HEIGHT / 2);
                gp.lineTo(width - PointyBorder.INSETS.right + INDENT, height - CORNER_INDENT - INDENT - POINT_Y_GAP);
            }
            gp.lineTo(width - PointyBorder.INSETS.right + INDENT, height - CORNER_INDENT - INDENT);
            gp.quadTo(width - PointyBorder.INSETS.right + INDENT, height - INDENT, width - PointyBorder.INSETS.right - CORNER_INDENT + INDENT, height - INDENT);
            gp.lineTo(CORNER_INDENT + INDENT, height - INDENT);
            gp.quadTo(INDENT, height - INDENT, INDENT, height - CORNER_INDENT - INDENT);
            gp.lineTo(INDENT, CORNER_INDENT + INDENT);
            gp.quadTo(INDENT, INDENT, CORNER_INDENT + INDENT, INDENT);
            gp.closePath();
            g2.setColor(BACKGROUND_COLOR);
            g2.fill(gp);
            g2.setColor(FOREGROUND_COLOR);
            g2.draw(gp);
        }
    }

    private class ScrollBarAdjustmentListener
    implements AdjustmentListener {
        private JScrollBar scrollBar;

        public ScrollBarAdjustmentListener(JScrollBar sb) {
            this.scrollBar = sb;
        }

        public JScrollBar getScrollBar() {
            return this.scrollBar;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            ScrollTipPlugin.this.scrollAdjustment(e);
        }
    }
}

