/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

final class MarginLayout
implements LayoutManager {
    private final int alignment;

    MarginLayout(int alignment) {
        assert (alignment == 0 || alignment == 1);
        this.alignment = alignment;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            for (Component c : parent.getComponents()) {
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                if (this.alignment == 1) {
                    dim.width += d.width;
                    dim.height = Math.max(dim.height, d.height);
                    continue;
                }
                dim.width = Math.max(dim.width, d.width);
                dim.height += d.height;
            }
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int w = 0;
            int h = 0;
            for (Component c : parent.getComponents()) {
                if (!c.isVisible()) continue;
                Dimension d = c.getMinimumSize();
                if (this.alignment == 1) {
                    w += d.width;
                    h = Math.max(h, d.height);
                    continue;
                }
                w = Math.max(w, d.width);
                h += d.height;
            }
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int x = 0;
            int y = 0;
            for (Component c : parent.getComponents()) {
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                if (this.alignment == 1) {
                    c.setBounds(x, y, d.width, parent.getHeight());
                    x += d.width;
                    continue;
                }
                c.setBounds(x, y, parent.getWidth(), d.height);
                y += d.height;
            }
        }
    }
}

