/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import oracle.ide.Ide;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;

final class CodeEditorFeedbackManager
implements FeedbackManager {
    public static final String BLANK_MESSAGE = " ";
    private final Timer feedbackTimer = new Timer(5000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorFeedbackManager.this.clearStatusBarMessage(CodeEditorFeedbackManager.this.lastMessage);
            CodeEditorFeedbackManager.this.lastMessage = null;
        }
    });
    private String lastMessage;

    CodeEditorFeedbackManager() {
        this.feedbackTimer.setRepeats(false);
    }

    public void showFeedback(BasicEditorPane editorPane, String feedbackMessage) {
        this.feedbackTimer.stop();
        this.setStatusBarMessage(feedbackMessage);
    }

    private void setStatusBarMessage(String message) {
        Ide.getStatusBar().setText(message);
    }

    private void clearStatusBarMessage(String messageToClear) {
        if (Ide.getStatusBar().getText().equals(messageToClear)) {
            Ide.getStatusBar().setText(BLANK_MESSAGE);
        }
    }

    private void clearStatusBarMessage() {
        Ide.getStatusBar().setText(BLANK_MESSAGE);
    }

    public void showFeedback(BasicEditorPane editorPane, String feedbackMessage, int milliSeconds) {
        this.feedbackTimer.stop();
        this.feedbackTimer.setInitialDelay(milliSeconds);
        this.feedbackTimer.setDelay(milliSeconds);
        this.feedbackTimer.start();
        this.lastMessage = feedbackMessage;
        this.setStatusBarMessage(feedbackMessage);
    }

    public void hideFeedback(BasicEditorPane editorPane) {
        this.feedbackTimer.stop();
        this.clearStatusBarMessage();
    }
}

