/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class CodeDestination {
    private Direction direction;
    private String tooltip;
    private Project project;
    private URL goToUrl;
    private int goToOffset;
    private final String text;
    private final String label;

    public CodeDestination(Direction direction, URL goToUrl, int goToOffset, String tooltip, String label, String text) {
        this.direction = direction;
        this.tooltip = tooltip;
        this.goToUrl = goToUrl;
        this.goToOffset = goToOffset;
        this.label = label;
        this.text = text;
    }

    public CodeDestination(Direction direction, String tooltip, Project project, URL goToUrl, int goToOffset, String label, String text) {
        this.direction = direction;
        this.tooltip = tooltip;
        this.project = project;
        this.goToUrl = goToUrl;
        this.goToOffset = goToOffset;
        this.label = label;
        this.text = text;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final String getTooltip() {
        return this.tooltip;
    }

    public final URL getGoToUrl() {
        return this.goToUrl;
    }

    public final int getGoToOffset() {
        return this.goToOffset;
    }

    public String toString() {
        return this.tooltip + " -> " + String.valueOf(this.goToUrl) + ":" + this.goToOffset;
    }

    public Icon getIcon() {
        switch (this.direction) {
            case DOWN: {
                return OracleIcons.getIcon((String)"gutter/down.png");
            }
            case UP: {
                return OracleIcons.getIcon((String)"gutter/up.png");
            }
        }
        return null;
    }

    protected Project getDesitinationProject(Context context) {
        return context.getProject();
    }

    public final void navigate() {
        NavigationManager navigator = NavigationManager.getNavigationManager();
        Node destNode = NodeFactory.find((URL)this.goToUrl);
        if (destNode != null) {
            try {
                Context context = Context.newIdeContext((Node)destNode);
                context.setProject(this.project);
                Project definingProject = this.getDesitinationProject(context);
                if (definingProject != null) {
                    context.setProject(definingProject);
                }
                OffsetNavigationPoint point = new OffsetNavigationPoint(context, this.goToOffset, 0);
                if (navigator != null) {
                    navigator.navigateTo((NavigationPoint)point);
                } else {
                    point.navigate();
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public String getLabel() {
        return this.label;
    }

    public ToggleAction createGotoSourceAction() {
        ToggleAction action = new ToggleAction(this.getTooltip(), this.getIcon()){

            public void actionPerformed(ActionEvent e) {
                CodeDestination.this.navigate();
            }
        };
        return action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CodeDestination) {
            CodeDestination that = (CodeDestination)o;
            if (this.direction == that.direction && this.tooltip.equals(that.tooltip) && this.goToOffset == that.goToOffset && ModelUtil.areEqual((Object)this.goToUrl, (Object)that.goToUrl)) {
                return true;
            }
        }
        return false;
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

