/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.CEditor;
import oracle.ide.feedback.FeedbackManager;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.ActionPostInvoker;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.LexerOffsetsCache;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class AbstractEditingPlugin
implements ActionHookInvoker,
ActionPostInvoker,
CaretListener,
CharacterTypedListener,
EditorPlugin {
    private static final EditDescriptor asteriskDescriptor;
    private static final EditDescriptor commentEndDescriptor;
    private static final EditDescriptor splitSingleLineCommentDescriptor;
    private static final EditDescriptor moveOpenBraceDescriptor;
    private static final EditDescriptor braceEndDescriptor;
    private static final EditDescriptor autoIndentBlockDescriptor;
    private static final EditDescriptor alignBraceDescriptor;
    private static final EditDescriptor quoteEndDescriptor;
    private static final EditDescriptor quoteExtendDescriptor;
    private static final EditDescriptor parenEndDescriptor;
    public static final String PROPERTY_AUTO_ASTERISK = "java-auto-asterisk";
    public static final String PROPERTY_AUTO_COMMENT_END = "java-auto-comment-end";
    public static final String PROPERTY_AUTO_SPLIT_SINGLE_LINE_COMMENT = "auto-split-single-line-comment";
    public static final String PROPERTY_AUTO_GEN_DOC_COMMENTS = "java-auto-gen-doc-comments";
    public static final String PROPERTY_AUTO_BRACE_END = "java-auto-brace-end";
    public static final String PROPERTY_OPEN_BRACE_SAME_LINE = "java-open-brace-same-line";
    public static final String PROPERTY_MOVE_OPEN_BRACE = "java-move-open-brace";
    public static final String PROPERTY_ALIGN_CLOSE_BRACE = "java-align-close-brace";
    public static final String PROPERTY_AUTO_QUOTE_END = "java-auto-quote-end";
    public static final String PROPERTY_AUTO_QUOTE_EXTEND = "java-auto-quote-extend";
    public static final String PROPERTY_AUTO_PAREN_END = "java-auto-paren-end";
    private boolean autoAsteriskEnabled;
    private boolean autoCommentEndEnabled;
    private boolean autoSplitSingleLineCommentEnabled;
    private boolean autoGenDocCommentsEnabled;
    private boolean moveOpenBraceEnabled;
    private boolean autoBraceEndEnabled;
    private boolean alignCloseBraceEnabled;
    private boolean autoQuoteEndEnabled;
    private boolean autoQuoteExtendEnabled;
    private boolean autoParenEndEnabled;
    private boolean lastBackspace = false;
    private int lastInvokedOffset;
    private int lastInvokedLine;
    private int lastInvokedToken;
    private BasicEditorPane editor = null;
    private static final int IN_PLAIN = 0;
    private static final int IN_ML_COMMENT_BODY = 1;
    private static final int IN_ML_COMMENT_HEADER = 2;
    private static final int IN_SL_COMMENT = 3;
    private static final int IN_STRING = 4;
    private static final int IN_CHARS = 5;
    private int caretToken = 0;
    private int caretTokenStart;
    private AbstractLexer lexer = null;
    private LexerToken lexerToken = null;
    private static final int LAST_TYPED_CHARS_SIZE = 8;
    private char[] lastTypedChars = new char[8];
    private int lastTypedOffset = 0;
    private int numLastChars = 0;
    private boolean isEmptyQuotes = false;
    private boolean shouldExtendQuotes = false;
    private boolean isEmptyParens = false;
    private final List _trackerList = new ArrayList();

    protected BasicEditorPane getEditorPane() {
        return this.editor;
    }

    protected abstract AbstractLexer getLexer();

    protected abstract boolean isEofToken(int var1);

    protected abstract boolean isSingleLineCommentToken(int var1);

    protected abstract boolean isMultiLineOrDocCommentToken(int var1);

    protected abstract boolean isCharacterLiteralToken(int var1);

    protected abstract boolean isStringLiteralToken(int var1);

    protected abstract int getRightParenToken();

    protected abstract int getRightBracketToken();

    protected abstract boolean skipCloseParenGeneration(int var1);

    protected abstract void addJavadocCommentsAtOffset();

    protected void clearLastTypedChars() {
        this.numLastChars = 0;
        this.lastTypedOffset = 0;
    }

    protected void updateLastTypedChars(int offset, char c) {
        if (!this.shouldUpdateLastTypedChars()) {
            // empty if block
        }
        if (offset != this.lastTypedOffset + 1) {
            this.numLastChars = 0;
        }
        if (this.numLastChars == 8) {
            --this.numLastChars;
            System.arraycopy(this.lastTypedChars, 1, this.lastTypedChars, 0, this.numLastChars);
        }
        this.lastTypedChars[this.numLastChars++] = c;
        this.lastTypedOffset = offset;
    }

    protected BasicDocument getDocument() {
        BasicDocument document = (BasicDocument)this.editor.getDocument();
        return document;
    }

    protected BraceProvider getBraceProvider() {
        LanguageSupport languageSupport = this.getDocument().getLanguageSupport();
        return languageSupport.getBraceProvider();
    }

    protected LexerDocumentRenderer getDocumentRenderer() {
        LexerDocumentRenderer renderer = (LexerDocumentRenderer)this.getDocument().getDocumentRenderer();
        return renderer;
    }

    protected char getAutoQuoteExtendChar(LexerToken lexerToken) {
        return '\"';
    }

    protected boolean isStringQuoteChar(char c) {
        return c == '\"';
    }

    protected boolean isAutoQuoteExtendEnabled() {
        return this.autoQuoteExtendEnabled;
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addActionHookInvoker((ActionHookInvoker)this);
        editor.addActionPostInvoker((ActionPostInvoker)this);
        editor.addCaretListener((CaretListener)this);
        editor.addCharacterTypedListener((CharacterTypedListener)this);
        this.lexer = this.getLexer();
        this.lexerToken = this.lexer.createLexerToken();
        this.numLastChars = 0;
        this.updatePropertyStatus();
    }

    public void deinstall(BasicEditorPane editor) {
        this.removeAllTrackers();
        editor.removeActionHookInvoker((ActionHookInvoker)this);
        editor.removeActionPostInvoker((ActionPostInvoker)this);
        editor.removeCaretListener((CaretListener)this);
        editor.removeCharacterTypedListener((CharacterTypedListener)this);
        this.editor = null;
        this.lexer = null;
        this.lexerToken = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals(PROPERTY_AUTO_ASTERISK) || propertyName.equals(PROPERTY_AUTO_COMMENT_END) || propertyName.equals(PROPERTY_AUTO_SPLIT_SINGLE_LINE_COMMENT) || propertyName.equals(PROPERTY_AUTO_GEN_DOC_COMMENTS) || propertyName.equals(PROPERTY_MOVE_OPEN_BRACE) || propertyName.equals(PROPERTY_AUTO_BRACE_END) || propertyName.equals(PROPERTY_ALIGN_CLOSE_BRACE) || propertyName.equals(PROPERTY_AUTO_QUOTE_END) || propertyName.equals(PROPERTY_AUTO_QUOTE_EXTEND) || propertyName.equals(PROPERTY_AUTO_PAREN_END)) {
            this.updatePropertyStatus();
        }
    }

    private void updatePropertyStatus() {
        this.autoAsteriskEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_ASTERISK);
        this.autoCommentEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_COMMENT_END);
        this.autoSplitSingleLineCommentEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_SPLIT_SINGLE_LINE_COMMENT);
        this.autoGenDocCommentsEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_GEN_DOC_COMMENTS);
        this.autoQuoteEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_QUOTE_END);
        this.autoQuoteExtendEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_QUOTE_EXTEND);
        this.autoParenEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_PAREN_END);
        this.moveOpenBraceEnabled = this.editor.getBooleanProperty(PROPERTY_MOVE_OPEN_BRACE);
        this.autoBraceEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_BRACE_END);
        this.alignCloseBraceEnabled = this.editor.getBooleanProperty(PROPERTY_ALIGN_CLOSE_BRACE);
        this.updateTokenStatus();
    }

    private boolean isAutoAsteriskEnabled() {
        return this.autoAsteriskEnabled;
    }

    private boolean isAutoCommentEndEnabled() {
        return this.autoCommentEndEnabled;
    }

    private boolean isAutoSplitSingleLineCommentEnabled() {
        return this.autoSplitSingleLineCommentEnabled;
    }

    private boolean isAutoGenDocCommentsEnabled() {
        return this.autoGenDocCommentsEnabled;
    }

    private boolean isMoveOpenBraceEnabled() {
        return this.moveOpenBraceEnabled;
    }

    private boolean isAutoBraceEndEnabled() {
        return this.autoBraceEndEnabled;
    }

    private boolean isAlignCloseBraceEnabled() {
        return this.alignCloseBraceEnabled;
    }

    private boolean isAutoQuoteEndEnabled() {
        return this.autoQuoteEndEnabled;
    }

    private boolean isAutoParenEndEnabled() {
        return this.autoParenEndEnabled;
    }

    private boolean shouldRecordInvokedOffset() {
        return this.isAutoAsteriskEnabled() || this.isAutoCommentEndEnabled() || this.isAutoSplitSingleLineCommentEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAutoQuoteEndEnabled();
    }

    private boolean shouldUpdateTokenStatus() {
        return this.isAutoAsteriskEnabled() || this.isAutoCommentEndEnabled() || this.isAutoSplitSingleLineCommentEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAlignCloseBraceEnabled() || this.isAutoQuoteEndEnabled();
    }

    private boolean shouldUpdateLastTypedChars() {
        return this.isAutoCommentEndEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAutoQuoteEndEnabled();
    }

    public boolean invokeAction(String actionKey) {
        BasicDocument document = this.getDocument();
        try {
            if (document.getTextBuffer().isReadOnly()) {
                return false;
            }
        }
        catch (ExpiredTextBufferException ex) {
            return false;
        }
        if (actionKey.equals("insert-break")) {
            this.recordInvokedOffset();
            this.enterKey_preAutoQuoteExtend();
        } else if (actionKey.equals("delete-previous")) {
            boolean bl = this.lastBackspace = !this.editor.hasSelection();
            if (this.lastBackspace) {
                this.recordInvokedOffset();
                this.delete_preAutoRemoveQuoteEnd();
                this.delete_preAutoRemoveParenEnd();
            }
        }
        return false;
    }

    private void recordInvokedOffset() {
        if (!this.shouldRecordInvokedOffset()) {
            return;
        }
        this.lastInvokedOffset = this.editor.getCaretPosition();
        this.lastInvokedLine = this.editor.getLineFromOffset(this.lastInvokedOffset);
        this.lastInvokedToken = this.getCaretToken();
    }

    private int getLastInvokedOffset() {
        return this.lastInvokedOffset;
    }

    private int getLastInvokedLine() {
        return this.lastInvokedLine;
    }

    private int getLastInvokedToken() {
        return this.lastInvokedToken;
    }

    public void invokedAction(String actionKey) {
        BasicDocument document = this.getDocument();
        if (document.getTextBuffer().isReadOnly()) {
            return;
        }
        if (actionKey.equals("insert-break")) {
            this.enterKey_doAutoAsterisk();
            this.enterKey_doAutoEndComment();
            this.enterKey_doAutoSplitSingleLineComment();
            this.enterKey_doOpenBraceTasks();
            this.enterKey_doAutoQuoteExtend();
        } else if (actionKey.equals("delete-previous") && this.lastBackspace) {
            this.lastBackspace = false;
            this.deleteLastTypedChar(this.getLastInvokedOffset());
            this.delete_doAutoRemoveQuoteEnd();
            this.delete_doAutoRemoveParenEnd();
            return;
        }
        this.clearLastTypedChars();
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        this.updateTokenStatus();
    }

    public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
        this.updateLastTypedChars(offset, typedChar);
        this.charTyped_doAlignCloseBrace(offset, typedChar);
        this.charTyped_doAutoQuoteEnd(offset, typedChar);
        this.charTyped_doAutoParenEnd(offset, typedChar);
    }

    private TextBuffer getTextBuffer() {
        BasicDocument document = this.getDocument();
        return document.getTextBuffer();
    }

    private void updateTokenStatus() {
        if (!this.shouldUpdateTokenStatus()) {
            return;
        }
        int caretOffset = this.editor.getCaretPosition();
        this.caretToken = this.getTokenForOffset(caretOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTokenForOffset(int offset) {
        int currentToken = 0;
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            LexerDocumentRenderer renderer = this.getDocumentRenderer();
            LexerOffsetsCache cache = renderer.getOffsetsCache();
            int searchOffset = cache.findClosestOffset((Lexer)this.lexer, this.lexerToken, offset);
            this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            this.lexer.setPosition(searchOffset);
            int currentOffset = searchOffset;
            int bufferEnd = textBuffer.getLength();
            while (currentOffset < bufferEnd) {
                int token = this.lexer.lex(this.lexerToken);
                if (token == 0) {
                } else {
                    int tokenStart = this.lexerToken.getStartOffset();
                    int tokenEnd = this.lexerToken.getEndOffset();
                    this.caretTokenStart = tokenStart;
                    if (tokenStart == offset) {
                    } else if (tokenStart < offset && offset < tokenEnd) {
                        if (this.isMultiLineOrDocCommentToken(token)) {
                            currentToken = 1;
                            int headerLength = 2;
                            if (offset < tokenStart + headerLength) {
                                currentToken = 2;
                            }
                        } else if (this.isSingleLineCommentToken(token)) {
                            currentToken = 3;
                        } else if (this.isCharacterLiteralToken(token)) {
                            currentToken = 5;
                        } else if (this.isStringLiteralToken(token)) {
                            currentToken = 4;
                        }
                    } else if (tokenEnd == offset) {
                        if (this.isMultiLineOrDocCommentToken(token)) {
                            if (textBuffer.getChar(tokenEnd - 2) != '*' || textBuffer.getChar(tokenEnd - 1) != '/') {
                                currentToken = 1;
                            }
                        } else if (this.isSingleLineCommentToken(token)) {
                            currentToken = 3;
                        } else if (this.isCharacterLiteralToken(token)) {
                            if (!this.isCharLiteralTerminated(textBuffer, tokenStart, tokenEnd)) {
                                currentToken = 5;
                            }
                        } else if (this.isStringLiteralToken(token) && !this.isStringLiteralTerminated(textBuffer, tokenStart, tokenEnd)) {
                            currentToken = 4;
                        }
                    } else if (offset >= tokenStart) continue;
                }
                break;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return currentToken;
    }

    private boolean isCharLiteralTerminated(TextBuffer textBuffer, int startOffset, int endOffset) {
        int pending = 2;
        block4: for (int i = startOffset; i < endOffset; ++i) {
            char c = textBuffer.getChar(i);
            switch (c) {
                case '\'': {
                    --pending;
                    continue block4;
                }
                case '\\': {
                    ++i;
                }
            }
        }
        return pending == 0;
    }

    private boolean isStringLiteralTerminated(TextBuffer textBuffer, int startOffset, int endOffset) {
        int pending = 2;
        for (int i = startOffset; i < endOffset; ++i) {
            char c = textBuffer.getChar(i);
            if (this.isStringQuoteChar(c)) {
                --pending;
                continue;
            }
            if (c != '\\') continue;
            ++i;
        }
        return pending == 0;
    }

    private int getCaretToken() {
        return this.caretToken;
    }

    private int getCaretTokenStart() {
        return this.caretTokenStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enterKey_doAutoAsterisk() {
        if (!this.isAutoAsteriskEnabled()) {
            return;
        }
        if (this.getCaretToken() != 1) return;
        BasicDocument document = this.getDocument();
        document.writeLock();
        try {
            int invokedLine = this.getLastInvokedLine();
            int commentStart = this.getCaretTokenStart();
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int currentOffset = this.editor.getCaretPosition();
            int currentLine = this.editor.getLineFromOffset(currentOffset);
            if (invokedLine + 1 != currentLine) {
                return;
            }
            int currentStart = this.editor.getLineStartOffset(currentLine);
            int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentStart, currentOffset);
            if (whitespaceEnd != currentOffset) {
                return;
            }
            int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
            boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
            int commentStartLine = this.editor.getLineFromOffset(commentStart);
            int asteriskColumn = 0;
            int numAsterisks = 0;
            int numSpaces = 0;
            if (commentStartLine == invokedLine) {
                int asteriskOffset = commentStart + 1;
                asteriskColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)commentStartLine, (int)asteriskOffset, (int)tabSize);
                numAsterisks = 1;
                numSpaces = 1;
            } else {
                int invokedEnd;
                int invokedStart = lineMap.getLineStartOffset(invokedLine);
                int asteriskOffset = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)invokedStart, (int)(invokedEnd = lineMap.getLineEndOffset(invokedLine)));
                if (asteriskOffset != -1) {
                    asteriskColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)invokedLine, (int)asteriskOffset, (int)tabSize);
                    numAsterisks = this.countAsterisks(textBuffer, asteriskOffset, invokedEnd);
                    int whitespaceStart = asteriskOffset + numAsterisks;
                    whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, whitespaceStart, invokedEnd);
                    numSpaces = 1;
                    if (whitespaceEnd > whitespaceStart) {
                        int nonWhitespaceColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)invokedLine, (int)whitespaceEnd, (int)tabSize);
                        numSpaces = nonWhitespaceColumn - (asteriskColumn + numAsterisks);
                    }
                }
            }
            if (numAsterisks <= 0) return;
            String leadingIndent = this.buildAsterisks(useTabs, tabSize, asteriskColumn, numAsterisks, numSpaces);
            int currentIndentSize = currentOffset - currentStart;
            this.editor.beginEdit(asteriskDescriptor);
            try {
                document.remove(currentStart, currentIndentSize);
                document.insertString(currentStart, leadingIndent, null);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                this.editor.endEdit(true);
            }
        }
        finally {
            document.writeUnlock();
        }
    }

    private String buildAsterisks(boolean useTabs, int tabSize, int asteriskColumn, int numAsterisks, int numSpaces) {
        String leadingIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)asteriskColumn);
        while (numAsterisks-- > 0) {
            leadingIndent = leadingIndent + "*";
        }
        while (numSpaces-- > 0) {
            leadingIndent = leadingIndent + " ";
        }
        return leadingIndent;
    }

    private int countAsterisks(TextBuffer textBuffer, int startOffset, int endOffset) {
        for (int i = startOffset; i < endOffset; ++i) {
            char c = textBuffer.getChar(i);
            if (c == '*') continue;
            return i - startOffset;
        }
        return endOffset - startOffset;
    }

    private int firstNonWhitespaceOffset(TextBuffer textBuffer, int startOffset, int endOffset) {
        for (int i = startOffset; i < endOffset; ++i) {
            char c = textBuffer.getChar(i);
            if (Character.isWhitespace(c)) continue;
            return i;
        }
        return endOffset;
    }

    private void deleteLastTypedChar(int offset) {
        if (!this.shouldUpdateLastTypedChars()) {
            // empty if block
        }
        if (this.numLastChars == 0) {
            return;
        }
        if (offset != this.lastTypedOffset + 1) {
            this.clearLastTypedChars();
            return;
        }
        --this.numLastChars;
        this.lastTypedOffset = Math.max(0, this.lastTypedOffset - 1);
    }

    private boolean matchLastTypedChars(String matchString, int offset) {
        if (this.numLastChars < matchString.length()) {
            return false;
        }
        if (this.lastTypedOffset + 1 != offset) {
            return false;
        }
        int numToMatch = matchString.length();
        int i = 0;
        int checkPos = this.numLastChars - numToMatch;
        while (i < numToMatch) {
            if (this.lastTypedChars[checkPos] != matchString.charAt(i)) {
                return false;
            }
            ++i;
            ++checkPos;
        }
        return true;
    }

    private boolean matchLastTypedChars(String matchString) {
        if (this.numLastChars < matchString.length()) {
            return false;
        }
        int numToMatch = matchString.length();
        int i = 0;
        int checkPos = this.numLastChars - numToMatch;
        while (i < numToMatch) {
            if (this.lastTypedChars[checkPos] != matchString.charAt(i)) {
                return false;
            }
            ++i;
            ++checkPos;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enterKey_doAutoEndComment() {
        if (!this.isAutoCommentEndEnabled()) {
            return;
        }
        boolean inJavadoc = false;
        if (this.getCaretToken() != 1) return;
        BasicDocument document = this.getDocument();
        document.writeLock();
        try {
            int invokedOffset = this.getLastInvokedOffset();
            int invokedLine = this.getLastInvokedLine();
            int commentStart = this.getCaretTokenStart();
            TextBuffer textBuffer = this.getTextBuffer();
            int currentOffset = this.editor.getCaretPosition();
            int currentLine = this.editor.getLineFromOffset(currentOffset);
            if (this.matchLastTypedChars("/**", invokedOffset)) {
                inJavadoc = true;
            } else if (!this.matchLastTypedChars("/*", invokedOffset)) {
                return;
            }
            if (invokedLine + 1 != currentLine) {
                return;
            }
            if (invokedOffset - 3 > commentStart) {
                return;
            }
            int currentLineEnd = this.editor.getLineEndOffset(currentLine);
            int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentOffset, currentLineEnd);
            if (whitespaceEnd != currentLineEnd) {
                return;
            }
            int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
            boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
            int commentLine = this.editor.getLineFromOffset(commentStart);
            int asteriskOffset = commentStart + 1;
            int asteriskColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)commentLine, (int)asteriskOffset, (int)tabSize);
            String leadingIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)asteriskColumn);
            this.editor.beginEdit(commentEndDescriptor);
            try {
                String commentEnd = "\n" + leadingIndent + "*/";
                document.insertString(currentOffset, commentEnd, null);
                this.editor.setCaretPosition(currentOffset);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                this.editor.endEdit(true);
            }
        }
        finally {
            if (this.isAutoGenDocCommentsEnabled() && inJavadoc) {
                this.addJavadocCommentsAtOffset();
            }
            document.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterKey_doAutoSplitSingleLineComment() {
        block13: {
            if (!this.isAutoSplitSingleLineCommentEnabled()) {
                return;
            }
            if (this.getLastInvokedToken() == 3) {
                BasicDocument document = this.getDocument();
                document.writeLock();
                try {
                    int currentOffset = this.editor.getCaretPosition();
                    int currentLine = this.editor.getLineFromOffset(currentOffset);
                    int lineEndOffset = this.editor.getLineEndOffset(currentLine);
                    if (currentOffset + 1 >= lineEndOffset) break block13;
                    int invokedOffset = this.getLastInvokedOffset();
                    TextBuffer textBuffer = document.getTextBuffer();
                    this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                    this.lexer.setPosition(0);
                    int lastSingleLineTokenStart = -1;
                    int token = this.lexer.lex(this.lexerToken);
                    while (this.lexerToken.getStartOffset() < invokedOffset && !this.isEofToken(token)) {
                        if (this.isSingleLineCommentToken(token)) {
                            lastSingleLineTokenStart = this.lexerToken.getStartOffset();
                        }
                        token = this.lexer.lex(this.lexerToken);
                    }
                    if (lastSingleLineTokenStart <= 0) break block13;
                    int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int indentSize = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)lastSingleLineTokenStart, (int)tabSize);
                    StringBuilder indentedCommentStart = new StringBuilder(80);
                    indentedCommentStart.append(BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)indentSize));
                    indentedCommentStart.append("//");
                    char charAfterSLC = textBuffer.getChar(lastSingleLineTokenStart + 2);
                    if (charAfterSLC == ' ' || charAfterSLC == '\t') {
                        indentedCommentStart.append(charAfterSLC);
                    }
                    this.editor.beginEdit(splitSingleLineCommentDescriptor);
                    try {
                        int currentLineStart = this.editor.getLineStartOffset(currentLine);
                        int oldIndentSize = currentOffset - currentLineStart;
                        document.remove(currentLineStart, oldIndentSize);
                        document.insertString(currentLineStart, indentedCommentStart.toString(), null);
                        int indentLength = indentedCommentStart.length();
                        this.editor.setCaretPosition(currentLineStart + indentLength);
                    }
                    catch (BadLocationException e) {
                        FeedbackManager.reportException((Throwable)e);
                    }
                    finally {
                        this.editor.endEdit();
                    }
                }
                finally {
                    document.writeUnlock();
                }
            }
        }
    }

    private boolean isOpenBraceAlone() {
        return !this.editor.getBooleanProperty(PROPERTY_OPEN_BRACE_SAME_LINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enterKey_doOpenBraceTasks() {
        boolean braceEndEnabled = this.isAutoBraceEndEnabled();
        boolean moveBraceEnabled = this.isMoveOpenBraceEnabled();
        if (this.getCaretToken() != 0) return;
        BasicDocument document = this.getDocument();
        document.writeLock();
        try {
            int openLineEnd;
            char c;
            int invokedOffset = this.getLastInvokedOffset();
            int invokedLine = this.getLastInvokedLine();
            int invokedToken = this.getLastInvokedToken();
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int currentOffset = this.editor.getCaretPosition();
            int currentLine = this.editor.getLineFromOffset(currentOffset);
            if (invokedToken != 0) {
                return;
            }
            if (!this.matchLastTypedChars("{")) {
                return;
            }
            if (invokedLine + 1 != currentLine) {
                return;
            }
            if (invokedOffset == 0) return;
            if (textBuffer.getChar(invokedOffset - 1) != '{') {
                return;
            }
            int currentLineEnd = this.editor.getLineEndOffset(currentLine);
            int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentOffset, currentLineEnd);
            if (whitespaceEnd != currentLineEnd && (c = textBuffer.getChar(whitespaceEnd)) != ')') {
                return;
            }
            int indentSize = BasicAction.getIndentSizeProperty((BasicEditorPane)this.editor);
            int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
            boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
            int openLine = invokedLine;
            int openLineStart = lineMap.getLineStartOffset(openLine);
            int firstOffset = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)openLineStart, (int)(openLineEnd = lineMap.getLineEndOffset(openLine)));
            if (firstOffset == -1) {
                throw new IllegalStateException("unexpected empty line");
            }
            int firstColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)openLine, (int)firstOffset, (int)tabSize);
            boolean openBraceAlone = firstOffset == invokedOffset - 1;
            boolean needMoveBrace = moveBraceEnabled && openBraceAlone != this.isOpenBraceAlone();
            int indentedColumn = firstColumn + indentSize;
            int currentLineStart = lineMap.getLineStartOffset(currentLine);
            EditDescriptor descriptorToUse = braceEndEnabled ? braceEndDescriptor : (moveBraceEnabled ? moveOpenBraceDescriptor : autoIndentBlockDescriptor);
            this.editor.beginEdit(descriptorToUse);
            try {
                String indentedIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)indentedColumn);
                int oldIndentSize = currentOffset - currentLineStart;
                document.remove(currentLineStart, oldIndentSize);
                document.insertString(currentLineStart, indentedIndent, null);
                int newCaretOffset = this.editor.getCaretPosition();
                String braceIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)firstColumn);
                String braceEnd = "\n" + braceIndent + "}";
                if (braceEndEnabled) {
                    document.insertString(newCaretOffset, braceEnd, null);
                    this.editor.setCaretPosition(newCaretOffset);
                    Rectangle visibleRect = new Rectangle();
                    this.editor.computeVisibleRect(visibleRect);
                    try {
                        int closeOffset = newCaretOffset + 2;
                        Rectangle closeRect = this.editor.modelToView(closeOffset);
                        if (!visibleRect.contains(closeRect) && visibleRect.y <= closeRect.y) {
                            int diff = closeRect.y - (visibleRect.y + visibleRect.height);
                            visibleRect.y += diff + closeRect.height * 2;
                            visibleRect.y = Math.min(visibleRect.y, this.editor.getHeight() - visibleRect.height);
                            this.editor.scrollRectToVisible(visibleRect);
                        }
                    }
                    catch (BadLocationException closeOffset) {
                        // empty catch block
                    }
                }
                if (!needMoveBrace) return;
                if (this.isOpenBraceAlone()) {
                    String openBraceIndent = "\n" + braceIndent;
                    document.insertString(invokedOffset - 1, openBraceIndent, null);
                    return;
                }
                int previousLine = openLine - 1;
                if (previousLine < 0) return;
                int previousEnd = lineMap.getLineEndOffset(previousLine);
                int previousStart = lineMap.getLineStartOffset(previousLine);
                int realStart = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)previousStart, (int)previousEnd);
                if (realStart == -1 || this.getTokenForOffset(previousEnd - 1) != 0) return;
                document.remove(openLineStart, openLineEnd - openLineStart);
                char charBeforeBrace = textBuffer.getChar(previousEnd - 2);
                String braceToAdd = charBeforeBrace != ' ' ? " {" : "{";
                document.insertString(previousEnd - 1, braceToAdd, null);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                this.editor.endEdit(true);
            }
        }
        finally {
            document.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void charTyped_doAlignCloseBrace(int typedOffset, char typedChar) {
        if (!this.isAlignCloseBraceEnabled()) {
            return;
        }
        if (typedChar != '}') return;
        if (this.getCaretToken() != 0) return;
        BasicDocument document = this.getDocument();
        document.writeLock();
        try {
            int currentColumn;
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int currentOffset = this.editor.getCaretPosition();
            int currentLine = this.editor.getLineFromOffset(currentOffset);
            if (currentOffset != typedOffset + 1) {
                return;
            }
            if (typedOffset >= textBuffer.getLength()) return;
            if (textBuffer.getChar(typedOffset) != '}') {
                return;
            }
            int currentLineStart = lineMap.getLineStartOffset(currentLine);
            int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentLineStart, typedOffset);
            if (whitespaceEnd != typedOffset) {
                return;
            }
            BraceProvider braceProvider = this.getBraceProvider();
            if (braceProvider == null) {
                return;
            }
            NumberRange braceLocation = new NumberRange(0, 0);
            NumberRange matchingLocation = new NumberRange(0, 0);
            int braceType = braceProvider.isPartOfBrace(typedOffset, braceLocation);
            if (braceType == -1) {
                throw new IllegalStateException("could not get brace");
            }
            int matchResult = braceProvider.findMatchingBrace(braceType, braceLocation, matchingLocation);
            if (matchResult == 3) {
                return;
            }
            int matchingOffset = matchingLocation.start;
            int matchingLine = lineMap.getLineFromOffset(matchingOffset);
            int matchingLineStart = lineMap.getLineStartOffset(matchingLine);
            int matchingLineEnd = lineMap.getLineEndOffset(matchingLine);
            int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
            boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
            int firstOffset = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)matchingLineStart, (int)matchingLineEnd);
            if (firstOffset == -1) {
                throw new IllegalStateException("unexpected empty line");
            }
            int firstColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)matchingLine, (int)firstOffset, (int)tabSize);
            if (firstColumn == (currentColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)currentLine, (int)typedOffset, (int)tabSize))) {
                return;
            }
            String newIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)firstColumn);
            this.editor.beginEdit(alignBraceDescriptor);
            try {
                int oldIndentSize = typedOffset - currentLineStart;
                document.remove(currentLineStart, oldIndentSize);
                document.insertString(currentLineStart, newIndent, null);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                this.editor.endEdit(true);
            }
        }
        finally {
            document.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete_preAutoRemoveQuoteEnd() {
        this.isEmptyQuotes = false;
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        document.readLock();
        try {
            int caretToken = this.getCaretToken();
            if (caretToken == 5 || caretToken == 4) {
                char endChar;
                char startChar;
                int tokenStart = this.getCaretTokenStart();
                int caretOffset = this.editor.getCaretPosition();
                if (caretOffset - 1 == tokenStart && caretOffset < textBuffer.getLength() && (startChar = textBuffer.getChar(tokenStart)) == (endChar = textBuffer.getChar(caretOffset))) {
                    this.isEmptyQuotes = true;
                }
            }
        }
        finally {
            document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete_doAutoRemoveQuoteEnd() {
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        if (this.isEmptyQuotes) {
            this.isEmptyQuotes = false;
            BasicDocument document = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                int caretOffset = this.editor.getCaretPosition();
                if (caretOffset < textBuffer.getLength()) {
                    document.remove(caretOffset, 1);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void charTyped_doAutoQuoteEnd(int typedOffset, char typedChar) {
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        document.writeLock();
        try {
            int caretOffset;
            int caretToken = this.getCaretToken();
            if (typedChar == '\'' && caretToken == 5 || this.isStringQuoteChar(typedChar) && caretToken == 4) {
                char nextChar;
                char c;
                int tokenStart = this.getCaretTokenStart();
                if (tokenStart != typedOffset) {
                    return;
                }
                int offset = this.editor.getCaretPosition();
                boolean isMatched = false;
                boolean isEscaped = false;
                boolean isSingleQuoted = false;
                while (offset < textBuffer.getLength() - 1 && (c = textBuffer.getChar(offset++)) != '\n') {
                    if (c == '\\' && !isEscaped) {
                        isEscaped = true;
                        continue;
                    }
                    isSingleQuoted = c == '\'' && !isEscaped;
                    if (c == '\"' && !isEscaped && !isSingleQuoted) {
                        isMatched = !isMatched;
                    }
                    isEscaped = false;
                }
                if (isMatched) {
                    return;
                }
                int caretOffset2 = this.editor.getCaretPosition();
                boolean trailingIdentifier = false;
                if (caretOffset2 < textBuffer.getLength() && Character.isJavaIdentifierPart(nextChar = textBuffer.getChar(caretOffset2))) {
                    trailingIdentifier = true;
                }
                if (trailingIdentifier) return;
                this.editor.beginEdit(quoteEndDescriptor);
                try {
                    document.insertString(caretOffset2, Character.toString(typedChar), null);
                    this.editor.setCaretPosition(caretOffset2);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                finally {
                    this.editor.endEdit(true);
                }
            }
            if (caretToken != 0) return;
            if (typedChar != '\'') {
                if (typedChar != '\"') return;
            }
            if ((caretOffset = this.editor.getCaretPosition()) >= textBuffer.getLength()) return;
            if (textBuffer.getChar(caretOffset) != typedChar) return;
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                document.remove(caretOffset, 1);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                this.editor.endEdit(true);
            }
        }
        finally {
            document.writeUnlock();
        }
    }

    private void enterKey_preAutoQuoteExtend() {
        this.shouldExtendQuotes = false;
        if (!this.isAutoQuoteExtendEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        document.readLock();
        try {
            int caretToken = this.getCaretToken();
            if (caretToken == 4) {
                this.shouldExtendQuotes = true;
            }
        }
        finally {
            document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterKey_doAutoQuoteExtend() {
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        if (this.shouldExtendQuotes) {
            this.shouldExtendQuotes = false;
            int currentLine = this.editor.getLineFromOffset(this.editor.getCaretPosition());
            if (this.lastInvokedLine + 1 != currentLine) {
                return;
            }
            this.editor.beginEdit(quoteExtendDescriptor);
            try {
                String s = Character.toString(this.getAutoQuoteExtendChar(this.lexerToken));
                BasicDocument document = this.getDocument();
                document.insertString(this.editor.getCaretPosition(), s, null);
                document.insertString(this.lastInvokedOffset, s + " +", null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete_preAutoRemoveParenEnd() {
        this.isEmptyParens = false;
        if (!this.isAutoParenEndEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        document.readLock();
        try {
            int closeOffset;
            int openOffset;
            int caretToken = this.getCaretToken();
            if (caretToken == 0 && (openOffset = (closeOffset = this.editor.getCaretPosition()) - 1) >= 0 && closeOffset < textBuffer.getLength()) {
                char openChar = textBuffer.getChar(openOffset);
                char closeChar = textBuffer.getChar(closeOffset);
                if (openChar == '(' && closeChar == ')' || openChar == '[' && closeChar == ']') {
                    this.isEmptyParens = true;
                }
            }
        }
        finally {
            document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete_doAutoRemoveParenEnd() {
        if (!this.isAutoParenEndEnabled()) {
            return;
        }
        if (this.isEmptyParens) {
            this.isEmptyParens = false;
            BasicDocument document = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                int caretOffset = this.editor.getCaretPosition();
                if (caretOffset < textBuffer.getLength()) {
                    char closeChar = textBuffer.getChar(caretOffset);
                    document.remove(caretOffset, 1);
                    this.removeTracker(caretOffset, closeChar);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void charTyped_doAutoParenEnd(int typedOffset, char typedChar) {
        if (!this.isAutoParenEndEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        document.writeLock();
        try {
            boolean isBalanced;
            int caretOffset;
            block29: {
                NumberRange matchingLocation;
                NumberRange braceLocation;
                int braceType;
                int matchResult;
                if (this.caretToken != 0) return;
                if (typedChar == '(' || typedChar == '[') {
                    int caretOffset2 = this.editor.getCaretPosition();
                    if (typedChar == '(') {
                        int line = lineMap.getLineFromOffset(caretOffset2);
                        int endOffset = lineMap.getLineEndOffset(line);
                        this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                        this.lexer.setPosition(caretOffset2);
                        int token = this.lexer.lex(this.lexerToken);
                        int tokenStart = this.lexerToken.getStartOffset();
                        if (tokenStart < endOffset && this.skipCloseParenGeneration(token)) {
                            return;
                        }
                    }
                    char closeChar = typedChar == '(' ? (char)')' : ']';
                    this.editor.beginEdit(parenEndDescriptor);
                    try {
                        document.insertString(caretOffset2, Character.toString(closeChar), null);
                        this.editor.setCaretPosition(caretOffset2);
                        this.addTracker(caretOffset2, closeChar);
                        return;
                    }
                    catch (BadLocationException endOffset) {
                        return;
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                if (typedChar != ')') {
                    if (typedChar != ']') return;
                }
                if ((caretOffset = this.editor.getCaretPosition()) >= textBuffer.getLength()) return;
                if (textBuffer.getChar(caretOffset) != typedChar) return;
                boolean hasAutoClose = this.hasTracker(caretOffset, typedChar);
                if (hasAutoClose) {
                    this.editor.beginEdit(quoteEndDescriptor);
                    try {
                        document.remove(caretOffset, 1);
                        return;
                    }
                    catch (BadLocationException endOffset) {
                        return;
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                BraceProvider braceProvider = this.getBraceProvider();
                if (braceProvider == null) {
                    return;
                }
                this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                this.lexer.setPosition(caretOffset);
                int expectedToken = typedChar == ')' ? this.getRightParenToken() : this.getRightBracketToken();
                isBalanced = true;
                do {
                    int token = this.lexer.lex(this.lexerToken);
                    int tokenStart = this.lexerToken.getStartOffset();
                    if (token != expectedToken) break block29;
                    braceLocation = new NumberRange(0, 0);
                    matchingLocation = new NumberRange(0, 0);
                    braceType = braceProvider.isPartOfBrace(tokenStart, braceLocation);
                    if (braceType != -1) continue;
                    throw new IllegalStateException("could not get brace");
                } while ((matchResult = braceProvider.findMatchingBrace(braceType, braceLocation, matchingLocation)) != 3);
                isBalanced = false;
            }
            if (isBalanced) return;
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                document.remove(caretOffset, 1);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                this.editor.endEdit(true);
            }
        }
        finally {
            document.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTracker(int offset, char closeChar) {
        TextBuffer textBuffer = this.getTextBuffer();
        OffsetMark front = textBuffer.addOffsetMark(offset, true);
        OffsetMark back = textBuffer.addOffsetMark(offset + 1, false);
        EndTracker tracker = new EndTracker(closeChar, front, back);
        List list = this._trackerList;
        synchronized (list) {
            this._trackerList.add(tracker);
        }
    }

    private boolean hasTracker(int offset, char closeChar) {
        EndTracker tracker = this.findTracker(offset, closeChar);
        boolean hasTracker = tracker != null;
        return hasTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTracker(int offset, char closeChar) {
        EndTracker tracker = this.findTracker(offset, closeChar);
        if (tracker != null) {
            List list = this._trackerList;
            synchronized (list) {
                this._trackerList.remove(tracker);
                this.freeTracker(tracker);
            }
        }
    }

    private void freeTracker(EndTracker tracker) {
        TextBuffer textBuffer = this.getTextBuffer();
        if (tracker != null) {
            textBuffer.removeOffsetMark(tracker.front);
            textBuffer.removeOffsetMark(tracker.back);
            tracker.front = (tracker.back = null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndTracker findTracker(int offset, char closeChar) {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            List list = this._trackerList;
            synchronized (list) {
                Iterator iterator = this._trackerList.iterator();
                while (iterator.hasNext()) {
                    int end;
                    EndTracker tracker = (EndTracker)iterator.next();
                    int start = tracker.front.getOffset();
                    if (start == (end = tracker.back.getOffset())) {
                        iterator.remove();
                        this.freeTracker(tracker);
                        continue;
                    }
                    if (start != offset || tracker.closeChar != closeChar) continue;
                    EndTracker endTracker = tracker;
                    return endTracker;
                }
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTrackers() {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            List list = this._trackerList;
            synchronized (list) {
                for (EndTracker tracker : this._trackerList) {
                    this.freeTracker(tracker);
                }
                this._trackerList.clear();
            }
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private static void installPropertyDefaults() {
        EditorProperties properties = EditorProperties.getProperties();
        if (properties.getProperty(PROPERTY_OPEN_BRACE_SAME_LINE) == null) {
            properties.putBooleanProperty(PROPERTY_OPEN_BRACE_SAME_LINE, true);
        }
    }

    static {
        String editName = CEditor.get("UNDO_AUTO_ASTERISK");
        asteriskDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_AUTO_COMMENT_END");
        commentEndDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_AUTO_SPLIT_SLINE_COMMENT");
        splitSingleLineCommentDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_MOVE_OPEN_BRACE");
        moveOpenBraceDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_AUTO_BRACE_END");
        braceEndDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_AUTO_INDENT_BLOCK");
        autoIndentBlockDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_ALIGN_CLOSE_BRACE");
        alignBraceDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_AUTO_QUOTE_END");
        quoteEndDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_AUTO_PAREN_END");
        quoteExtendDescriptor = new EditDescriptor(editName);
        editName = CEditor.get("UNDO_AUTO_QUOTE_EXTEND");
        parenEndDescriptor = new EditDescriptor(editName);
        AbstractEditingPlugin.installPropertyDefaults();
    }

    private static class EndTracker {
        private OffsetMark front;
        private OffsetMark back;
        private char closeChar;

        private EndTracker(char closeChar, OffsetMark front, OffsetMark back) {
            this.front = front;
            this.back = back;
            this.closeChar = closeChar;
        }
    }
}

