/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;

public class OAEPAlgorithmIdentifier
extends AlgorithmIdentifier {
    static final ASN1ObjectID a = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 7);
    static final ASN1ObjectID b = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 9);
    static final AlgorithmIdentifier c = new AlgorithmIdentifier(b, new ASN1OctetString(new byte[0]));
    private AlgorithmIdentifier d;
    private AlgorithmIdentifier e;
    private AlgorithmIdentifier f;

    public OAEPAlgorithmIdentifier(ASN1Object aSN1Object) throws AlgorithmIdentifierException {
        super(a, aSN1Object);
        this.a();
    }

    public OAEPAlgorithmIdentifier() {
        this(AlgID.sha1, AlgID.mgf1WithSHA1, c);
    }

    public OAEPAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3) {
        super(a, OAEPAlgorithmIdentifier.a(algorithmIdentifier, algorithmIdentifier2, algorithmIdentifier3));
        this.d = algorithmIdentifier;
        this.e = algorithmIdentifier2;
        this.f = algorithmIdentifier3;
    }

    private static AlgorithmIdentifier a(String string) {
        if (string.equalsIgnoreCase("SHA-1")) {
            return AlgID.sha1;
        }
        if (string.equalsIgnoreCase("SHA-224")) {
            return AlgID.sha_224;
        }
        if (string.equalsIgnoreCase("SHA-256")) {
            return AlgID.sha_256;
        }
        if (string.equalsIgnoreCase("SHA-384")) {
            return AlgID.sha_384;
        }
        if (string.equalsIgnoreCase("SHA-512")) {
            return AlgID.sha_512;
        }
        if (string.equalsIgnoreCase("MD5")) {
            return AlgID.md5;
        }
        return null;
    }

    private static AlgorithmIdentifier a(byte[] byArray) {
        if (byArray != null) {
            return new AlgorithmIdentifier(b, new ASN1OctetString(byArray));
        }
        return new AlgorithmIdentifier(b, new ASN1OctetString(new byte[0]));
    }

    public OAEPAlgorithmIdentifier(String string, byte[] byArray) {
        this(OAEPAlgorithmIdentifier.a(string), AlgID.mgf1WithSHA1, OAEPAlgorithmIdentifier.a(byArray));
        AlgorithmIdentifier algorithmIdentifier = string.equalsIgnoreCase("MD5") ? AlgID.mgf1WithMD5 : (string.equalsIgnoreCase("SHA-224") ? AlgID.mgf1WithSHA224 : (string.equalsIgnoreCase("SHA-256") ? AlgID.mgf1WithSHA256 : (string.equalsIgnoreCase("SHA-384") ? AlgID.mgf1WithSHA384 : (string.equalsIgnoreCase("SHA-512") ? AlgID.mgf1WithSHA512 : null))));
        if (algorithmIdentifier != null) {
            this.a(algorithmIdentifier);
        }
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) {
        this.e = algorithmIdentifier;
    }

    public OAEPAlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a() throws AlgorithmIdentifierException {
        ASN1Sequence aSN1Sequence;
        ArrayList<ASN1Object> arrayList;
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)this.getParameters();
        ArrayList<ASN1Object> arrayList2 = aSN1Sequence2.elementsAsList();
        if (arrayList2.size() > 3) {
            throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        }
        int n = 0;
        int n2 = arrayList2.size();
        if (n2 == 0) {
            this.d = AlgID.sha1;
            this.e = AlgID.mgf1WithSHA1;
            this.f = c;
            return;
        }
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)arrayList2.get(n);
        if (aSN1GenericConstructed.getTag() == 0) {
            ++n;
            arrayList = aSN1GenericConstructed.elementsAsList();
            if (arrayList.size() != 1) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
            if (arrayList.get(0) instanceof ASN1Sequence) {
                aSN1Sequence = (ASN1Sequence)arrayList.get(0);
                this.d = new AlgorithmIdentifier((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Sequence.elementAt(1));
            } else {
                if (!(arrayList.get(0) instanceof AlgorithmIdentifier)) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
                this.d = (AlgorithmIdentifier)arrayList.get(0);
            }
            if (n == n2) {
                this.e = AlgID.mgf1WithSHA1;
                this.f = c;
                return;
            }
            aSN1GenericConstructed = (ASN1GenericConstructed)arrayList2.get(n);
        } else {
            this.d = AlgID.sha1;
        }
        if (aSN1GenericConstructed.getTag() == 1) {
            ++n;
            arrayList = aSN1GenericConstructed.elementsAsList();
            if (arrayList.size() != 1) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
            if (arrayList.get(0) instanceof ASN1Sequence) {
                aSN1Sequence = (ASN1Sequence)arrayList.get(0);
                this.e = new AlgorithmIdentifier((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Sequence.elementAt(1));
            } else {
                if (!(arrayList.get(0) instanceof AlgorithmIdentifier)) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
                this.e = (AlgorithmIdentifier)arrayList.get(0);
            }
            if (n == n2) {
                this.f = c;
                return;
            }
            aSN1GenericConstructed = (ASN1GenericConstructed)arrayList2.get(n);
        } else {
            this.e = AlgID.mgf1WithSHA1;
        }
        if (aSN1GenericConstructed.getTag() != 2) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        ++n;
        arrayList = aSN1GenericConstructed.elementsAsList();
        if (arrayList.size() != 1) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        if (arrayList.get(0) instanceof ASN1Sequence) {
            aSN1Sequence = (ASN1Sequence)arrayList.get(0);
            this.f = new AlgorithmIdentifier((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Sequence.elementAt(1));
            return;
        } else {
            if (!(arrayList.get(0) instanceof AlgorithmIdentifier)) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
            this.f = (AlgorithmIdentifier)arrayList.get(0);
        }
    }

    public AlgorithmIdentifier getHashFunc() {
        return (AlgorithmIdentifier)this.d.clone();
    }

    public AlgorithmIdentifier getMaskGenFunc() {
        return (AlgorithmIdentifier)this.e.clone();
    }

    public AlgorithmIdentifier getPSourceFunc() {
        return this.f;
    }

    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.a();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException("Problem decoding the parameters: " + algorithmIdentifierException.toString());
        }
    }

    private static ASN1Object a(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (!algorithmIdentifier.equals(AlgID.sha1)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier, 0));
        }
        if (!algorithmIdentifier2.equals(AlgID.mgf1WithSHA1)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier2, 1));
        }
        if (!algorithmIdentifier3.equals(c)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier3, 2));
        }
        return aSN1Sequence;
    }

    public Object clone() {
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = null;
        AlgorithmIdentifier algorithmIdentifier3 = null;
        if (this.d != null) {
            algorithmIdentifier = (AlgorithmIdentifier)this.d.clone();
        }
        if (this.e != null) {
            algorithmIdentifier2 = (AlgorithmIdentifier)this.e.clone();
        }
        if (this.f != null) {
            algorithmIdentifier3 = (AlgorithmIdentifier)this.f.clone();
        }
        return new OAEPAlgorithmIdentifier(algorithmIdentifier, algorithmIdentifier2, algorithmIdentifier3);
    }
}

