/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DSAKeyPairGenerator;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.core.math.Prime;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class DSAParams
implements Externalizable,
java.security.interfaces.DSAParams,
ASN1Object {
    private BigInt a;
    private BigInt b;
    private BigInt c;
    private byte[] d;
    private int e;
    private transient BigInt f;
    private ASN1Sequence g;

    public DSAParams() {
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3));
    }

    DSAParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3) {
        FIPS_140_2.assertReadyState();
        this.a = bigInt;
        this.b = bigInt2;
        this.c = bigInt3;
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n, BigInteger bigInteger4) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), byArray, n, BigInt.getInstance(bigInteger4));
    }

    DSAParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, byte[] byArray, int n, BigInt bigInt4) {
        FIPS_140_2.assertReadyState();
        this.a = bigInt;
        this.b = bigInt2;
        this.c = bigInt3;
        this.d = byArray;
        this.e = n;
        this.f = bigInt4;
    }

    public DSAParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAParams(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public BigInteger getP() {
        return new BigInteger(this.a().toByteArray());
    }

    BigInt a() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public BigInteger getQ() {
        return new BigInteger(this.b().toByteArray());
    }

    BigInt b() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public BigInteger getG() {
        return new BigInteger(this.c().toByteArray());
    }

    BigInt c() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public byte[] getSeed() {
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    public int getCounter() {
        FIPS_140_2.assertReadyState();
        return this.e;
    }

    public BigInteger getH() {
        return new BigInteger(this.d().toByteArray());
    }

    BigInt d() {
        FIPS_140_2.assertReadyState();
        return this.f;
    }

    public boolean isValidParams() {
        FIPS_140_2.assertReadyState();
        if (this.d == null || this.e == 0 || this.f == null) {
            throw new IllegalStateException("Missing validation parameters");
        }
        if (this.d.length < 20) {
            return false;
        }
        if (this.e >= 4096 || this.e < 0) {
            return false;
        }
        MessageDigest messageDigest = null;
        RandomBitsSource randomBitsSource = RandomBitsSource.getDefault();
        if (this.b.bitLength() != 160 || !Prime.isProbablePrime(this.b, 100, randomBitsSource)) {
            return false;
        }
        if (this.c.compareTo(BigInt.ONE) == 0 || this.f.compareTo(BigInt.TWO) < 0 || this.f.compareTo(this.a.subtract(BigInt.TWO)) > 0 || this.c.compareTo(this.f.modPow(this.a.subtract(BigInt.ONE).divide(this.b), this.a)) != 0) {
            return false;
        }
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        byte[] byArray = new byte[this.d.length];
        System.arraycopy(this.d, 0, byArray, 0, this.d.length);
        BigInt bigInt = DSAKeyPairGenerator.a(byArray, messageDigest);
        if (this.b.compareTo(bigInt) != 0) {
            return false;
        }
        BigInt bigInt2 = null;
        int n = 0;
        int n2 = this.a.bitLength();
        while (!((bigInt2 = DSAKeyPairGenerator.a(n2, this.b, byArray, messageDigest)).compareTo(BigInt.ONE.shiftLeft(n2 - 1)) > 0 && Prime.isProbablePrime(bigInt2, 100, randomBitsSource) || ++n > this.e)) {
        }
        return n == this.e && this.a.compareTo(bigInt2) == 0;
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        FIPS_140_2.assertReadyState();
        this.g = aSN1Sequence;
        this.d = null;
        try {
            this.a = ((ASN1Integer)aSN1Sequence.elementAt(0)).getBigIntValue();
            this.b = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            this.c = ((ASN1Integer)aSN1Sequence.elementAt(2)).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    public ASN1Sequence outputASN1() {
        FIPS_140_2.assertReadyState();
        if (this.g != null) {
            return this.g;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(this.a));
        aSN1Sequence.addElement(new ASN1Integer(this.b));
        aSN1Sequence.addElement(new ASN1Integer(this.c));
        this.g = aSN1Sequence;
        return aSN1Sequence;
    }

    public int length() {
        return this.outputASN1().length();
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        String string = "p = " + this.a + ", q = " + this.b + ", g = " + this.c;
        if (this.d != null) {
            string = string + ",\nseed = " + Utils.toHexString(this.d) + ", counter = " + this.e;
        }
        return string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

