/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DHParameterGenerator;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.DHPublicKey;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.KeyPairGenerator;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.a;
import oracle.security.crypto.core.math.BigInt;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    private static final ASN1ObjectID a = AlgID.dh.getOID();
    private DHParams b;
    private boolean c = false;

    public void initialize(DHParams dHParams, RandomBitsSource randomBitsSource) {
        oracle.security.crypto.core.a.a(dHParams.getP().bitLength(), 4096);
        this.b = dHParams;
        this.setRandomBitsSource(randomBitsSource);
        this.c = true;
    }

    public void initialize(int n, int n2, RandomBitsSource randomBitsSource) {
        DHParameterGenerator dHParameterGenerator = new DHParameterGenerator();
        dHParameterGenerator.initialize(n, n2, randomBitsSource);
        this.initialize(dHParameterGenerator.generateParameters(), randomBitsSource);
    }

    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.initialize(n, 160, randomBitsSource);
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (!algorithmIdentifier.getOID().equals(a)) {
            throw new AlgorithmIdentifierException("Unknown DH key algorithm identifier");
        }
        ASN1Object aSN1Object = algorithmIdentifier.getParameters();
        if (aSN1Object != null && aSN1Object.getClass() != ASN1Null.class) {
            this.b = (DHParams)aSN1Object;
        }
    }

    public KeyPair generateKeyPair() {
        if (!this.c) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        BigInt bigInt = this.b.a();
        BigInt bigInt2 = this.b.b();
        BigInt bigInt3 = this.b.c();
        BigInt bigInt4 = null;
        int n = bigInt2.bitLength();
        while ((bigInt4 = this.d.randomBigInt(n)).compareTo(BigInt.ONE) <= 0 || bigInt4.compareTo(bigInt2) >= 0) {
        }
        BigInt bigInt5 = bigInt3.modPow(bigInt4, bigInt);
        DHPublicKey dHPublicKey = new DHPublicKey(bigInt5, this.b);
        DHPrivateKey dHPrivateKey = new DHPrivateKey(bigInt4, this.b);
        return new KeyPair(dHPublicKey, dHPrivateKey);
    }
}

