/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.DES;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.a;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Utils;

public final class DES_EDE
extends BlockCipher {
    private static final int g = 8;
    private int[] h;
    private int[] i;
    private int[] j;
    private int[] k;
    private byte[] l;
    private byte[] m;
    private boolean n;

    public DES_EDE() {
        super(8);
        this.d = 0;
        this.k = new int[2];
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        oracle.security.crypto.core.a.a(symmetricKey != null ? symmetricKey.getBitLength() - 24 : 0, 168);
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.e = symmetricKey;
        this.n = false;
        this.c();
        this.f = randomBitsSource;
        this.a = null;
        this.a(algorithmIdentifier);
        this.c = iD;
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.d = 0;
        } else if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_CBC.getOID())) {
            this.d = 1;
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for DES_EDE");
        }
    }

    private void b(byte[] byArray) throws AlgorithmIdentifierException {
        try {
            if (byArray != null) {
                this.a(byArray);
            } else if (this.a == null) {
                this.a(this.b().randomBytes(new byte[this.getBlockSize()]));
            } else {
                this.a(this.a);
            }
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
    }

    private void a(boolean bl) {
        oracle.security.crypto.core.a.a(this.e != null ? this.e.getBitLength() - 24 : 0, 168);
        byte[] byArray = ((SymmetricKey)this.e).d();
        if (byArray.length != 24 && byArray.length != 16 && byArray.length != 8) {
            throw new IllegalArgumentException("DES-EDE key must be 8, 16 or 24 bytes long.");
        }
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        if (byArray.length > 8) {
            System.arraycopy(byArray, 8, byArray3, 0, 8);
        } else {
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
        }
        if (byArray.length > 16) {
            System.arraycopy(byArray, 16, byArray4, 0, 8);
        } else {
            System.arraycopy(byArray2, 0, byArray4, 0, 8);
        }
        this.h = new int[32];
        this.i = new int[32];
        this.j = new int[32];
        DES.a(byArray2, this.h, bl);
        DES.a(byArray3, this.i, !bl);
        DES.a(byArray4, this.j, bl);
        if (this.l == null) {
            this.l = new byte[8];
            this.m = new byte[8];
        }
        Utils.setArray(byArray2, (byte)0);
        Utils.setArray(byArray3, (byte)0);
        Utils.setArray(byArray4, (byte)0);
        this.n = true;
    }

    protected void a(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (!this.n) {
            this.a(false);
        }
        DES.a(byArray, n, this.l, 0, this.j, this.k);
        DES.a(this.l, 0, this.m, 0, this.i, this.k);
        DES.a(this.m, 0, byArray2, n2, this.h, this.k);
    }

    protected void b(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (!this.n) {
            this.a(true);
        }
        DES.a(byArray, n, this.l, 0, this.h, this.k);
        DES.a(this.l, 0, this.m, 0, this.i, this.k);
        DES.a(this.m, 0, byArray2, n2, this.j, this.k);
    }

    public String algName() {
        return "DES-EDE" + (this.d == 1 ? "-CBC" : "");
    }

    public void erase() {
        super.erase();
        Utils.setArray(this.h, 0);
        Utils.setArray(this.i, 0);
        Utils.setArray(this.j, 0);
        Utils.setArray(this.l, (byte)0);
        Utils.setArray(this.m, (byte)0);
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.d == 0) {
            return AlgID.DES_EDE3_ECB;
        }
        if (this.d == 1) {
            return new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), this.getIV());
        }
        throw new IllegalStateException("unknown mode " + this.d);
    }

    public String toString() {
        return this.algName();
    }
}

