/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.core.Coder;
import oracle.security.crypto.core.CoderException;
import oracle.security.crypto.fips.FIPS_140_2;

public class CoderInputStream
extends FilterInputStream {
    public static final int DECODE_MODE = 0;
    public static final int ENCODE_MODE = 1;
    protected int a = 0;
    protected Coder b;
    protected byte[] c;
    protected int d;

    public CoderInputStream(InputStream inputStream, Coder coder) {
        super(inputStream);
        this.b = coder;
        this.c = new byte[this.b.getBlockSize()];
        this.d = this.b.getBlockSize();
    }

    public Coder getCoder() {
        return this.b;
    }

    public int getMode() {
        return this.a;
    }

    public void setMode(int n) {
        this.a = n;
    }

    public synchronized int read() throws IOException {
        FIPS_140_2.assertReadyState();
        if (this.d < this.b.getBlockSize()) {
            return this.c[this.d++] & 0xFF;
        }
        byte[] byArray = new byte[this.b.getBlockSize()];
        int n = this.b.getBlockSize();
        for (int i = 0; i < n; ++i) {
            int n2 = this.in.read();
            if (n2 == -1) {
                return -1;
            }
            byArray[i] = (byte)n2;
        }
        try {
            this.c = this.a == 1 ? this.b.encodeOp(byArray) : this.b.decodeOp(byArray);
            this.d = 0;
        }
        catch (CoderException coderException) {
            throw new IOException(coderException.toString());
        }
        return this.c[this.d++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        return n4 != 0 ? n4 : -1;
    }

    public synchronized int available() throws IOException {
        int n = this.b.getBlockSize();
        return n - this.d + this.in.available() / n * n;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

