/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AlgorithmIdentifier
implements Externalizable,
Cloneable,
ASN1Object {
    private ASN1ObjectID a;
    private ASN1Object b;
    private ASN1Sequence c;

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.a = aSN1ObjectID;
        this.b = aSN1Object;
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, boolean bl) {
        this.a = aSN1ObjectID;
        this.b = bl ? new ASN1Null() : null;
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, true);
    }

    public AlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public AlgorithmIdentifier(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        this.a(aSN1Sequence);
    }

    public AlgorithmIdentifier() {
    }

    public ASN1ObjectID getOID() {
        return this.a;
    }

    public ASN1Object getParameters() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AlgorithmIdentifier)) {
            return false;
        }
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)object;
        if (!this.a.equals(algorithmIdentifier.getOID())) {
            return false;
        }
        if (this.b == null || this.b instanceof ASN1Null) {
            return algorithmIdentifier.getParameters() == null || algorithmIdentifier.getParameters() instanceof ASN1Null;
        }
        if (algorithmIdentifier.b == null || algorithmIdentifier.b instanceof ASN1Null) {
            return false;
        }
        return Utils.areEqual(Utils.toBytes(this.b), Utils.toBytes(algorithmIdentifier.getParameters()));
    }

    public int hashCode() {
        return this.a.hashCode() + (this.b == null || this.b instanceof ASN1Null ? 0 : Utils.hashBytes(this.b));
    }

    public String toString() {
        return "{ oid = " + this.a.toStringCompact() + ", parameters = " + this.b + " }";
    }

    public Object clone() {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier();
        if (this.a != null) {
            int[] nArray = (int[])this.a.getValue().clone();
            algorithmIdentifier.a = new ASN1ObjectID(nArray);
        }
        try {
            if (this.b != null) {
                algorithmIdentifier.b = ASN1Utils.inputASN1Object(Utils.toStream(this.b));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier parameters to stream: " + iOException.toString());
        }
        try {
            if (this.c != null) {
                algorithmIdentifier.c = new ASN1Sequence(Utils.toStream(this.c));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier contents to stream: " + iOException.toString());
        }
        return algorithmIdentifier;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        this.a(aSN1Sequence);
    }

    private void a(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        try {
            this.a = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            this.b = aSN1Sequence.size() == 1 ? null : aSN1Sequence.elementAt(1);
            this.c = null;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ASN1FormatException(arrayIndexOutOfBoundsException.toString());
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
    }

    public int length() {
        return this.a().length();
    }

    private ASN1Sequence a() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.a);
            if (this.b != null) {
                aSN1Sequence.addElement(this.b);
            }
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

