/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.VectorOverArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1Sequence
implements ASN1Constructed,
ASN1TaggedObject {
    private ArrayList<ASN1Object> a = new ArrayList();
    private ASN1Header b = null;
    private int c;

    public ASN1Sequence() {
    }

    public ASN1Sequence(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public ASN1Sequence(Vector<? extends ASN1Object> vector) {
        this.a = vector == null ? null : new ArrayList<ASN1Object>(vector);
        this.c = 0;
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            this.c += this.a.get(i).length();
        }
    }

    public ASN1Sequence(List<? extends ASN1Object> list) {
        this((Collection<? extends ASN1Object>)list);
    }

    public ASN1Sequence(Collection<? extends ASN1Object> collection) {
        this.a = collection == null ? null : new ArrayList<ASN1Object>(collection);
        this.c = 0;
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            this.c += this.a.get(i).length();
        }
    }

    public ASN1Sequence(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public ASN1Header getHeader() {
        if (this.b == null) {
            this.b = ASN1Sequence.makeHeader(this.c);
        }
        return this.b;
    }

    @Override
    public Vector<ASN1Object> elements() {
        return this.a == null ? null : new VectorOverArrayList<ASN1Object>(this.a);
    }

    @Override
    public ArrayList<ASN1Object> elementsAsList() {
        return this.a;
    }

    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    public ASN1Object elementAt(int n) {
        return this.a.get(n);
    }

    public ASN1Object firstElement() {
        return this.a.get(0);
    }

    public ASN1Object lastElement() {
        return this.a.get(this.a.size() - 1);
    }

    public void addElement(ASN1Object aSN1Object) {
        this.a.add(aSN1Object);
        this.c += aSN1Object.length();
        this.b = null;
    }

    public static ASN1Header makeHeader(int n) {
        return new ASN1Header(16, 0, 1, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SEQUENCE {");
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.a.get(i).toString());
            if (i == this.a.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.a = new ArrayList();
        this.c = 0;
        while (aSN1SequenceInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
            this.a.add(aSN1Object);
            this.c += aSN1Object.length();
        }
        aSN1SequenceInputStream.terminate();
        this.b = null;
    }

    @Override
    public int length() {
        return this.getHeader().totalLength();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            this.a.get(i).output(outputStream);
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

