/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableModel;
import oracle.ide.peek.Peek;
import oracle.ide.peek.Peekable;

public abstract class PeekableTable
extends JTable
implements Peekable {
    private boolean isPeeking = false;

    public PeekableTable() {
    }

    public PeekableTable(TableModel model) {
        super(model);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.isPeeking) {
            return null;
        }
        return super.getToolTipText(event);
    }

    @Override
    public String getToolTipText() {
        if (this.isPeeking) {
            return null;
        }
        return super.getToolTipText();
    }

    @Override
    public Peek peek(Point p) {
        Peek peek;
        SwingUtilities.convertPointFromScreen(p, this);
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (this.getCellRect(row, col, false).contains(p) && (peek = this.createPeek(row, col)) != null) {
            peek.showPeek();
            if (this.getCellRenderer(row, col) instanceof JComponent) {
                ((JComponent)((Object)this.getCellRenderer(row, col))).setToolTipText(null);
            }
            this.isPeeking = true;
            peek.getGhostPointingPalette().addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    peek.getGhostPointingPalette().removeAncestorListener((AncestorListener)this);
                    PeekableTable.this.isPeeking = false;
                }
            });
            return peek;
        }
        return null;
    }

    public abstract Peek createPeek(int var1, int var2);
}

