/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.ide.hover.HoverProperties;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class Peek
implements Hover,
HoverProperties {
    private GhostPointingPalette gPanel = new GhostPointingPalette();
    private JComponent contentComp;
    private JScrollPane sp;
    private JLabel label = new JLabel();
    private JComponent comp;
    private Rectangle rect;
    private boolean autohide = true;
    private AutoHideMouseListener autoHideMouseListener = new AutoHideMouseListener();
    private HoverFlavor flavor;
    private Collection<HoverListener> hoverListeners = new ArrayList<HoverListener>();
    private boolean hideOnKeyPresses = true;
    private boolean mouseWasInPanel = false;
    private boolean hidden = false;

    public Peek(JComponent comp, JComponent contentComp) {
        this(comp, contentComp, HoverFlavor.getFlavor((String)"source"));
    }

    public Peek(JComponent comp, JComponent contentComp, HoverFlavor flavor) {
        this.comp = comp;
        this.contentComp = contentComp;
        this.flavor = flavor;
        assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
        this.gPanel = new GhostPointingPalette(){

            public void dispose() {
                super.dispose();
                assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
                Peek.this.gPanel = null;
            }
        };
        this.gPanel.setLayout((LayoutManager)new BorderLayout());
        this.gPanel.setLook(UIConstants.Look.DARK);
        this.gPanel.setCloseVisible(false);
        this.gPanel.setReceivesFocus(false);
        this.sp = new JScrollPane(this.getContentComponent());
        this.sp.setBorder(null);
        if (this.isContentTransparent()) {
            this.gPanel.registerTransparentComponent((JComponent)this.sp.getViewport());
        }
        JPanel footer = new JPanel(new BorderLayout());
        footer.setLayout(new BorderLayout());
        footer.add((Component)this.label, "After");
        footer.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.gPanel.add((Component)this.sp, (Object)"Center");
        this.gPanel.add((Component)footer, (Object)"South");
        this.label.setVisible(false);
    }

    protected boolean isContentTransparent() {
        return true;
    }

    public void hidePeek() {
        if (this.hidden) {
            return;
        }
        this.hidden = true;
        assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
        if (this.gPanel != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoHideMouseListener);
            this.gPanel.hidePanel();
            this.gPanel = null;
            this.contentComp = null;
            this.comp = null;
        }
        HoverEvent hoverEvent = HoverEvent.createHiddenHoverEvent();
        for (Object listener : this.hoverListeners.toArray()) {
            ((HoverListener)listener).hoverChange(hoverEvent);
        }
        this.hoverListeners.clear();
    }

    public boolean isShowing() {
        return this.gPanel != null && this.gPanel.isShowing();
    }

    public JComponent getContentComponent() {
        return this.contentComp;
    }

    public void setLabelText(String text) {
        if (text != null) {
            this.label.setText(text);
            this.label.setVisible(true);
        } else {
            this.label.setVisible(false);
        }
    }

    public void setLabelIcon(Icon labelIcon) {
        this.label.setIcon(labelIcon);
    }

    public void setRectangle(Rectangle rect) {
        this.rect = rect;
    }

    public void showPeek() {
        Window activeW = null;
        for (Window w : Window.getWindows()) {
            if (!w.isActive()) continue;
            activeW = w;
            break;
        }
        if (activeW == null || !(activeW instanceof RootPaneContainer)) {
            return;
        }
        this.showPeek(((RootPaneContainer)((Object)activeW)).getLayeredPane());
    }

    public void showPeek(JLayeredPane layerPane) {
        assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
        if (this.autohide) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.autoHideMouseListener, 32L);
        }
        if (this.gPanel == null) {
            return;
        }
        this.mouseWasInPanel = false;
        this.gPanel.setPointing(this.comp, this.rect);
        Dimension epPrefSize = this.contentComp.getPreferredSize();
        this.contentComp.setPreferredSize(new Dimension(epPrefSize.width, epPrefSize.height + 10));
        this.gPanel.pack();
        this.rect = SwingUtilities.convertRectangle(this.comp, this.rect, layerPane);
        Point location = new Point(this.rect.x + this.rect.width / 2 - this.gPanel.getWidth() / 2, this.rect.y + this.rect.height + 15);
        location.x = Math.max(5, location.x);
        int heightOver = location.y + this.gPanel.getHeight() - layerPane.getHeight();
        Dimension prefSize = this.contentComp.getPreferredSize();
        if (layerPane.getHeight() - this.rect.y < prefSize.height + 50 && this.rect.y > layerPane.getHeight() / 2) {
            int topMostY = 75;
            int pointGap = 45;
            location.y = Math.max(topMostY, this.rect.y - prefSize.height - pointGap);
            if (prefSize.height > this.rect.y - topMostY - pointGap) {
                prefSize.height = this.rect.y - topMostY - pointGap;
                prefSize.width = (int)((double)prefSize.width + this.sp.getVerticalScrollBar().getPreferredSize().getWidth());
            }
            this.contentComp.setPreferredSize(prefSize);
            this.contentComp.setSize(prefSize);
            this.gPanel.pack();
        } else if (heightOver > 0) {
            prefSize.height -= heightOver + 30;
            prefSize.width = (int)((double)prefSize.width + this.sp.getVerticalScrollBar().getPreferredSize().getWidth());
            this.contentComp.setPreferredSize(prefSize);
            this.contentComp.setSize(prefSize);
            this.gPanel.pack();
        }
        int widthOver = location.x + this.gPanel.getWidth() - layerPane.getWidth();
        if (widthOver > 0) {
            location.x -= widthOver + 10;
            if (location.x < 10) {
                prefSize.width = prefSize.width + location.x - 10;
                location.x = 10;
            }
            prefSize.height = (int)((double)prefSize.height + this.sp.getHorizontalScrollBar().getPreferredSize().getHeight());
            this.contentComp.setPreferredSize(prefSize);
            this.contentComp.setSize(prefSize);
            this.gPanel.pack();
        }
        this.hidden = false;
        this.gPanel.setLocation(location);
        this.gPanel.setOwningComponent(this.comp);
        this.gPanel.show(layerPane, false, false);
    }

    public GhostPointingPalette getGhostPointingPalette() {
        return this.gPanel;
    }

    @Deprecated
    public GhostPalette getGhostPalette() {
        return this.gPanel;
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public void showHover() {
        this.showPeek();
    }

    public void hideHover() {
        this.hidePeek();
    }

    public void setAutohide(boolean autohide) {
        this.autohide = autohide;
    }

    public boolean isAutohide() {
        return this.autohide;
    }

    public HoverFlavor getFlavor() {
        return null;
    }

    public void addHoverListener(HoverListener hoverListener) {
        this.hoverListeners.add(hoverListener);
    }

    public void removeHoverListener(HoverListener hoverListener) {
        this.hoverListeners.remove(hoverListener);
    }

    public boolean isPointWithinHover(Point p) {
        if (this.gPanel == null) {
            this.hideHover();
            return false;
        }
        if (!this.gPanel.isShowing()) {
            return false;
        }
        Rectangle r = new Rectangle(this.gPanel.getLocationOnScreen(), this.gPanel.getSize());
        return r.contains(p);
    }

    public boolean shouldHideHover(KeyEvent event) {
        return this.hideOnKeyPresses || event.getKeyCode() == 27;
    }

    public void setHideOnKeyPress(boolean hideOnKeyPresses) {
        this.hideOnKeyPresses = hideOnKeyPresses;
    }

    public boolean isHideOnKeyPress() {
        return this.hideOnKeyPresses;
    }

    public void setProperty(HoverProperties.Property property, Object object) {
        switch (property) {
            case RECTANGLE: {
                this.setRectangle((Rectangle)object);
            }
        }
    }

    public Object getProperty(HoverProperties.Property property) {
        switch (property) {
            case RECTANGLE: {
                return this.getRectangle();
            }
        }
        return null;
    }

    private Rectangle getRectangle() {
        return this.rect;
    }

    private class AutoHideMouseListener
    implements AWTEventListener {
        private AutoHideMouseListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
                if (Peek.this.gPanel == null) {
                    Peek.this.hideHover();
                    return;
                }
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (pointerInfo == null) {
                    Peek.this.hideHover();
                    return;
                }
                Point p = pointerInfo.getLocation();
                if (p == null) {
                    Peek.this.hideHover();
                    return;
                }
                Rectangle r = new Rectangle(Peek.this.rect);
                JComponent c2 = (JComponent)Peek.this.gPanel.getParent();
                if (!c2.isShowing()) {
                    Peek.this.hideHover();
                    return;
                }
                r.translate(c2.getLocationOnScreen().x, c2.getLocationOnScreen().y);
                r.grow(6, 6);
                if (r.contains(p)) {
                    return;
                }
                Rectangle r2 = new Rectangle(Peek.this.gPanel.getLocationOnScreen(), Peek.this.gPanel.getSize());
                if (r2.contains(p)) {
                    Peek.this.mouseWasInPanel = true;
                    return;
                }
                if (!Peek.this.mouseWasInPanel) {
                    int ydiff = r2.y - (r.y + r.height);
                    if (ydiff > 0) {
                        r2.y -= ydiff;
                        r2.height += ydiff;
                    } else {
                        ydiff = r.y - r2.y - r2.height;
                        r2.height += ydiff;
                    }
                    r2.grow(6, 6);
                    if (r2.contains(p)) {
                        return;
                    }
                }
                Peek.this.hidePeek();
            }
        }
    }
}

