/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateGroupLoader;

public class PathGroupLoader
implements StringTemplateGroupLoader {
    protected List dirs = null;
    protected StringTemplateErrorListener errors = null;
    String fileCharEncoding = System.getProperty("file.encoding");

    public PathGroupLoader(StringTemplateErrorListener stringTemplateErrorListener) {
        this.errors = stringTemplateErrorListener;
    }

    public PathGroupLoader(String string, StringTemplateErrorListener stringTemplateErrorListener) {
        this.errors = stringTemplateErrorListener;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (this.dirs == null) {
                this.dirs = new ArrayList();
            }
            this.dirs.add(string2);
        }
    }

    public StringTemplateGroup loadGroup(String string, StringTemplateGroup stringTemplateGroup) {
        StringTemplateGroup stringTemplateGroup2 = null;
        try {
            BufferedReader bufferedReader = this.locate(string + ".stg");
            if (bufferedReader == null) {
                this.error("no such group file " + string + ".stg");
                return null;
            }
            stringTemplateGroup2 = new StringTemplateGroup(bufferedReader, null, this.errors, stringTemplateGroup);
        }
        catch (IOException iOException) {
            this.error("can't load group " + string, iOException);
        }
        return stringTemplateGroup2;
    }

    public StringTemplateGroup loadGroup(String string) {
        return this.loadGroup(string, null);
    }

    public StringTemplateGroupInterface loadInterface(String string) {
        StringTemplateGroupInterface stringTemplateGroupInterface = null;
        try {
            BufferedReader bufferedReader = this.locate(string + ".sti");
            if (bufferedReader == null) {
                this.error("no such interface file " + string + ".sti");
                return null;
            }
            stringTemplateGroupInterface = new StringTemplateGroupInterface(bufferedReader, this.errors);
        }
        catch (IOException iOException) {
            this.error("can't load interface " + string, iOException);
        }
        return stringTemplateGroupInterface;
    }

    protected BufferedReader locate(String string) throws IOException {
        for (int i = 0; i < this.dirs.size(); ++i) {
            String string2 = (String)this.dirs.get(i);
            String string3 = string2 + "/" + string;
            if (!new File(string3).exists()) continue;
            FileInputStream fileInputStream = new FileInputStream(string3);
            InputStreamReader inputStreamReader = this.getInputStreamReader(fileInputStream);
            return new BufferedReader(inputStreamReader);
        }
        return null;
    }

    protected InputStreamReader getInputStreamReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return inputStreamReader;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String string) {
        this.fileCharEncoding = string;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Exception exception) {
        if (this.errors != null) {
            this.errors.error(string, exception);
        } else if (exception != null) {
            exception.printStackTrace();
        }
    }
}

