/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class KeyUsageExtension
extends X509Extension {
    public static final int DIGITAL_SIGNATURE = 0;
    public static final int NON_REPUDIATION = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int DATA_ENCIPHERMENT = 3;
    public static final int KEY_AGREEMENT = 4;
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final int ENCIPHER_ONLY = 7;
    public static final int DECIPHER_ONLY = 8;
    private static final String[] description = new String[]{"DIGITAL SIGNATURE", "NON REPUDIATION", "KEY ENCIPHERMENT", "DATA ENCIPHERMENT", "KEY AGREEMENT", "KEY CERT_SIGN", "CRL SIGN", "ENCIPHER ONLY", "DECIPHER ONLY"};
    private static final int[] LIST = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final ASN1ObjectID TYPE = PKIX.id_ce_keyUsage;
    private boolean[] keyUsage = new boolean[LIST.length];

    public KeyUsageExtension() {
        super(TYPE);
    }

    public KeyUsageExtension(boolean critical) {
        super(TYPE, critical);
        this.setValue(this.toByteArray());
    }

    public KeyUsageExtension(int[] flags, boolean critical) {
        super(TYPE, critical);
        this.setUsageFlags(flags);
    }

    public KeyUsageExtension(InputStream is) throws IOException {
        super(is);
    }

    public boolean hasUsageFlag(int flag) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyUsage != null && flag < this.keyUsage.length ? this.keyUsage[flag] : false;
    }

    public void setUsageFlag(int flag) {
        this.doSetUsageFlag(flag);
        this.setValue(this.toByteArray());
    }

    public void setUsageFlags(int[] flags) {
        int len = flags.length;
        for (int i = 0; i < len; ++i) {
            this.doSetUsageFlag(flags[i]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearUsageFlag(int flag) {
        if (this.keyUsage != null && flag < this.keyUsage.length) {
            this.keyUsage[flag] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllUsageFlags() {
        if (this.keyUsage != null) {
            int len = this.keyUsage.length;
            for (int i = 0; i < len; ++i) {
                this.keyUsage[i] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetUsageFlag(int flag) {
        if (this.keyUsage == null || this.keyUsage.length < LIST.length) {
            boolean[] newUsages = new boolean[LIST.length];
            if (this.keyUsage != null) {
                System.arraycopy(this.keyUsage, 0, newUsages, 0, this.keyUsage.length);
            }
            this.keyUsage = newUsages;
        }
        this.keyUsage[flag] = true;
    }

    private byte[] toByteArray() {
        ASN1BitString bs = new ASN1BitString(this.keyUsage.length);
        for (int i = 0; i < this.keyUsage.length; ++i) {
            if (!this.keyUsage[i]) continue;
            bs.setBit(i);
        }
        byte[] b = Utils.toBytes((Streamable)bs);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            int i;
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1BitString b = new ASN1BitString((InputStream)is);
            this.keyUsage = new boolean[b.bitLength()];
            try {
                for (i = 0; i < this.keyUsage.length; ++i) {
                    this.keyUsage[i] = b.testBit(i);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new ASN1FormatException("Unknown key usage flag: " + i);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public boolean[] getKeyUsage() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyUsage;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("keyUsageExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean mid = false;
        for (int i = 0; i < LIST.length; ++i) {
            if (!this.hasUsageFlag(i)) continue;
            if (mid) {
                s.append(", ");
            }
            s.append(description[i]);
            mid = true;
        }
        s.append("]}");
        return s.toString();
    }
}

