/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtKeyUsageExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_extKeyUsage;
    private ArrayList<ASN1ObjectID> keyPurposes = new ArrayList();

    public ExtKeyUsageExtension() {
        super(TYPE);
    }

    public ExtKeyUsageExtension(ASN1ObjectID keyPurpose) {
        this(keyPurpose, false);
    }

    public ExtKeyUsageExtension(ASN1ObjectID keyPurpose, boolean critical) {
        super(TYPE, critical);
        this.keyPurposes.add(keyPurpose);
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(Vector<ASN1ObjectID> keyPurposes, boolean critical) {
        this((List<ASN1ObjectID>)keyPurposes, critical);
    }

    public ExtKeyUsageExtension(List<ASN1ObjectID> keyPurposes, boolean critical) {
        super(TYPE, critical);
        this.keyPurposes = keyPurposes == null ? null : (keyPurposes instanceof ArrayList ? (ArrayList<Object>)keyPurposes : new ArrayList<ASN1ObjectID>(keyPurposes));
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(InputStream is) throws IOException {
        super(is);
    }

    public void addKeyPurpose(ASN1ObjectID keyPurpose) {
        this.keyPurposes.add(keyPurpose);
        this.setValue(this.toByteArray());
    }

    public Enumeration<ASN1ObjectID> getKeyPurposes() {
        ArrayList<ASN1ObjectID> l = this.getKeyPurposesAsList();
        return l == null ? null : new VectorOverArrayList(l).elements();
    }

    public ArrayList<ASN1ObjectID> getKeyPurposesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes;
    }

    public boolean hasKeyPurpose(ASN1ObjectID keyPurpose) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes.contains(keyPurpose);
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        int size = this.keyPurposes.size();
        for (int i = 0; i < size; ++i) {
            seq.addElement((ASN1Object)this.keyPurposes.get(i));
        }
        byte[] b = Utils.toBytes((Streamable)seq);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.keyPurposes = new ArrayList();
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
            while (sis.hasMoreData()) {
                this.keyPurposes.add(new ASN1ObjectID((InputStream)sis));
            }
            sis.terminate();
            if (this.keyPurposes.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("extKeyUsageExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.keyPurposes != null) {
            s.append("OIDs of key usage = {");
            boolean mid = false;
            int size = this.keyPurposes.size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(this.keyPurposes.get(i).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

