/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509ExtensionSet
implements ASN1Object,
Externalizable,
java.security.cert.X509Extension {
    private LinkedHashMap<ASN1ObjectID, X509Extension> extTable = new LinkedHashMap();
    private ASN1Sequence seq = null;

    public X509ExtensionSet() {
    }

    public X509ExtensionSet(Vector<X509Extension> exts) {
        this((List<X509Extension>)exts);
    }

    public X509ExtensionSet(List<X509Extension> exts) {
        for (X509Extension e : exts) {
            this.addExtension(e);
        }
    }

    public X509ExtensionSet(InputStream is) throws IOException {
        this.input(is);
    }

    public X509Extension addExtension(X509Extension ext) {
        this.reset();
        return this.extTable.put(ext.getType(), ext);
    }

    public X509Extension getExtension(ASN1ObjectID type) {
        return this.extTable.get(type);
    }

    public Enumeration<ASN1ObjectID> types() {
        return this.extTable == null ? null : new Vector<ASN1ObjectID>(this.extTable.keySet()).elements();
    }

    public Map<ASN1ObjectID, X509Extension> getExtensionsAsMap() {
        return this.extTable;
    }

    public Vector<X509Extension> getExtensions() {
        return this.extTable == null ? null : new Vector<X509Extension>(this.extTable.values());
    }

    public ArrayList<X509Extension> getExtensionsAsList() {
        return this.extTable == null ? null : new ArrayList<X509Extension>(this.extTable.values());
    }

    public int size() {
        return this.extTable.size();
    }

    public boolean hasExtension(ASN1ObjectID type) {
        return this.extTable.containsKey(type);
    }

    public boolean hasUnrecognizedCriticalExtension() {
        for (X509Extension ext : this.extTable.values()) {
            if (!ext.getCritical() || ext.isRecognized()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('{');
        Iterator<X509Extension> i = this.extTable.values().iterator();
        while (i.hasNext()) {
            s.append(i.next());
            if (!i.hasNext()) continue;
            s.append(", ");
        }
        s.append('}');
        return s.toString();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        LinkedHashSet<String> oids = new LinkedHashSet<String>();
        for (X509Extension ext : this.extTable.values()) {
            if (!ext.getCritical()) continue;
            oids.add(ext.getType().toStringCompact());
        }
        return oids;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        ASN1ObjectID type = new ASN1ObjectID(oid);
        return this.extTable.get(type).getValue();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        LinkedHashSet<String> oids = new LinkedHashSet<String>();
        for (X509Extension ext : this.extTable.values()) {
            if (ext.getCritical()) continue;
            oids.add(ext.getType().toStringCompact());
        }
        return oids;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.hasUnrecognizedCriticalExtension();
    }

    public void input(InputStream is) throws IOException {
        this.extTable.clear();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            this.addExtension(X509Extension.inputInstance((InputStream)sis));
        }
        sis.terminate();
        this.reset();
        if (this.size() == 0) {
            throw new ASN1FormatException("Extension set must contain at least 1 extension");
        }
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence s = new ASN1Sequence();
            for (X509Extension ext : this.extTable.values()) {
                s.addElement((ASN1Object)ext);
            }
            this.seq = s;
        }
        return this.seq;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

