/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCS7
implements ASN1Object,
Externalizable {
    private ArrayList<X509> certificates;
    private ArrayList<CRL> crls;
    private X500Name issuer;
    private BigInteger serialNo;
    private RSAPublicKey pubKey;
    private Signature sig;
    private byte[] aaBytes;
    private byte[] hashBytes;
    private byte[] docHash;
    private byte[] sigBytes;
    private byte[] doc;
    private AlgorithmIdentifier mdAlg;
    private ASN1Sequence contents;
    protected static final int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};

    public PKCS7() {
    }

    public PKCS7(Vector<X509> certificates, Vector<CRL> crls) {
        this((List<X509>)certificates, (List<CRL>)crls);
    }

    public PKCS7(List<X509> certificates, List<CRL> crls) {
        ArrayList<Object> arrayList = certificates == null ? null : (this.certificates = certificates instanceof ArrayList ? (ArrayList<Object>)certificates : new ArrayList<X509>(certificates));
        this.crls = crls == null ? null : (crls instanceof ArrayList ? (ArrayList<Object>)crls : new ArrayList<CRL>(crls));
    }

    public PKCS7(X509 cert) {
        this.certificates = new ArrayList();
        this.certificates.add(cert);
    }

    public PKCS7(CRL crl) {
        this.crls = new ArrayList();
        this.crls.add(crl);
    }

    public PKCS7(X509 signer, oracle.security.crypto.core.RSAPrivateKey k, byte[] doc) throws SignatureException {
        this();
        this.sign(signer, k, doc);
    }

    public PKCS7(X509Certificate signer, RSAPrivateKey k, AlgorithmIdentifier sigAlg, byte[] doc) throws SignatureException {
        this();
        this.sign(signer, k, sigAlg, doc);
    }

    public PKCS7(InputStream is) throws IOException {
        this.input(is);
    }

    public PKCS7(ASN1Sequence s) throws IOException {
        this.input(s);
    }

    @Deprecated
    public Vector<X509> getCertificates() {
        return this.certificates == null ? null : new VectorOverArrayList(this.certificates);
    }

    public ArrayList<X509> getCertificatesAsList() {
        return this.certificates;
    }

    @Deprecated
    public Vector<CRL> getCRLs() {
        return this.crls == null ? null : new VectorOverArrayList(this.crls);
    }

    public ArrayList<CRL> getCRLsAsList() {
        return this.crls;
    }

    public void addCertificate(X509 cert) {
        if (this.certificates == null) {
            this.certificates = new ArrayList();
        }
        this.certificates.add(cert);
    }

    public void addCRL(CRL crl) {
        if (this.crls == null) {
            this.crls = new ArrayList();
        }
        this.crls.add(crl);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public void setPublicKey(RSAPublicKey pk) {
        this.setPublicKey((java.security.interfaces.RSAPublicKey)pk);
    }

    public void setPublicKey(java.security.interfaces.RSAPublicKey pk) {
        this.pubKey = (RSAPublicKey)CryptoUtils.fromJCEPublicKey((PublicKey)pk);
        try {
            this.sig = Signature.getInstance(CryptoUtils.getSignatureAlg((AlgorithmIdentifier)PKCS7.getSigAlgID(this.mdAlg)));
            this.sig.initVerify((PublicKey)this.pubKey);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setSigner(X509 signer) {
    }

    public void setSigner(X509Certificate signer) {
        if (this.issuer == null) {
            this.issuer = X500Name.toX500Name(signer.getIssuerX500Principal());
        } else if (!this.issuer.equals(signer.getIssuerX500Principal())) {
            throw new RuntimeException("The issuer is " + this.issuer + ", which is not " + signer.getIssuerX500Principal());
        }
        if (this.serialNo == null) {
            this.serialNo = signer.getSerialNumber();
        } else if (!this.serialNo.equals(signer.getSerialNumber())) {
            throw new RuntimeException("The serial number is " + this.serialNo + ", which is not " + signer.getSerialNumber());
        }
        this.setPublicKey((java.security.interfaces.RSAPublicKey)signer.getPublicKey());
    }

    public void setDocument(byte[] doc) {
        if (this.pubKey == null) {
            throw new IllegalStateException("The public key is not set");
        }
        this.doc = doc;
    }

    public void sign(X509 signer, oracle.security.crypto.core.RSAPrivateKey privKey, byte[] doc) throws SignatureException {
        this.sign(signer, privKey, AlgID.md5WithRSAEncryption, doc);
    }

    public void sign(X509 signer, oracle.security.crypto.core.RSAPrivateKey privKey, AlgorithmIdentifier sigAlg, byte[] doc) throws SignatureException {
        this.sign(signer.toX509Certificate(), (RSAPrivateKey)privKey, sigAlg, doc);
    }

    public void sign(X509Certificate signer, RSAPrivateKey privKey, AlgorithmIdentifier sigAlg, byte[] doc) throws SignatureException {
        this.issuer = X500Name.toX500Name(signer.getIssuerX500Principal());
        this.serialNo = signer.getSerialNumber();
        if (!signer.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.pubKey = (RSAPublicKey)signer.getPublicKey();
        this.mdAlg = PKCS7.getDigestAlgID(sigAlg);
        try {
            this.sig = Signature.getInstance(CryptoUtils.getSignatureAlg((AlgorithmIdentifier)sigAlg));
            this.sig.initSign(privKey);
            this.sig.update(doc);
            this.sigBytes = this.sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException((Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException((Throwable)ex);
        }
        catch (java.security.SignatureException ex) {
            throw new SignatureException((Throwable)ex);
        }
    }

    public boolean verify() throws AuthenticationException {
        if (this.aaBytes == null) {
            try {
                this.sig.update(this.doc);
                return this.sig.verify(this.sigBytes);
            }
            catch (java.security.SignatureException ex) {
                throw new AuthenticationException((Throwable)ex);
            }
        }
        try {
            this.sig.update(this.doc);
            MessageDigest hash = MessageDigest.getInstance(CryptoUtils.getDigestAlg((AlgorithmIdentifier)this.mdAlg));
            hash.update(this.doc);
            this.docHash = hash.digest();
            return this.sig.verify(this.sigBytes) && Utils.areEqual((byte[])this.docHash, (byte[])this.hashBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
        catch (java.security.SignatureException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)new ASN1ObjectID(pkcs7, 2));
        ASN1Sequence sd = new ASN1Sequence();
        sd.addElement((ASN1Object)new ASN1Integer(1L));
        sd.addElement((ASN1Object)new ASN1Set());
        ASN1Sequence ci = new ASN1Sequence();
        ci.addElement((ASN1Object)new ASN1ObjectID(pkcs7, 1));
        sd.addElement((ASN1Object)ci);
        if (this.certificates != null) {
            sd.addElement((ASN1Object)new ASN1GenericConstructed(this.certificates, 0));
        }
        if (this.crls != null) {
            sd.addElement((ASN1Object)new ASN1GenericConstructed(this.crls, 1));
        }
        if (this.sig == null) {
            sd.addElement((ASN1Object)new ASN1Set());
        } else {
            ASN1Sequence si = new ASN1Sequence();
            si.addElement((ASN1Object)new ASN1Integer(1L));
            ASN1Sequence iasn = new ASN1Sequence();
            iasn.addElement((ASN1Object)this.issuer);
            iasn.addElement((ASN1Object)new ASN1Integer(this.serialNo));
            si.addElement((ASN1Object)iasn);
            si.addElement((ASN1Object)this.mdAlg);
            si.addElement((ASN1Object)AlgID.rsaEncryption);
            si.addElement((ASN1Object)new ASN1OctetString(this.sigBytes));
            sd.addElement((ASN1Object)new ASN1Set((ASN1Object)si));
        }
        s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)sd, 0));
        this.contents = s;
        return s;
    }

    private static AlgorithmIdentifier getDigestAlgID(AlgorithmIdentifier sigAlgID) {
        if (sigAlgID.getOID().equals((Object)AlgID.md2WithRSAEncryption.getOID())) {
            return AlgID.md2;
        }
        if (sigAlgID.getOID().equals((Object)AlgID.md5WithRSAEncryption.getOID())) {
            return AlgID.md5;
        }
        if (sigAlgID.getOID().equals((Object)AlgID.sha_1WithRSAEncryption.getOID())) {
            return AlgID.sha_1;
        }
        throw new IllegalStateException("Unsupported signature algorithm identifier");
    }

    private static AlgorithmIdentifier getSigAlgID(AlgorithmIdentifier mdAlgID) {
        if (mdAlgID.getOID().equals((Object)AlgID.md2.getOID())) {
            return AlgID.md2WithRSAEncryption;
        }
        if (mdAlgID.getOID().equals((Object)AlgID.md5.getOID())) {
            return AlgID.md5WithRSAEncryption;
        }
        if (mdAlgID.getOID().equals((Object)AlgID.sha_1.getOID()) || mdAlgID.getOID().equals((Object)AlgID.sha.getOID())) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("Unsupported message digest algorithm identifier");
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s) throws IOException {
        try {
            this.contents = s;
            ASN1ObjectID ct = (ASN1ObjectID)s.elementAt(0);
            if (!ct.equals(pkcs7, 2)) {
                throw new IOException("contentType has to be signedData");
            }
            if (s.elementsAsList().size() < 2) {
                throw new IOException("No content");
            }
            ASN1Sequence sd = (ASN1Sequence)((ASN1GenericConstructed)s.elementAt(1)).elementAt(0);
            this.certificates = null;
            this.crls = null;
            int i = 3;
            while (!(sd.elementAt(i) instanceof ASN1Set)) {
                ASN1GenericConstructed set = (ASN1GenericConstructed)sd.elementAt(i);
                switch (set.getTag()) {
                    case 0: {
                        int c;
                        this.certificates = new ArrayList();
                        int size = set.size();
                        for (c = 0; c < size; ++c) {
                            this.certificates.add(new X509(Utils.toStream((Streamable)set.elementAt(c))));
                        }
                        break;
                    }
                    case 1: {
                        int c;
                        this.crls = new ArrayList();
                        int size = set.size();
                        for (c = 0; c < size; ++c) {
                            this.crls.add(new CRL(Utils.toStream((Streamable)set.elementAt(c))));
                        }
                        break;
                    }
                }
                ++i;
            }
            ASN1Set sis = (ASN1Set)sd.elementAt(i);
            if (sis.elementsAsList().size() > 0) {
                ASN1ObjectID deaID;
                i = 0;
                ASN1Sequence si = (ASN1Sequence)sis.elementAt(0);
                int n = ++i;
                ASN1Sequence iasn = (ASN1Sequence)si.elementAt(n);
                this.issuer = new X500Name((ASN1Sequence)iasn.elementAt(0));
                this.serialNo = ((ASN1Integer)iasn.elementAt(1)).getValue();
                int n2 = ++i;
                this.mdAlg = new AlgorithmIdentifier(Utils.toStream((Streamable)((ASN1Sequence)si.elementAt(n2))));
                if (si.elementAt(++i) instanceof ASN1GenericConstructed) {
                    ASN1Set aa = new ASN1Set((List)((ASN1GenericConstructed)si.elementAt(i++)).elementsAsList());
                    this.aaBytes = Utils.toBytes((Streamable)aa);
                    this.hashBytes = null;
                    ArrayList v = aa.elementsAsList();
                    int size = v.size();
                    for (int j = 0; j < size; ++j) {
                        ASN1Sequence a = (ASN1Sequence)v.get(j);
                        ASN1ObjectID at = (ASN1ObjectID)a.elementAt(0);
                        if (!at.equals(ASN1Utils.pkcsID, 9, 4)) continue;
                        this.hashBytes = ((ASN1OctetString)((ASN1Set)a.elementAt(1)).elementAt(0)).getValue();
                    }
                    if (this.hashBytes == null) {
                        throw new IOException("No message digest found in authenticatedAttributes");
                    }
                }
                if (!(deaID = (ASN1ObjectID)((ASN1Sequence)si.elementAt(i++)).elementAt(0)).equals((Object)AlgID.rsaEncryption.getOID())) {
                    throw new IOException("Unsupported encryption algorithm " + deaID);
                }
                this.sigBytes = ((ASN1OctetString)si.elementAt(i++)).getValue();
            }
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    public int length() {
        return this.outputASN1().length();
    }

    public byte[] getEncoded() {
        return Utils.toBytes((Streamable)this.outputASN1());
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

