/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X500RDN;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLDistPointName
implements ASN1Object,
Externalizable {
    private ArrayList<GeneralName> fullName;
    private X500RDN relativeName;
    private transient ASN1Object contents;

    public CRLDistPointName() {
    }

    public CRLDistPointName(GeneralName name) {
        this.fullName = new ArrayList();
        this.fullName.add(name);
    }

    public CRLDistPointName(Vector<? extends GeneralName> fullName) {
        this.fullName = fullName == null ? null : new ArrayList<GeneralName>(fullName);
    }

    public CRLDistPointName(List<? extends GeneralName> fullName) {
        this.fullName = fullName == null ? null : new ArrayList<GeneralName>(fullName);
    }

    public CRLDistPointName(X500RDN relativeName) {
        this.relativeName = relativeName;
    }

    public CRLDistPointName(InputStream is) throws IOException {
        this.input(is);
    }

    public void addGeneralName(GeneralName name) {
        if (this.fullName == null) {
            this.fullName = new ArrayList();
        }
        this.fullName.add(name);
    }

    public Vector<GeneralName> getFullName() {
        return this.fullName == null ? null : new VectorOverArrayList(this.fullName);
    }

    public ArrayList<GeneralName> getFullNameAsList() {
        return this.fullName;
    }

    public X500RDN getRelativeName() {
        return this.relativeName;
    }

    public void input(InputStream is) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(is);
        int ch = pis.read();
        int tag = ASN1Utils.getTag((int)ch);
        if (tag == 0) {
            pis.unread((ch & 0x20) + 16);
            if (this.fullName == null) {
                this.fullName = new ArrayList();
            } else {
                this.fullName.clear();
            }
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)pis);
            while (sis.hasMoreData()) {
                this.fullName.add(new GeneralName((InputStream)sis));
            }
            sis.terminate();
            this.relativeName = null;
        } else if (tag == 1) {
            pis.unread((ch & 0x20) + 17);
            this.fullName = null;
            this.relativeName = new X500RDN(pis);
        }
        if ((this.fullName == null || this.fullName.size() == 0) && this.relativeName == null) {
            throw new ASN1FormatException("No name elements found in CRLDistPointName");
        }
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            this.contents = this.fullName != null ? new ASN1GenericConstructed(this.fullName, 0) : ASN1Utils.addImplicitTag((ASN1Object)this.relativeName, (int)1);
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

