/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.lazytree;

import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import oracle.bm.util.LoggerUtils;

public abstract class LazyNode
implements TreeNode {
    protected boolean m_populated = false;

    public void setPopulated(boolean b) {
        this.m_populated = b;
    }

    public boolean isPopulated() {
        return this.m_populated;
    }

    private void populateIfNecessary() {
        if (!this.isPopulated()) {
            this.setPopulated(this.populate());
        }
        if (!this.isPopulated()) {
            LoggerUtils.getLoggerForClass(LazyNode.class).log(Level.SEVERE, "Node wasn't populated");
        }
    }

    @Override
    public TreeNode getChildAt(int i) {
        this.populateIfNecessary();
        return null;
    }

    @Override
    public int getChildCount() {
        this.populateIfNecessary();
        return 0;
    }

    @Override
    public final boolean isLeaf() {
        if (!this.isPopulated()) {
            return false;
        }
        return this.getChildCount() == 0;
    }

    public abstract boolean populate();
}

