/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.progress;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bm.util.progress.ProgressMonitor;
import oracle.ide.log.LogManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;

public class IDEProgressMonitor
extends ProgressMonitor {
    private Component m_parent;
    private IndeterminateProgressMonitor m_monitor;
    private int m_noteCount;

    public IDEProgressMonitor(Component parent, String title) {
        this.m_parent = parent;
        this.m_monitor = new IndeterminateProgressMonitor(parent, title);
        this.m_monitor.setCloseOnFinish(true);
        this.setPhase("");
    }

    @Override
    public void start() {
        Thread.currentThread().setPriority(1);
        this.m_monitor.start();
    }

    @Override
    public void setPhase(final String message) {
        try {
            new SwingClosure(true){

                public void runImpl() {
                    IDEProgressMonitor.this.m_monitor.getPanel().setMessage(message == null ? "" : message);
                    IDEProgressMonitor.this.m_monitor.getPanel().setNote("");
                }
            }.run();
        }
        catch (ClosureException e) {
            Logger.getLogger("oracle.bm.jdukshare").log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void setNote(ProgressMonitor.Descriptor descriptor) {
        if ((this.m_noteCount++ & 0xFF) == 0) {
            final String note = descriptor.getNote();
            try {
                new SwingClosure(true){

                    public void runImpl() {
                        IDEProgressMonitor.this.m_monitor.getPanel().setNote(note == null ? "" : note);
                    }
                }.run();
            }
            catch (ClosureException e) {
                Logger.getLogger("oracle.bm.jdukshare").log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.m_monitor.isCancelled();
    }

    @Override
    public void finish(final String message) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    IDEProgressMonitor.this.m_monitor.finish();
                    if (message != null) {
                        LogManager.getLogManager().getMsgPage().log((Object)message);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Component getComponent() {
        if (EventQueue.isDispatchThread()) {
            return this.m_monitor.getComponent();
        }
        throw new IllegalStateException("Can only call from AWT thread");
    }

    @Override
    public void reportException(final Exception e) {
        try {
            new SwingClosure(false){

                public void runImpl() {
                    Component parent = IDEProgressMonitor.this.m_monitor.getComponent();
                    if (!IDEProgressMonitor.this.m_monitor.getComponent().isVisible()) {
                        parent = IDEProgressMonitor.this.m_parent;
                    }
                    ExceptionDialog.showExceptionDialog((Component)parent, (Throwable)e);
                }
            }.run();
        }
        catch (ClosureException ce) {
            Logger.getLogger("oracle.bm.jdukshare").log(Level.SEVERE, ce.getMessage(), ce);
        }
    }
}

