/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.javatools.datatransfer;

import java.util.HashMap;
import java.util.HashSet;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorSelectionManager;
import oracle.bm.javatools.datatransfer.SelectorNode;
import oracle.bm.javatools.util.MultivaluedMap;

public class FlavorHandlerManager<T> {
    private SelectorNode<T> m_rootNode;

    public FlavorHandlerManager(FlavorSelectionManager fsm) {
        if (fsm == null) {
            throw new IllegalArgumentException("Missing fsm");
        }
        this.m_rootNode = fsm.createRootNode();
    }

    public void addHandler(Flavor flavor, T handler) {
        if (flavor == null) {
            throw new IllegalArgumentException("Missing flavor");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Missing handler");
        }
        this.m_rootNode.addHandler(flavor, handler);
    }

    public MultivaluedMap<T, Flavor> getHandlers(Flavor[] flavors) {
        MultivaluedMap handlers = new MultivaluedMap(HashMap.class, HashSet.class);
        if (flavors != null) {
            for (Flavor flavor : flavors) {
                this.m_rootNode.getHandlers(flavor, handlers);
            }
        }
        return handlers;
    }
}

