/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.javatools.datatransfer;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorSelector;
import oracle.bm.javatools.datatransfer.PartitionNode;
import oracle.bm.javatools.datatransfer.SelectorNode;
import oracle.bm.javatools.util.MultivaluedMap;

public abstract class AbstractPartitionSelector
implements FlavorSelector {
    private HashMap<Object, FlavorSelector> m_subSelectors = new HashMap();

    @Override
    public void addSelector(Flavor flavor, FlavorSelector selector) {
        Object discriminator = this.getDiscriminator(flavor);
        FlavorSelector parentSelector = this.findChildSelector(discriminator);
        if (parentSelector == null) {
            this.m_subSelectors.put(discriminator, selector);
        } else if (discriminator == null) {
            Logger logger = Logger.getLogger("oracle.bm.javatools.datatransfer");
            logger.log(Level.SEVERE, "Illegal duplicate selector");
        } else {
            parentSelector.addSelector(flavor, selector);
        }
    }

    public <T> void addHandler(SelectorNode<T> node, Flavor flavor, T handler) {
        PartitionNode partitionNode = (PartitionNode)node;
        Object discriminator = this.getDiscriminator(flavor);
        if (discriminator == null) {
            partitionNode.addLocalHandler(handler);
        } else {
            partitionNode.addChildHandler(discriminator, flavor, handler);
        }
    }

    protected abstract Object getDiscriminator(Flavor var1);

    public <T> void getHandlers(SelectorNode<T> node, Flavor flavor, MultivaluedMap<T, Flavor> handlers) {
        PartitionNode partitionNode = (PartitionNode)node;
        partitionNode.addLocalHandlers(flavor, handlers);
        Object discriminator = this.getDiscriminator(flavor);
        if (discriminator != null) {
            partitionNode.addChildHandlers(discriminator, flavor, handlers);
        }
    }

    public FlavorSelector findChildSelector(Object discriminator) {
        FlavorSelector selector = this.m_subSelectors.get(discriminator);
        if (selector == null && (selector = this.createChildSelector(discriminator)) != null) {
            this.m_subSelectors.put(discriminator, selector);
        }
        return selector;
    }

    protected FlavorSelector createChildSelector(Object discriminator) {
        return null;
    }

    @Override
    public <T> SelectorNode<T> createSelectorNode() {
        return new PartitionNode(this);
    }
}

