/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.ide.browse;

import java.util.List;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.bm.browse.BrowseModelProvider;
import oracle.bm.ide.browse.LazyBrowseModelProvider;
import oracle.bm.ide.datatransfer.FlavorAdapter;
import oracle.bm.ide.datatransfer.SelectorHook;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorHandlerManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

class BrowseHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension/oracle.bm.jdukshare", "browse-hook");
    private static final BrowseHook INSTANCE = new BrowseHook();
    private FlavorHandlerManager<BrowseModelProvider> m_handlerManager = new FlavorHandlerManager(SelectorHook.getHook().getFlavorSelectionManager());

    private BrowseHook() {
        HashStructureHook hsh = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT);
        hsh.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                this.addHandlers(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                this.addHandlers(e.getCombinedHashStructure());
            }

            private void addHandlers(HashStructure hs) {
                if (hs == null) {
                    return;
                }
                List providers = hs.getAsList("modelProvider");
                if (providers == null) {
                    return;
                }
                for (Object provider : providers) {
                    if (!(provider instanceof HashStructure)) continue;
                    HashStructure providerHS = (HashStructure)provider;
                    LazyClassAdapter lca = LazyClassAdapter.getInstance((HashStructure)providerHS);
                    MetaClass mc = lca.getMetaClass("class/#text");
                    String label = providerHS.getString("label/#text");
                    List flavors = providerHS.getAsList("flavor");
                    for (Flavor flavor : FlavorAdapter.getFlavors(flavors)) {
                        BrowseHook.this.m_handlerManager.addHandler(flavor, new LazyBrowseModelProvider(mc, label));
                    }
                }
            }
        });
    }

    public FlavorHandlerManager<BrowseModelProvider> getHandlerManager() {
        return this.m_handlerManager;
    }

    public static BrowseHook getHook() {
        return INSTANCE;
    }
}

