/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse.util;

import java.util.ArrayList;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.util.Maps;

public abstract class ProxyTreeModel
implements TreeModel {
    protected static final int NODES_CHANGED = 0;
    protected static final int NODES_INSERTED = 1;
    protected static final int NODES_REMOVED = 2;
    protected static final int STRUCTURE_CHANGED = 3;
    private ProxyNode m_root;
    protected final Map<Object, TreeModel> m_modelMappings = new Maps.WeakHashMap<Object, TreeModel>(){

        protected int keyHashCode(Object key) {
            return System.identityHashCode(key);
        }

        protected boolean keyEquals(Object key1, Object key2) {
            return key1 == key2;
        }
    };
    private final ArrayList<TreeModelListener> m_listeners = new ArrayList();

    @Override
    public ProxyNode getRoot() {
        if (this.m_root == null) {
            this.m_root = this.createRoot();
        }
        return this.m_root;
    }

    protected abstract ProxyNode createRoot();

    @Override
    public Object getChild(Object parent, int index) {
        TreeModel model = this.m_modelMappings.get(parent);
        if (model == null) {
            return ((ProxyNode)parent).getChild(index);
        }
        Object child = model.getChild(parent, index);
        this.m_modelMappings.put(child, model);
        return child;
    }

    @Override
    public int getChildCount(Object parent) {
        TreeModel model = this.m_modelMappings.get(parent);
        if (model == null) {
            return ((ProxyNode)parent).getChildCount();
        }
        return model.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        TreeModel model = this.m_modelMappings.get(node);
        if (model == null) {
            return ((ProxyNode)node).isLeaf();
        }
        return model.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object last = path.getLastPathComponent();
        TreeModel model = this.m_modelMappings.get(last);
        if (model != null) {
            model.valueForPathChanged(this.findProxiedPath(path, model), newValue);
        }
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child == null || parent == null) {
            return -1;
        }
        TreeModel model = this.m_modelMappings.get(parent);
        if (model == null) {
            return ((ProxyNode)parent).getIndexOfChild(child);
        }
        return model.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_listeners.remove(l);
    }

    protected void fireTreeModelEvent(int type, TreePath path, int[] childIndices, Object[] children) {
        if (this.m_listeners.size() > 0) {
            TreeModelListener[] listeners = this.m_listeners.toArray(new TreeModelListener[this.m_listeners.size()]);
            TreeModelEvent e = new TreeModelEvent((Object)this, path, childIndices, children);
            block6: for (int i = listeners.length - 1; i >= 0; --i) {
                TreeModelListener l = listeners[i];
                switch (type) {
                    case 0: {
                        l.treeNodesChanged(e);
                        continue block6;
                    }
                    case 1: {
                        l.treeNodesInserted(e);
                        continue block6;
                    }
                    case 2: {
                        l.treeNodesRemoved(e);
                        continue block6;
                    }
                    case 3: {
                        l.treeStructureChanged(e);
                    }
                }
            }
        }
    }

    private TreePath findProxiedPath(TreePath proxyPath, TreeModel proxiedModel) {
        if (proxyPath == null) {
            return new TreePath(proxiedModel.getRoot());
        }
        Object node = proxyPath.getLastPathComponent();
        TreeModel nodeModel = this.m_modelMappings.get(node);
        if (proxiedModel != nodeModel || node == proxiedModel.getRoot()) {
            return new TreePath(proxiedModel.getRoot());
        }
        return this.findProxiedPath(proxyPath.getParentPath(), proxiedModel).pathByAddingChild(node);
    }

    protected TreePath findProxyPath(TreePath parents, TreePath proxiedPath, TreeModel proxiedModel) {
        TreePath parentPath = proxiedPath.getParentPath();
        if (parentPath == null) {
            return parents;
        }
        Object node = proxiedPath.getLastPathComponent();
        this.m_modelMappings.put(node, proxiedModel);
        return this.findProxyPath(parents, parentPath, proxiedModel).pathByAddingChild(node);
    }

    protected class ProxyListener
    implements TreeModelListener {
        private TreePath m_parents;

        public ProxyListener(Object ... parents) {
            this.m_parents = new TreePath(parents);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreePath path = this.findProxyPath(e);
            this.mapChildren(e);
            ProxyTreeModel.this.fireTreeModelEvent(0, path, e.getChildIndices(), e.getChildren());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = this.findProxyPath(e);
            this.mapChildren(e);
            ProxyTreeModel.this.fireTreeModelEvent(1, path, e.getChildIndices(), e.getChildren());
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreePath path = this.findProxyPath(e);
            Object[] children = e.getChildren();
            if (children != null) {
                for (Object child : children) {
                    ProxyTreeModel.this.m_modelMappings.remove(child);
                }
            }
            ProxyTreeModel.this.fireTreeModelEvent(2, path, e.getChildIndices(), e.getChildren());
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            Object newRoot;
            Object oldRoot;
            TreePath modelPath = e.getTreePath();
            if (modelPath.getPathCount() == 1 && (oldRoot = this.m_parents.getLastPathComponent()) != (newRoot = modelPath.getLastPathComponent())) {
                TreePath parentPath = this.m_parents.getParentPath();
                this.m_parents = parentPath.pathByAddingChild(newRoot);
                this.updateRoot(oldRoot, newRoot);
                if (parentPath.getPathCount() > 0) {
                    Object parent = parentPath.getLastPathComponent();
                    int[] indices = new int[]{ProxyTreeModel.this.getIndexOfChild(parent, newRoot)};
                    ProxyTreeModel.this.fireTreeModelEvent(2, parentPath, indices, new Object[]{oldRoot});
                    ProxyTreeModel.this.fireTreeModelEvent(1, parentPath, indices, new Object[]{newRoot});
                    return;
                }
            }
            TreePath path = this.transformPath((TreeModel)e.getSource(), modelPath);
            this.mapChildren(e);
            ProxyTreeModel.this.fireTreeModelEvent(3, path, e.getChildIndices(), e.getChildren());
        }

        private TreePath findProxyPath(TreeModelEvent e) {
            return this.transformPath((TreeModel)e.getSource(), e.getTreePath());
        }

        private TreePath transformPath(TreeModel proxiedModel, TreePath proxiedPath) {
            return ProxyTreeModel.this.findProxyPath(this.m_parents, proxiedPath, proxiedModel);
        }

        private void mapChildren(TreeModelEvent e) {
            Object[] children = e.getChildren();
            if (children != null) {
                TreeModel model = (TreeModel)e.getSource();
                for (Object child : children) {
                    ProxyTreeModel.this.m_modelMappings.put(child, model);
                }
            }
        }

        protected void updateRoot(Object oldRoot, Object newRoot) {
        }
    }

    protected static interface ProxyNode {
        public Object getChild(int var1);

        public int getChildCount();

        public boolean isLeaf();

        public int getIndexOfChild(Object var1);
    }
}

