/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.raptor.usages.ServerLocation;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ServerLocationsParser
extends ExtensibleSAXParser {
    static final String NAMESPACE_URI = "http://xmlns.oracle.com/jdeveloper/usage/servers";
    static final Key USAGE_SERVERS_KEY = new Key("usage-servers");
    static final Key USAGE_SERVER_ENTRY_KEY = new Key("server-entry");

    ServerLocationsParser() {
    }

    public List parse(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        InputStreamLocator inputStreamLocator = new InputStreamLocator(inputStream);
        this.getContext().putValue(USAGE_SERVERS_KEY, new ArrayList());
        this.getContext().registerChildHandler(NAMESPACE_URI, "usage_servers", (ElementHandler)new ServersHandler());
        this.parse(inputStreamLocator);
        return Collections.unmodifiableList((List)this.getContext().getValue(USAGE_SERVERS_KEY));
    }

    private class InputStreamLocator
    extends XMLLocator {
        private final InputStream _stream;

        public InputStreamLocator(InputStream inputStream) {
            super(null);
            this._stream = inputStream;
        }

        public InputSource createInputSource() throws IOException {
            return new InputSource(this._stream);
        }
    }

    private static class UrlHandler
    extends ElementHandler {
        private UrlHandler() {
        }

        public void handleEnd(ElementEndContext elementEndContext) {
            ServerLocation serverLocation = (ServerLocation)elementEndContext.getValue(USAGE_SERVER_ENTRY_KEY);
            serverLocation.setURL(this.getText(elementEndContext));
        }

        String getText(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            if (string == null) {
                return null;
            }
            return string.trim();
        }
    }

    private static class ServerHandler
    extends ElementHandler {
        private ServerHandler() {
        }

        public void handleStart(ElementStartContext elementStartContext) {
            ServerLocation serverLocation = new ServerLocation();
            elementStartContext.putValue(USAGE_SERVER_ENTRY_KEY, (Object)serverLocation);
            Collection collection = (Collection)elementStartContext.getValue(USAGE_SERVERS_KEY);
            collection.add(serverLocation);
            elementStartContext.registerChildHandler(ServerLocationsParser.NAMESPACE_URI, "url", (ElementHandler)new UrlHandler());
        }
    }

    private static class ServersHandler
    extends ElementHandler {
        private ServersHandler() {
        }

        public void handleStart(ElementStartContext elementStartContext) {
            elementStartContext.registerChildHandler(ServerLocationsParser.NAMESPACE_URI, "server", (ElementHandler)new ServerHandler());
        }
    }
}

