/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.logging.ILoggingPage;
import oracle.dbtools.logging.LoggingController;
import oracle.dbtools.logging.TableCellWithTooltip;
import oracle.dbtools.logging.TableCellWithTooltipAndLevelIcon;
import oracle.dbtools.raptor.ExtrasMessages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class LoggingPage
extends AbstractLogPage
implements ILoggingPage {
    protected static final Logger LOGGER = Logger.getLogger(LoggingPage.class.getName());
    private static final Formatter FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord logRecord) {
            Throwable throwable;
            String string = this.formatMessage(logRecord);
            if ((null == string || string.isEmpty() || "null".equals(string)) && (throwable = logRecord.getThrown()) != null) {
                string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
            }
            return string;
        }
    };
    private JTable _table;
    private DefaultTableModel _model;
    private JScrollPane _panel;
    private long _lastMills = 0L;
    private DefaultTableCellRenderer _renderer;
    private Toolbar _toolbar;
    private SearchField _search;
    private static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private PrintStream _logFile;
    private int _maxLogLines;
    private ChangeListener _optionsChangeListener;
    private char _valueSepChar = (char)9;
    private String _eol;
    private ShutdownHook myShutdownHook = new ShutdownHook(){

        public boolean canShutdown() {
            return true;
        }

        public void shutdown() {
            if (LoggingPage.this._logFile != null) {
                LoggingPage.this._logFile.close();
                LoggingPage.this._logFile = null;
            }
        }
    };

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public LoggingPage() {
        super(new ViewId("LoggingMessagePane", ExtrasMessages.getString((String)"LoggingPage.1")), null, true);
    }

    public Component getGUI() {
        if (this._table == null) {
            this.initTable();
            this.initOptions();
            this._panel = new JScrollPane(this._table);
            this._panel.setColumnHeaderView(this._table.getTableHeader());
            this._panel.setHorizontalScrollBarPolicy(32);
            this._panel.setVerticalScrollBarPolicy(20);
        }
        return this._panel;
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        return contextMenu;
    }

    public Component getTopComponent() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._search = new SearchField();
            this._search.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent searchEvent) {
                    TableRowSorter<DefaultTableModel> tableRowSorter = new TableRowSorter<DefaultTableModel>(LoggingPage.this.getModel());
                    tableRowSorter.setRowFilter(new RowFilter(){

                        public boolean include(RowFilter.Entry entry) {
                            for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                                if (!entry.getStringValue(i).contains(LoggingPage.this._search.getText())) continue;
                                return true;
                            }
                            return false;
                        }
                    });
                    LoggingPage.this._table.setRowSorter(tableRowSorter);
                }

                public void searchCategoryChanged(SearchEvent searchEvent) {
                }
            });
            this._toolbar.add((Component)this._search);
        }
        return this._toolbar;
    }

    private void initTable() {
        this._table = new JTable(this.getModel());
        this.getContextMenu().addContextMenuListener((ContextMenuListener)new LoggingController(this._table));
        this._renderer = new TableCellWithTooltip();
        this._table.setCellSelectionEnabled(false);
        this._table.setRowSelectionAllowed(true);
        this._table.setAutoResizeMode(0);
        this._table.getColumnModel().getColumn(0).setCellRenderer(new TableCellWithTooltipAndLevelIcon());
        this._table.getColumnModel().getColumn(1).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(2).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(3).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(4).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(64);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(56);
        this._table.getColumnModel().getColumn(3).setPreferredWidth(128);
        this._table.getColumnModel().getColumn(4).setPreferredWidth(504);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    LoggingPage.this.popupCurrentCell(mouseEvent.getPoint());
                } else if (mouseEvent.getButton() == 3) {
                    Context context = LoggingPage.this.getContext(mouseEvent);
                    context.setProperty("RSETTABLE", (Object)LoggingPage.this._table);
                    LoggingPage.this.getContextMenu().show(context);
                }
            }
        };
        this._table.addMouseListener(mouseAdapter);
    }

    private void initOptions() {
        EnvironOptions environOptions = Ide.getEnvironOptions();
        this._eol = environOptions.getLineBreakSequence();
        this.initLogFile(environOptions);
        this.initMaxLogLines(environOptions);
        this._optionsChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EnvironOptions environOptions = (EnvironOptions)changeEvent.getSource();
                LoggingPage.this.initLogFile(environOptions);
                LoggingPage.this.initMaxLogLines(environOptions);
                LoggingPage.this.checkMaxLogLines();
            }
        };
        environOptions.addChangeListener(this._optionsChangeListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExitCommand.addShutdownHook((ShutdownHook)LoggingPage.this.myShutdownHook);
            }
        });
    }

    private void initLogFile(EnvironOptions environOptions) {
        if (environOptions.isSaveLogToFile() && null == this._logFile) {
            URL uRL = environOptions.getLogFilePrefix();
            String string = uRL == null || uRL.getPath().length() == 0 ? Ide.getWorkDirectory() : URLFileSystem.getPlatformPathName((URL)uRL).trim();
            String string2 = "SQLDeveloper_" + logDateFormat.format(new Date()) + ".log";
            File file = new File(string, string2);
            String string3 = file.getPath();
            try {
                if (this._logFile != null) {
                    this._logFile.close();
                }
                String string4 = environOptions.getEncoding();
                OutputStream outputStream = URLFileSystem.openOutputStream((URL)URLFactory.newFileURL((String)string3));
                this._logFile = string4 == null ? new PrintStream(outputStream) : new PrintStream(outputStream, false, string4);
            }
            catch (IOException iOException) {
                LoggingPage.log(iOException);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)EnvironOptionsArb.format((int)31, (Object)string3), (String)EnvironOptionsArb.getString((int)30), null);
            }
        }
        if (!environOptions.isSaveLogToFile() && this._logFile != null) {
            this._logFile.close();
            this._logFile = null;
        }
    }

    private void initMaxLogLines(EnvironOptions environOptions) {
        this._maxLogLines = environOptions.getMaxLogLines();
    }

    private void diskLog(Object[] objectArray) {
        if (null == this._logFile) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(objectArray[0]).append(this._valueSepChar).append(objectArray[1]).append(this._valueSepChar).append(objectArray[2]).append(this._valueSepChar).append(objectArray[3]).append(this._valueSepChar).append(objectArray[4]).append(this._eol);
        this._logFile.print(stringBuilder.toString());
        this._logFile.flush();
    }

    private void checkMaxLogLines() {
        DefaultTableModel defaultTableModel = this.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= this._maxLogLines; --i) {
            defaultTableModel.removeRow(i);
        }
    }

    public void close() {
        ExitCommand.removeShutdownHook((ShutdownHook)this.myShutdownHook);
        EnvironOptions environOptions = Ide.getEnvironOptions();
        environOptions.removeChangeListener(this._optionsChangeListener);
        if (this._logFile != null) {
            this._logFile.close();
            this._logFile = null;
        }
        super.close();
    }

    public void clearAll() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this._table.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
    }

    private DefaultTableModel getModel() {
        if (this._model == null) {
            this._model = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this._model.addColumn(ExtrasMessages.getString((String)"LoggingPage.3"));
            this._model.addColumn(ExtrasMessages.getString((String)"LoggingPage.4"));
            this._model.addColumn(ExtrasMessages.getString((String)"LoggingPage.5"));
            this._model.addColumn(ExtrasMessages.getString((String)"LoggingPage.6"));
            this._model.addColumn(ExtrasMessages.getString((String)"LoggingPage.7"));
        }
        return this._model;
    }

    private void popupCurrentCell(Point point) {
        int n = this._table.rowAtPoint(point);
        int n2 = this._table.columnAtPoint(point);
        Object object = this._table.getValueAt(n, n2);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(object == null ? "" : object.toString());
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._table, (Component)jPanel, null, (String)ExtrasMessages.getString((String)"LoggingPage.11"), (int)2);
        jEWTDialog.setMinimumSize(new Dimension(300, 120));
        WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    protected void logMsg(Object object) {
        if (object instanceof LogRecord && Ide.isRunning()) {
            LogRecord logRecord = (LogRecord)object;
            Object[] objectArray = new Object[5];
            objectArray[0] = logRecord.getLevel() + "";
            objectArray[1] = logRecord.getSequenceNumber();
            objectArray[2] = this._lastMills == 0L ? 0L : logRecord.getMillis() - this._lastMills;
            String string = logRecord.getSourceClassName();
            if (null == string || string.isEmpty()) {
                string = logRecord.getLoggerName();
            }
            objectArray[3] = string;
            objectArray[4] = FORMATTER.format(logRecord);
            this.getModel().insertRow(0, objectArray);
            this.diskLog(objectArray);
            this.checkMaxLogLines();
            this._lastMills = logRecord.getMillis();
        }
    }

    public void log(LogRecord logRecord) {
        this.log(logRecord, false);
    }
}

