/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.mysql5.MySQL5Converter;
import oracle.dbtools.migration.workbench.mysql5.MySQL5DbProvider;
import oracle.dbtools.migration.workbench.mysql5.MySQL5OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.MySQL4Plugin;

public class MySQL5Plugin
extends MySQL4Plugin {
    @Override
    public String getVersionNumber() {
        return "5.0";
    }

    @Override
    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new MySQL5DbProvider(connection);
    }

    @Override
    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (!string.equals(this.getPlatformName())) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
        }
        if (n == 5 && n2 >= 0) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES;
    }

    @Override
    public int getPlatformMask() {
        return 4;
    }

    @Override
    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new MySQL5Converter();
        }
        return this.m_converter;
    }

    @Override
    public OfflineCapturer getOfflineCapturer() {
        return new MySQL5OfflineCapturer();
    }
}

