/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.mysql3;

import oracle.dbtools.migration.workbench.mysql3.BlackMessages;

public class MySQLColumnHelper {
    private String _originalDefinition;
    private String _normalisedType;
    private INTERNAL_TYPE_CODES _internalTypeCode;
    private boolean _bHasPrecisionOnly;
    private boolean _bHasPrecisionAndScale;
    private int _precision;
    private int _scale;

    public MySQLColumnHelper(String string) {
        this._originalDefinition = string;
        this._internalTypeCode = MySQLColumnHelper._columnTypeAsInt(string);
        this._normalisedType = MySQLColumnHelper._columnTypeAsString(this._internalTypeCode);
        this._bHasPrecisionOnly = MySQLColumnHelper._datatypeHasPrecisionOnly(this._internalTypeCode);
        this._bHasPrecisionAndScale = MySQLColumnHelper._datatypeHasPrecisionAndScale(this._internalTypeCode);
        this._precision = MySQLColumnHelper._getDatatypePrecision(string);
        if (this._bHasPrecisionAndScale) {
            this._scale = MySQLColumnHelper._getDatatypeScale(string);
        }
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getScale() throws IllegalStateException {
        if (!this.hasPrecisionAndScale()) {
            throw new IllegalStateException("datatype " + this._normalisedType + BlackMessages.getString("MySQLColumnHelper.0"));
        }
        return this._scale;
    }

    public boolean hasPrecisionAndScale() {
        return this._bHasPrecisionAndScale;
    }

    public boolean hasPrecisionOnly() {
        return this._bHasPrecisionOnly;
    }

    public String getDataTypeName() {
        return this._normalisedType;
    }

    public String getOriginalType() {
        return this._originalDefinition;
    }

    private static String _columnTypeAsString(INTERNAL_TYPE_CODES iNTERNAL_TYPE_CODES) {
        switch (iNTERNAL_TYPE_CODES) {
            case _TINYINT_: {
                return "TINYINT";
            }
            case _SMALLINT_: {
                return "SMALLINT";
            }
            case _MEDIUMINT_: {
                return "MEDIUMINT";
            }
            case _INT_: {
                return "INT";
            }
            case _INTEGER_: {
                return "INTEGER";
            }
            case _BIGINT_: {
                return "BIGINT";
            }
            case _FLOAT_: {
                return "FLOAT";
            }
            case _DOUBLE_: {
                return "DOUBLE";
            }
            case _DOUBLE_PRECISION_: {
                return "DOUBLE PRECISION";
            }
            case _REAL_: {
                return "REAL";
            }
            case _DECIMAL_: {
                return "DECIMAL";
            }
            case _NUMERIC_: {
                return "NUMERIC";
            }
            case _DATE_: {
                return "DATE";
            }
            case _DATETIME_: {
                return "DATETIME";
            }
            case _TIMESTAMP_: {
                return "TIMESTAMP";
            }
            case _TIME_: {
                return "TIME";
            }
            case _YEAR_: {
                return "YEAR";
            }
            case _CHAR_: {
                return "CHAR";
            }
            case _VARCHAR_: {
                return "VARCHAR";
            }
            case _TINYBLOB_: {
                return "TINYBLOB";
            }
            case _TINYTEXT_: {
                return "TINYTEXT";
            }
            case _BLOB_: {
                return "BLOB";
            }
            case _TEXT_: {
                return "TEXT";
            }
            case _MEDIUMBLOB_: {
                return "MEDIUMBLOB";
            }
            case _MEDIUMTEXT_: {
                return "MEDIUMTEXT";
            }
            case _LONGBLOB_: {
                return "LONGBLOB";
            }
            case _LONGTEXT_: {
                return "LONGTEXT";
            }
            case _ENUM_: {
                return "ENUM";
            }
            case _SET_: {
                return "SET";
            }
            case _BIT_: {
                return "BIT";
            }
            case _BINARY_: {
                return "BINARY";
            }
            case _VARBINARY_: {
                return "VARBINARY";
            }
        }
        return null;
    }

    private static INTERNAL_TYPE_CODES _columnTypeAsInt(String string) {
        if (string.startsWith("tinyint")) {
            return INTERNAL_TYPE_CODES._TINYINT_;
        }
        if (string.startsWith("smallint")) {
            return INTERNAL_TYPE_CODES._SMALLINT_;
        }
        if (string.startsWith("mediumint")) {
            return INTERNAL_TYPE_CODES._MEDIUMINT_;
        }
        if (string.startsWith("int")) {
            return INTERNAL_TYPE_CODES._INT_;
        }
        if (string.startsWith("integer")) {
            return INTERNAL_TYPE_CODES._INTEGER_;
        }
        if (string.startsWith("bigint")) {
            return INTERNAL_TYPE_CODES._BIGINT_;
        }
        if (string.startsWith("float")) {
            return INTERNAL_TYPE_CODES._FLOAT_;
        }
        if (string.startsWith("double")) {
            return INTERNAL_TYPE_CODES._DOUBLE_;
        }
        if (string.startsWith("double precision")) {
            return INTERNAL_TYPE_CODES._DOUBLE_PRECISION_;
        }
        if (string.startsWith("real")) {
            return INTERNAL_TYPE_CODES._REAL_;
        }
        if (string.startsWith("decimal")) {
            return INTERNAL_TYPE_CODES._DECIMAL_;
        }
        if (string.startsWith("numeric")) {
            return INTERNAL_TYPE_CODES._NUMERIC_;
        }
        if (string.startsWith("date")) {
            return INTERNAL_TYPE_CODES._DATE_;
        }
        if (string.startsWith("datetime")) {
            return INTERNAL_TYPE_CODES._DATETIME_;
        }
        if (string.startsWith("timestamp")) {
            return INTERNAL_TYPE_CODES._TIMESTAMP_;
        }
        if (string.startsWith("time")) {
            return INTERNAL_TYPE_CODES._TIME_;
        }
        if (string.startsWith("year")) {
            return INTERNAL_TYPE_CODES._YEAR_;
        }
        if (string.startsWith("char")) {
            return INTERNAL_TYPE_CODES._CHAR_;
        }
        if (string.startsWith("varchar")) {
            return INTERNAL_TYPE_CODES._VARCHAR_;
        }
        if (string.startsWith("tinyblob")) {
            return INTERNAL_TYPE_CODES._TINYBLOB_;
        }
        if (string.startsWith("tinytext")) {
            return INTERNAL_TYPE_CODES._TINYTEXT_;
        }
        if (string.startsWith("blob")) {
            return INTERNAL_TYPE_CODES._BLOB_;
        }
        if (string.startsWith("text")) {
            return INTERNAL_TYPE_CODES._TEXT_;
        }
        if (string.startsWith("mediumblob")) {
            return INTERNAL_TYPE_CODES._MEDIUMBLOB_;
        }
        if (string.startsWith("mediumtext")) {
            return INTERNAL_TYPE_CODES._MEDIUMTEXT_;
        }
        if (string.startsWith("longblob")) {
            return INTERNAL_TYPE_CODES._LONGBLOB_;
        }
        if (string.startsWith("longtext")) {
            return INTERNAL_TYPE_CODES._LONGTEXT_;
        }
        if (string.startsWith("enum")) {
            return INTERNAL_TYPE_CODES._ENUM_;
        }
        if (string.startsWith("set")) {
            return INTERNAL_TYPE_CODES._SET_;
        }
        if (string.startsWith("bit")) {
            return INTERNAL_TYPE_CODES._BIT_;
        }
        if (string.startsWith("binary")) {
            return INTERNAL_TYPE_CODES._BINARY_;
        }
        if (string.startsWith("varbinary")) {
            return INTERNAL_TYPE_CODES._VARBINARY_;
        }
        return INTERNAL_TYPE_CODES._INVALID_;
    }

    private static boolean _datatypeHasPrecisionOnly(INTERNAL_TYPE_CODES iNTERNAL_TYPE_CODES) {
        boolean bl = false;
        if (iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._TINYINT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._SMALLINT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._MEDIUMINT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._INT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._INTEGER_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._BIGINT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._YEAR_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._CHAR_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._VARCHAR_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._TINYBLOB_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._TINYTEXT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._BLOB_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._TEXT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._MEDIUMBLOB_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._MEDIUMTEXT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._LONGBLOB_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._LONGTEXT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._BIT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._BINARY_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._VARBINARY_) {
            bl = true;
        }
        return bl;
    }

    private static boolean _datatypeHasPrecisionAndScale(INTERNAL_TYPE_CODES iNTERNAL_TYPE_CODES) {
        boolean bl = false;
        if (iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._FLOAT_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._DOUBLE_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._DOUBLE_PRECISION_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._REAL_ || iNTERNAL_TYPE_CODES == INTERNAL_TYPE_CODES._DECIMAL_) {
            bl = true;
        }
        return bl;
    }

    private static int _getDatatypePrecision(String string) {
        int n;
        int n2 = string.indexOf("(") + 1;
        if (-1 != n2 && -1 != (n = string.indexOf(")", n2))) {
            Integer n3;
            String string2 = null;
            try {
                string2 = string.substring(n2, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return MySQLColumnHelper._defaultPrecision(string);
            }
            try {
                n3 = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return MySQLColumnHelper._defaultPrecision(string);
            }
            return n3;
        }
        return MySQLColumnHelper._defaultPrecision(string);
    }

    private static int _getDatatypeScale(String string) {
        int n;
        int n2 = string.indexOf(",") + 1;
        if (-1 != n2 && -1 != (n = string.indexOf(")", n2))) {
            Integer n3;
            String string2 = null;
            try {
                string2 = string.substring(n2, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return MySQLColumnHelper._defaultScale(string);
            }
            try {
                n3 = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return MySQLColumnHelper._defaultScale(string);
            }
            return n3;
        }
        return MySQLColumnHelper._defaultScale(string);
    }

    private static int _defaultPrecision(String string) {
        if (string.startsWith("tinyint")) {
            return 3;
        }
        if (string.startsWith("smallint")) {
            return 5;
        }
        if (string.startsWith("mediumint")) {
            return 8;
        }
        if (string.startsWith("int")) {
            return 10;
        }
        if (string.startsWith("integer")) {
            return 10;
        }
        if (string.startsWith("bigint")) {
            return 19;
        }
        if (string.startsWith("char")) {
            return 1;
        }
        if (string.startsWith("varchar")) {
            return 3;
        }
        if (string.startsWith("tinyblob")) {
            return 3;
        }
        if (string.startsWith("tinytext")) {
            return 3;
        }
        if (string.startsWith("blob")) {
            return 5;
        }
        if (string.startsWith("text")) {
            return 5;
        }
        if (string.startsWith("mediumblob")) {
            return 8;
        }
        if (string.startsWith("mediumtext")) {
            return 8;
        }
        if (string.startsWith("longblob")) {
            return 10;
        }
        if (string.startsWith("longtext")) {
            return 10;
        }
        if (string.startsWith("bit")) {
            return 1;
        }
        if (string.startsWith("binary")) {
            return 1;
        }
        if (string.startsWith("varbinary")) {
            return 3;
        }
        return 0;
    }

    private static int _defaultScale(String string) {
        if (string.startsWith("float")) {
            return 9;
        }
        if (string.startsWith("double")) {
            return 16;
        }
        if (string.startsWith("decimal")) {
            return 16;
        }
        return 0;
    }

    private static String _addEscSequences(String string) {
        Character c = new Character('\'');
        if (-1 != string.indexOf("'")) {
            String string2 = new String();
            for (int i = 0; i < string.length(); ++i) {
                Character c2 = new Character(string.charAt(i));
                string2 = c2.equals(c) ? string2 + "''" : string2 + c2.charValue();
            }
            return string2;
        }
        return string;
    }

    private static enum INTERNAL_TYPE_CODES {
        _TINYINT_,
        _SMALLINT_,
        _MEDIUMINT_,
        _INT_,
        _INTEGER_,
        _BIGINT_,
        _FLOAT_,
        _DOUBLE_,
        _DOUBLE_PRECISION_,
        _REAL_,
        _DECIMAL_,
        _NUMERIC_,
        _DATE_,
        _DATETIME_,
        _TIMESTAMP_,
        _TIME_,
        _YEAR_,
        _CHAR_,
        _VARCHAR_,
        _TINYBLOB_,
        _TINYTEXT_,
        _BLOB_,
        _TEXT_,
        _MEDIUMBLOB_,
        _MEDIUMTEXT_,
        _LONGBLOB_,
        _LONGTEXT_,
        _ENUM_,
        _SET_,
        _BIT_,
        _INVALID_,
        _VARBINARY_,
        _BINARY_;

    }
}

