/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.res;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceUtils {
    private static final String DISPLAY_NAME = ".displayName";
    public static final String DISPLAY_ICON = ".displayIcon";
    private static final String MNEMONIC = ".mnemonic";
    private ResourceBundle m_resourceBundle = ResourceBundle.getBundle(ResourceUtils.class.getPackage().getName() + ".Resource");

    public ResourceBundle getResourceBundle() {
        return this.m_resourceBundle;
    }

    public String getString(String resourceFileIdentifier) {
        try {
            return this.m_resourceBundle.getString(resourceFileIdentifier);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getString(String resourceFileIdentifier, String[] substitutes) {
        return MessageFormat.format(this.getString(resourceFileIdentifier), substitutes);
    }

    public String getDisplayName(String resourceFileIdentifier) {
        return this.getString(resourceFileIdentifier + DISPLAY_NAME);
    }

    public Integer getMnemonic(String resourceFileIdentifier) {
        String resourceString = this.getString(resourceFileIdentifier + MNEMONIC);
        if (resourceString != null && resourceString.length() > 0) {
            return new Integer(resourceString.charAt(0));
        }
        return null;
    }
}

