/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Point;
import java.util.Date;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.model.ConnectionDetails;
import oracle.ide.vhv.model.GraphElementShape;
import oracle.ide.vhv.model.GraphElementVisitor;
import oracle.ide.vhv.model.HolderElement;
import oracle.ide.vhv.model.INameHelper;
import oracle.ide.vhv.model.VersionElement;
import oracle.ide.vhv.model.VersionTree;
import oracle.ide.vhv.model.VersionTreeLayoutManager;

public abstract class GraphElement
implements ConnectionDetails {
    protected VHVResource m_resource;
    private String m_notes = null;
    private String m_label = null;
    private Date m_datestamp = null;
    private VHVResource m_userResource;
    private GraphElement m_parent = null;
    private GraphElement m_child = null;
    private GraphElement m_owner = null;
    private boolean m_displayed = true;
    private Point m_location = null;
    private int m_connectionSide = 0;
    private int m_height = 0;
    private int m_width = 0;
    private GraphElementShape m_shape = null;

    public GraphElement() {
        this.m_datestamp = new Date();
    }

    GraphElement(VersionElement element) {
        this.m_resource = element.getResource();
        this.m_notes = element.getNotes();
        this.m_label = element.getVersionLabel();
        this.m_datestamp = element.getDatestamp();
        this.m_userResource = element.getUserResource();
    }

    public void validateElement(VersionTree tree) {
        if (this.m_owner instanceof HolderElement) {
            this.setOwnerElement(tree.getGraphElement(this.m_owner.getResource()));
        }
        if (this.m_parent instanceof HolderElement) {
            this.setParentElement(tree.getGraphElement(this.m_parent.getResource()));
        }
        if (this.m_child instanceof HolderElement) {
            this.setChildElement(tree.getGraphElement(this.m_child.getResource()));
        }
    }

    public VHVResource getResource() {
        return this.m_resource;
    }

    public String getNotes() {
        return this.m_notes;
    }

    public String getLabel() {
        return this.m_label;
    }

    public Date getDatestamp() {
        return this.m_datestamp;
    }

    public VHVResource getUserResource() {
        return this.m_userResource;
    }

    public GraphElement getParentElement() {
        return this.m_parent;
    }

    public GraphElement getDisplayedParentElement() {
        if (this.m_parent == null) {
            return this.m_parent;
        }
        if (this.m_parent.isDisplayed()) {
            return this.m_parent;
        }
        return this.m_parent.getDisplayedParentElement();
    }

    public GraphElement getChildElement() {
        return this.m_child;
    }

    public GraphElement getDisplayedChildElement() {
        if (this.m_child == null) {
            return this.m_child;
        }
        if (this.m_child.isDisplayed()) {
            return this.m_child;
        }
        return this.m_child.getDisplayedChildElement();
    }

    public GraphElement getOwnerElement() {
        return this.m_owner;
    }

    public boolean isDisplayed() {
        return this.m_displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.m_displayed = displayed;
    }

    void setOwnerElement(GraphElement g) {
        this.m_owner = g;
    }

    void setParentElement(GraphElement g) {
        this.m_parent = g;
    }

    void setChildElement(GraphElement g) {
        this.m_child = g;
    }

    public VersionTree getVersionTree() {
        return this.getOwnerElement().getVersionTree();
    }

    public VersionTreeLayoutManager getVersionTreeLayoutManager() {
        return this.getVersionTree().getLayoutManager();
    }

    void setLocation(Point p) {
        this.m_location = p;
    }

    public Point getLocation() {
        return this.m_location;
    }

    void setWidth(int width) {
        this.m_width = width;
    }

    public int getWidth() {
        return this.m_width;
    }

    void setHeight(int height) {
        this.m_height = height;
    }

    public int getHeight() {
        return this.m_height;
    }

    abstract Point getTopConnectionPoint();

    abstract Point getRightConnectionPoint();

    abstract Point getBottomConnectionPoint();

    abstract Point getLeftConnectionPoint();

    void setConnectionSide(int side) {
        this.m_connectionSide = side;
    }

    Point getConnectionPoint() {
        switch (this.m_connectionSide) {
            case 1: {
                return this.getDisplayedParentElement().getTopConnectionPoint();
            }
            case 2: {
                return this.getDisplayedParentElement().getRightConnectionPoint();
            }
            case 3: {
                return this.getDisplayedParentElement().getBottomConnectionPoint();
            }
            case 4: {
                return this.getDisplayedParentElement().getLeftConnectionPoint();
            }
        }
        return null;
    }

    public int getConnectionSide() {
        return this.m_connectionSide;
    }

    public void setShape(GraphElementShape shape) {
        this.m_shape = shape;
    }

    public GraphElementShape getShape() {
        return this.m_shape;
    }

    public abstract void accept(GraphElementVisitor var1) throws Exception;

    public String getDisplayName(INameHelper nameHelper) {
        return null;
    }

    public boolean equals(GraphElement ge) {
        return this.getResource().toString().equals(ge.getResource().toString());
    }

    public static interface DisplayNameConstant {
        public static final String MERGE_SEPARATOR = " -> ";
        public static final String LEFT_DELIM = "{";
        public static final String RIGHT_DELIM = "} ";
        public static final String VERSION_SEPARATOR = ";";
        public static final String CHECKOUT_SUFFIX = "CO";
    }
}

