/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import oracle.ide.vhv.model.Branch;

public class BranchList
extends ArrayList {
    private Comparator<Branch> _comparator = null;

    private Comparator<Branch> getComparator() {
        if (this._comparator == null) {
            this._comparator = ((Branch)this.get(0)).getBranchElement().getDatestamp() != null ? new DateComparator() : new NameComparator();
        }
        return this._comparator;
    }

    @Override
    public boolean add(Branch b) {
        if (this.isEmpty()) {
            super.add(b);
        } else {
            this.add(Math.abs(Collections.binarySearch(this, b, this.getComparator()) + 1), b);
        }
        return true;
    }

    private static class NameComparator
    implements Comparator<Branch> {
        private NameComparator() {
        }

        @Override
        public int compare(Branch o1, Branch o2) {
            return o1.getBranchElement().getLabel().compareTo(o2.getBranchElement().getLabel());
        }
    }

    private static class DateComparator
    implements Comparator<Branch> {
        private DateComparator() {
        }

        @Override
        public int compare(Branch o1, Branch o2) {
            return o1.getBranchElement().getDatestamp().compareTo(o2.getBranchElement().getDatestamp());
        }
    }
}

