/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import oracle.ide.vhv.VHVViewer;
import oracle.ide.vhv.view.VersionTreeDiagram;
import oracle.ide.vhv.view.VersionTreeDiagramPane;

class VHVThumbnail
extends JPanel
implements Observer {
    private static final double MIN_SCALE = 0.05;
    private static final double OPTIMAL_SCALE = 0.2;
    private static final double MAX_SCALE = 1.0;
    private final VHVViewer _viewer;
    private JScrollPane _scrollPane;
    private Dimension _currentSize;

    VHVThumbnail(VHVViewer viewer, Observable diagramViewObservable) {
        this._viewer = viewer;
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private boolean _dragging;
            private int _transx;
            private int _transy;

            @Override
            public void mouseMoved(MouseEvent me) {
                this.updateCursor(VHVThumbnail.this.getDiagramPane(), me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                VersionTreeDiagramPane diagramPane = VHVThumbnail.this.getDiagramPane();
                if (diagramPane == null) {
                    return;
                }
                Rectangle bounds = VHVThumbnail.this.getScaledViewportBounds(diagramPane);
                this._dragging = true;
                if (bounds.contains(me.getPoint())) {
                    this._transx = 0 - (me.getPoint().x - bounds.x);
                    this._transy = 0 - (me.getPoint().y - bounds.y);
                } else {
                    this._transx = 0 - bounds.width / 2;
                    this._transy = 0 - bounds.height / 2;
                    this.moveViewportPosition(me, this._transx, this._transy);
                }
                this.updateCursor(diagramPane, me);
            }

            private final void updateCursor(VersionTreeDiagramPane diagramPane, MouseEvent me) {
                if (diagramPane == null) {
                    return;
                }
                if (this._dragging) {
                    VHVThumbnail.this.setCursor(Cursor.getPredefinedCursor(13));
                    return;
                }
                if (VHVThumbnail.this.getScaledViewportBounds(diagramPane).contains(me.getPoint())) {
                    VHVThumbnail.this.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    VHVThumbnail.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                VersionTreeDiagramPane diagramPane = VHVThumbnail.this.getDiagramPane();
                if (diagramPane == null) {
                    return;
                }
                this._dragging = false;
                this.updateCursor(diagramPane, me);
            }

            @Override
            public void mouseClicked(MouseEvent me) {
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                if (!this._dragging) {
                    return;
                }
                this.moveViewportPosition(me, this._transx, this._transy);
                this.updateCursor(VHVThumbnail.this.getDiagramPane(), me);
            }

            private final void moveViewportPosition(MouseEvent me, int transx, int transy) {
                VersionTreeDiagramPane diagramPane = VHVThumbnail.this.getDiagramPane();
                if (diagramPane == null) {
                    return;
                }
                double sx = VHVThumbnail.this.getThumbnailScale();
                double zoom = diagramPane.getZoom();
                int x = this.translatePoint(me.getX(), sx, zoom, transx);
                int y = this.translatePoint(me.getY(), sx, zoom, transy);
                Dimension viewSize = diagramPane.getViewport().getViewSize();
                Dimension extentSize = diagramPane.getViewport().getExtentSize();
                Point p = new Point(Math.min(Math.max(0, viewSize.width - extentSize.width), Math.max(x, 0)), Math.min(Math.max(0, viewSize.height - extentSize.height), Math.max(y, 0)));
                diagramPane.getViewport().setViewPosition(p);
                diagramPane.updateScrollBars();
                VHVThumbnail.this.repaint();
                VHVThumbnail.this.scrollToView();
            }

            private int translatePoint(int x, double sx, double zoom, int trans) {
                return (int)((double)(x + trans) / sx * zoom);
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        diagramViewObservable.addObserver(this);
    }

    @Override
    public final void update(Observable o, Object arg) {
        VersionTreeDiagram diagram = this._viewer.getVersionTreeDiagram();
        if (diagram == null) {
            return;
        }
        Dimension size = diagram.getPreferredSize();
        if (this._currentSize == null || !this._currentSize.equals(size)) {
            this.revalidate();
            this._currentSize = size;
        }
        this.repaint();
        this.scrollToView();
    }

    JScrollPane getScrollPaneForThumbnail() {
        if (this._scrollPane == null) {
            this._scrollPane = new JScrollPane(this);
            this._scrollPane.setBorder(null);
            this._scrollPane.setVerticalScrollBarPolicy(22);
            this._scrollPane.setHorizontalScrollBarPolicy(32);
            this._scrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this._scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this._scrollPane.getVerticalScrollBar().setBlockIncrement(50);
            this._scrollPane.getHorizontalScrollBar().setBlockIncrement(50);
            this._scrollPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    VHVThumbnail.this.revalidate();
                }
            });
        }
        return this._scrollPane;
    }

    @Override
    public final Dimension getPreferredSize() {
        VersionTreeDiagram diagram = this._viewer.getVersionTreeDiagram();
        if (diagram == null) {
            return super.getPreferredSize();
        }
        Dimension diagramSize = diagram.getPreferredSize();
        double scale = this.getThumbnailScale(diagramSize);
        return new Dimension((int)((double)diagramSize.width * scale), (int)((double)diagramSize.height * scale));
    }

    final void scrollToView() {
        VersionTreeDiagram diagram = this._viewer.getVersionTreeDiagram();
        if (diagram == null) {
            return;
        }
        VersionTreeDiagramPane diagramPane = this._viewer.getVHVControl().getVersionTreeDiagramPane();
        Rectangle bounds = this.getScaledViewportBounds(diagramPane);
        bounds.x = Math.min(Math.max(0, bounds.x), this.getWidth());
        bounds.y = Math.min(Math.max(0, bounds.y), this.getHeight());
        bounds.width = Math.min(this.getWidth() - bounds.x, bounds.width);
        bounds.height = Math.min(this.getHeight() - bounds.y, bounds.height);
        if (!this._scrollPane.getViewport().getViewRect().contains(bounds)) {
            this.scrollRectToVisible(bounds);
        }
    }

    @Override
    protected final void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getBackground());
        g2d.fill(g2d.getClipBounds());
        VersionTreeDiagramPane diagramPane = this.getDiagramPane();
        if (diagramPane == null) {
            return;
        }
        g2d.setColor(diagramPane.getGUI().getBackground());
        g2d.fill(g2d.getClipBounds());
        double sx = this.getThumbnailScale();
        g2d.scale(sx, sx);
        this._viewer.getVersionTreeDiagram().paint(g2d, false);
        g2d.scale(1.0 / sx, 1.0 / sx);
        g2d.setColor(UIManager.getColor("List.selectionBackground"));
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setXORMode(this.getBackground());
        g2d.draw(this.getScaledViewportBounds(diagramPane));
    }

    private final Rectangle getScaledViewportBounds(VersionTreeDiagramPane diagramPane) {
        Rectangle r = this.getUnscaledViewportBounds(diagramPane);
        return this.scaleRectangle(r, this.getThumbnailScale());
    }

    private final Rectangle getUnscaledViewportBounds(VersionTreeDiagramPane diagramPane) {
        Rectangle r = diagramPane.getViewport().getViewRect();
        r = this.scaleRectangle(r, 1.0 / diagramPane.getZoom());
        return r;
    }

    private final Rectangle scaleRectangle(Rectangle r, double scale) {
        r.x = (int)((double)r.x * scale);
        r.y = (int)((double)r.y * scale);
        r.width = (int)((double)r.width * scale);
        r.height = (int)((double)r.height * scale);
        return r;
    }

    private final double getThumbnailScale() {
        return this.getThumbnailScale(this._viewer.getVersionTreeDiagram().getPreferredSize());
    }

    private final double getThumbnailScale(Dimension diagramSize) {
        Dimension currentSize = this._scrollPane.getViewport().getSize();
        double scalex = (double)currentSize.width / (double)diagramSize.width;
        double scaley = (double)currentSize.height / (double)diagramSize.height;
        double scale = scalex < 0.2 && scaley < 0.2 ? Math.max(scalex, scaley) : (scalex > 0.2 && scaley > 0.2 ? Math.min(scalex, scaley) : 0.2);
        return Math.min(1.0, Math.max(0.05, scale));
    }

    private final VersionTreeDiagramPane getDiagramPane() {
        VersionTreeDiagram diagram = this._viewer.getVersionTreeDiagram();
        return diagram != null ? this._viewer.getVHVControl().getVersionTreeDiagramPane() : null;
    }
}

