/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.RepaintManager;
import oracle.ide.Context;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.vhv.VHVViewer;
import oracle.ide.vhv.view.VersionTreeDiagramPane;

public class VHVDocumentPrintFactory
extends DocumentPrintFactory
implements Pageable,
Printable {
    private static final double SCALE = 0.25;
    private VersionTreeDiagramPane _versionTreeDiagramPane;

    public boolean isPrintingEnabled(Context context) {
        return context.getView() instanceof VHVViewer && !((VHVViewer)context.getView()).isInProgress();
    }

    public void create(Context context) {
        this._versionTreeDiagramPane = ((VHVViewer)context.getView()).getVHVControl().getVersionTreeDiagramPane();
        PrintManager.getPrintManager().setPageable((Pageable)this);
    }

    @Override
    public int getNumberOfPages() {
        PageFormat pageFormat = PrintManager.getPrintManager().getPageFormat();
        Dimension d = this._versionTreeDiagramPane.getGUI().getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pageFormat.getImageableHeight();
        double pageWidth = pageFormat.getImageableWidth();
        double scale = 0.25;
        int totalPagesX = (int)Math.ceil(scale * panelWidth / pageWidth);
        int totalPagesY = (int)Math.ceil(scale * panelHeight / pageHeight);
        return totalPagesX * totalPagesY;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return PrintManager.getPrintManager().getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        int response = 1;
        Graphics2D g2 = (Graphics2D)g;
        RepaintManager repaintManager = RepaintManager.currentManager(this._versionTreeDiagramPane.getGUI());
        boolean db = repaintManager.isDoubleBufferingEnabled();
        repaintManager.setDoubleBufferingEnabled(false);
        Dimension d = this._versionTreeDiagramPane.getGUI().getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pageFormat.getImageableHeight();
        double pageWidth = pageFormat.getImageableWidth();
        double scale = 0.25;
        int totalPagesX = (int)Math.ceil(scale * panelWidth / pageWidth);
        int totalPagesY = (int)Math.ceil(scale * panelHeight / pageHeight);
        int totalNumPages = totalPagesX * totalPagesY;
        int xOffset = pageIndex % totalPagesX;
        int yOffset = pageIndex / totalPagesX;
        if (pageIndex >= totalNumPages) {
            response = 1;
        } else {
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2.translate((double)(-xOffset) * pageWidth, (double)(-yOffset) * pageHeight);
            g2.scale(scale, scale);
            this._versionTreeDiagramPane.getGUI().paint(g2);
            response = 0;
        }
        repaintManager.setDoubleBufferingEnabled(db);
        return response;
    }
}

