/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.Locatable;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vhv.VHVActions;
import oracle.ide.vhv.VHVCommand;
import oracle.ide.vhv.VHVConstants;
import oracle.ide.vhv.VHVContextProcessor;
import oracle.ide.vhv.VHVViewer;
import oracle.ide.view.View;

public class VHVController
implements Controller,
ContextMenuListener {
    private static VHVController s_vhvController;
    private ContextMenu m_contextMenu;

    private VHVController() {
        this.setControllerOnActions();
    }

    public static VHVController getInstance() {
        if (s_vhvController == null) {
            s_vhvController = new VHVController();
        }
        return s_vhvController;
    }

    protected void setControllerOnActions() {
        this.setControllerOnAction(IdeActions.getViewRefreshAction());
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_ZOOM_IN_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_ZOOM_OUT_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_COMPARE_PREVIOUS_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_COMPARE_OTHER_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_MERGE_CMD_ID));
        this.setControllerOnAction(VHVActions.getAction(VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID));
        this.setControllerOnAction(VHVActions.getProgramAction(VHVConstants.VHV_PERFORM_COMPARE_CMD_ID));
        this.setControllerOnAction(VHVActions.getProgramAction(VHVConstants.VHV_PERFORM_MERGE_CMD_ID));
    }

    public boolean update(IdeAction action, Context context) {
        if (context != null) {
            View view = context.getView();
            if (action.getCommandId() == VHVCommand.VHV_CMD_ID) {
                Locatable[] locatables = this.getContextLocatables(context);
                URL url = locatables != null && locatables.length > 0 ? locatables[0].getURL() : null;
                action.setEnabled(url != null && url.getProtocol().equals("file") && VCSManager.getVCSManager().isVersioned(url));
                return true;
            }
            if (view instanceof VHVViewer && ((VHVViewer)view).getVHVControl() != null) {
                if (((VHVViewer)view).getVHVControl().updateAction(action, context)) {
                    return true;
                }
            } else {
                int id = action.getCommandId();
                if (id == VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID || id == VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID || id == VHVConstants.VHV_ZOOM_IN_CMD_ID || id == VHVConstants.VHV_ZOOM_OUT_CMD_ID || id == VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID || id == VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID || id == VHVConstants.VHV_COMPARE_PREVIOUS_CMD_ID || id == VHVConstants.VHV_COMPARE_OTHER_CMD_ID || id == VHVConstants.VHV_MERGE_CMD_ID || id == VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID) {
                    action.setEnabled(false);
                }
            }
        }
        return false;
    }

    protected Locatable[] getContextLocatables(Context context) {
        return VHVContextProcessor.getInstance().getContextLocatables(context);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        View view;
        return context != null && (view = context.getView()) instanceof VHVViewer && ((VHVViewer)view).getVHVControl() != null && ((VHVViewer)view).getVHVControl().handleAction(action, context);
    }

    public void menuWillShow(ContextMenu popup) {
        View view;
        if (popup.getContext() != null && (view = popup.getContext().getView()) instanceof VHVViewer && ((VHVViewer)view).getVHVControl() != null) {
            ((VHVViewer)view).getVHVControl().populateContextMenu(this.getContextMenu());
            ((VHVViewer)view).getVHVControl().updateContextSensitiveActions();
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public ContextMenu getContextMenu() {
        if (this.m_contextMenu == null) {
            this.m_contextMenu = new ContextMenu();
            this.m_contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this.m_contextMenu;
    }

    protected void setControllerOnAction(IdeAction action) {
        action.removeController((Controller)this);
        action.addController((Controller)this);
    }
}

