/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.log;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import oracle.dss.util.xdo.common.log.Logger;
import oracle.dss.util.xdo.common.log.XDOLog;

public class XDOLogImpl
implements XDOLog {
    private PrintWriter mOut;
    private int mLevel = 4;
    private String mModule = "all";
    private StringBuffer mBuf;

    public XDOLogImpl() {
        this.initParameters();
        this.initPrintWriter(this.getDefaultPrintStream());
    }

    public void setDestination(Writer pOut) {
        this.initPrintWriter(pOut);
    }

    public void setDestination(OutputStream pOut) {
        this.initPrintWriter(pOut);
    }

    @Override
    public void setLevel(int pLevel) {
        this.mLevel = pLevel;
    }

    @Override
    public void setModule(String pModule) {
        this.mModule = pModule;
    }

    public static void write(Object pThis, String pString, int pLevel, PrintWriter out) {
        StringBuffer buf = new StringBuffer();
        buf.append("[" + Logger.getTimeStampStr() + "]");
        if (pThis == null) {
            buf.append('[').append(']');
        } else {
            buf.append('[').append(pThis.getClass().getName()).append(']');
        }
        buf.append('[');
        switch (pLevel) {
            case 6: {
                buf.append("UNEXPECTED");
                break;
            }
            case 5: {
                buf.append("ERROR");
                break;
            }
            case 4: {
                buf.append("EXCEPTION");
                break;
            }
            case 3: {
                buf.append("EVENT");
                break;
            }
            case 2: {
                buf.append("PROCEDURE");
                break;
            }
            case 1: {
                buf.append("STATEMENT");
                break;
            }
            case 0: {
                buf.append("OFF");
            }
        }
        buf.append("] ").append(pString);
        out.println(buf.toString());
    }

    @Override
    public void write(Object pThis, String pString, int pLevel) {
        if (this.mLevel != 0 && pLevel >= this.mLevel && (pThis == null || XDOLogImpl.isMatch(pThis, this.mModule))) {
            XDOLogImpl.write(pThis, pString, pLevel, this.mOut);
        }
    }

    @Override
    public void write(String pString, int pLevel) {
        this.write(null, pString, pLevel);
    }

    @Override
    public boolean isEnabled(int pLevel) {
        return this.mLevel <= pLevel;
    }

    private static boolean isMatch(Object pObj, String pExp) {
        boolean isMatch = false;
        if (pExp.equals("all") || pExp.equals("%")) {
            isMatch = true;
        } else {
            String name = pObj.getClass().getName();
            if (pExp.startsWith("%")) {
                if (name.endsWith(pExp.substring(1))) {
                    isMatch = true;
                }
            } else if (pExp.endsWith("%")) {
                if (name.startsWith(pExp.substring(0, pExp.length() - 1))) {
                    isMatch = true;
                }
            } else if (name.equals(pExp)) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private void initPrintWriter(OutputStream pOut) {
        try {
            this.mOut = new PrintWriter((Writer)new OutputStreamWriter(pOut, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void initPrintWriter(Writer pOut) {
        this.mOut = pOut instanceof PrintWriter ? (PrintWriter)pOut : new PrintWriter(pOut, true);
    }

    private PrintStream getDefaultPrintStream() {
        try {
            char[] c = new char[]{'j', 'a', 'v', 'a', '.', 'l', 'a', 'n', 'g', '.', 'S', 'y', 's', 't', 'e', 'm'};
            String s = new String(c);
            Class<?> t = Class.forName(s);
            Field f = t.getField("out");
            Object o = f.get(null);
            return (PrintStream)o;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initParameters() {
        if (System.getProperty("AFLOG_LEVEL") != null) {
            if (System.getProperty("AFLOG_LEVEL").equals("UNEXPECTED")) {
                this.mLevel = 6;
            }
            if (System.getProperty("AFLOG_LEVEL").equals("ERROR")) {
                this.mLevel = 5;
            }
            if (System.getProperty("AFLOG_LEVEL").equals("EXCEPTION")) {
                this.mLevel = 4;
            }
            if (System.getProperty("AFLOG_LEVEL").equals("EVENT")) {
                this.mLevel = 3;
            }
            if (System.getProperty("AFLOG_LEVEL").equals("PROCEDURE")) {
                this.mLevel = 2;
            }
            if (System.getProperty("AFLOG_LEVEL").equals("STATEMENT")) {
                this.mLevel = 1;
            }
            if (System.getProperty("AFLOG_LEVEL").equals("OFF")) {
                this.mLevel = 0;
            }
        }
        if (System.getProperty("AFLOG_ENABLED") != null && System.getProperty("AFLOG_ENABLED").equals("FALSE")) {
            this.mLevel = 0;
        }
    }
}

