/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.log;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.dss.util.xdo.common.log.DebugUtil;
import oracle.dss.util.xdo.common.log.XDOLog;
import oracle.dss.util.xdo.common.log.XDOLogConstants;
import oracle.dss.util.xdo.common.log.XDOLogImpl;

public class Logger
implements XDOLogConstants {
    private static XDOLog mLog;
    private static DebugUtil mDebug;
    private static SimpleDateFormat mDateFormatter;
    private static boolean mHasExceptions;

    private Logger() {
    }

    public static void setLog(XDOLog pLog) {
        mLog = pLog;
    }

    public static XDOLog getLog() {
        return mLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLevel(int pLevel) {
        XDOLog xDOLog = mLog;
        synchronized (xDOLog) {
            mLog.setLevel(pLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setModule(String pModule) {
        XDOLog xDOLog = mLog;
        synchronized (xDOLog) {
            mLog.setModule(pModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Object pObj, String pMsg, int pLevel) {
        Object object = mLog;
        synchronized (object) {
            mLog.write(pObj, pMsg, pLevel);
        }
        object = mDebug;
        synchronized (object) {
            int level;
            if (mDebug.isDebugMode() && (level = mDebug.getLogLevel()) != 0 && pLevel >= level) {
                mDebug.write(pObj, pMsg, pLevel);
            }
        }
        if (!mHasExceptions && pLevel >= 4) {
            mHasExceptions = true;
        }
    }

    public static void log(String pMsg) {
        Logger.log(null, pMsg, 1);
    }

    public static void log(String pMsg, int pLevel) {
        Logger.log(null, pMsg, pLevel);
    }

    public static void log(Object pObj, Throwable pError, int pLevel) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        pError.printStackTrace(pWriter);
        pWriter.flush();
        Logger.log(pObj, sWriter.toString(), pLevel);
        pWriter = null;
        sWriter = null;
    }

    public static void log(Throwable pError, int pLevel) {
        Logger.log(null, pError, pLevel);
    }

    public static void log(Object pObj, Throwable pError) {
        Logger.log(pObj, pError, 4);
    }

    public static void log(Throwable pError) {
        Logger.log(pError, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled(int pLevel) {
        XDOLog xDOLog = mLog;
        synchronized (xDOLog) {
            return mLog.isEnabled(pLevel);
        }
    }

    public static boolean hasExceptions() {
        return mHasExceptions;
    }

    public static synchronized String getTimeStampStr() {
        return mDateFormatter.format(new Date());
    }

    public static void init() {
        mDebug.checkConfigFile();
        if (mDebug.isDebugMode()) {
            Logger.log("Logger.init(): *** DEBUG MODE IS ON. ***", 1);
            Logger.log("Logger.init(): LogDir=" + mDebug.getLogDir(), 1);
            Logger.setLevel(mDebug.getLogLevel());
        } else {
            Logger.log("Logger.init(): *** DEBUG MODE IS OFF. ***", 1);
        }
    }

    public static boolean isDebugMode() {
        return mDebug.isDebugMode();
    }

    public static String getLogDir() {
        return mDebug.getLogDir();
    }

    public static InputStream logFile(InputStream in, String filename) {
        return mDebug.logFile(in, filename);
    }

    public static Reader logFile(Reader in, String filename) {
        return mDebug.logFile(in, filename);
    }

    public static void main(String[] args) {
        Logger.init();
        Logger.setLevel(2);
        Logger.log(null, "====================== no module setting", 6);
        Logger.log((Object)"a", "unexcpected string", 6);
        Logger.log((Object)"a", "error string", 5);
        Logger.log((Object)"a", "exception string", 4);
        Logger.log((Object)"a", "event string", 3);
        Logger.log((Object)"a", "procedure string", 2);
        Logger.log((Object)"a", "statement string", 1);
        Logger.log("unexcpected null", 6);
        Logger.log("error null", 5);
        Logger.log("exception null", 4);
        Logger.log("event null", 3);
        Logger.log("procedure null", 2);
        Logger.log("statement null", 1);
        Logger.setModule("java.lang%");
        Logger.log(null, "====================== 'java.lang%' match", 6);
        Logger.log((Object)"a", "unexcpected string", 6);
        Logger.log((Object)"a", "error string", 5);
        Logger.log((Object)"a", "exception string", 4);
        Logger.log((Object)"a", "event string", 3);
        Logger.log((Object)"a", "procedure string", 2);
        Logger.log((Object)"a", "statement string", 1);
        Logger.log("unexcpected null", 6);
        Logger.log("error null", 5);
        Logger.log("exception null", 4);
        Logger.log("event null", 3);
        Logger.log("procedure null", 2);
        Logger.log("statement null", 1);
        Logger.setModule("%.lang.String");
        Logger.log(null, "====================== '%.lang.String' match", 6);
        Logger.log((Object)"a", "unexcpected string", 6);
        Logger.log((Object)"a", "error string", 5);
        Logger.log((Object)"a", "exception string", 4);
        Logger.log((Object)"a", "event string", 3);
        Logger.log((Object)"a", "procedure string", 2);
        Logger.log((Object)"a", "statement string", 1);
        Logger.log("unexcpected null", 6);
        Logger.log("error null", 5);
        Logger.log("exception null", 4);
        Logger.log("event null", 3);
        Logger.log("procedure null", 2);
        Logger.log("statement null", 1);
        Logger.setModule("java.io");
        Logger.log(null, "====================== java.io match", 6);
        Logger.log((Object)"a", "unexcpected string", 6);
        Logger.log((Object)"a", "error string", 5);
        Logger.log((Object)"a", "exception string", 4);
        Logger.log((Object)"a", "event string", 3);
        Logger.log((Object)"a", "procedure string", 2);
        Logger.log((Object)"a", "statement string", 1);
        Logger.log("unexcpected null", 6);
        Logger.log("error null", 5);
        Logger.log("exception null", 4);
        Logger.log("event null", 3);
        Logger.log("procedure null", 2);
        Logger.log("statement null", 1);
        Logger.setModule("all");
        Logger.log(null, "====================== all match again", 6);
        Logger.log((Object)"a", "unexcpected string", 6);
        Logger.log((Object)"a", "error string", 5);
        Logger.log((Object)"a", "exception string", 4);
        Logger.log((Object)"a", "event string", 3);
        Logger.log((Object)"a", "procedure string", 2);
        Logger.log((Object)"a", "statement string", 1);
        Logger.log("unexcpected null", 6);
        Logger.log("error null", 5);
        Logger.log("exception null", 4);
        Logger.log("event null", 3);
        Logger.log("procedure null", 2);
        Logger.log("statement null", 1);
        Logger.log(null, "====================== log", 6);
        Logger.log(new Exception("no level exception"));
        Logger.log(new Exception("unexpected"), 6);
        Logger.log(new Exception("error"), 5);
        Logger.log(new Exception("exception"), 4);
        Logger.log(new Exception("event"), 3);
        Logger.log(new Exception("procedure"), 2);
        Logger.log(new Exception("statement"), 1);
        Logger.setModule("java.lang");
        Logger.log(null, "====================== log java.lang match ", 6);
        Logger.log((Object)"a", new Exception("no level exception string"));
        Logger.log((Object)"a", new Exception("unexpected string"), 6);
        Logger.log((Object)"a", new Exception("error string"), 5);
        Logger.log((Object)"a", new Exception("exception string"), 4);
        Logger.log((Object)"a", new Exception("event string"), 3);
        Logger.log((Object)"a", new Exception("procedure string"), 2);
        Logger.log((Object)"a", new Exception("statement string"), 1);
        Logger.log(new Exception("no level exception null"));
        Logger.log(new Exception("unexpected null"), 6);
        Logger.log(new Exception("error null"), 5);
        Logger.log(new Exception("exception null"), 4);
        Logger.log(new Exception("event null"), 3);
        Logger.log(new Exception("procedure null"), 2);
        Logger.log(new Exception("statement null"), 1);
        Logger.setModule("java.io");
        Logger.log(null, "====================== log java.io match ", 6);
        Logger.log((Object)"a", new Exception("no level exception string"));
        Logger.log((Object)"a", new Exception("unexpected string"), 6);
        Logger.log((Object)"a", new Exception("error string"), 5);
        Logger.log((Object)"a", new Exception("exception string"), 4);
        Logger.log((Object)"a", new Exception("event string"), 3);
        Logger.log((Object)"a", new Exception("procedure string"), 2);
        Logger.log((Object)"a", new Exception("statement string"), 1);
        Logger.log(new Exception("no level exception null"));
        Logger.log(new Exception("unexpected null"), 6);
        Logger.log(new Exception("error null"), 5);
        Logger.log(new Exception("exception null"), 4);
        Logger.log(new Exception("event null"), 3);
        Logger.log(new Exception("procedure null"), 2);
        Logger.log(new Exception("statement null"), 1);
    }

    static {
        if (mLog == null) {
            mLog = new XDOLogImpl();
            mDebug = new DebugUtil();
            mDateFormatter = new SimpleDateFormat("MMddyy_hhmmssSSS");
            mHasExceptions = false;
        }
    }
}

