/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.dss.util.xdo.common.log.Logger;

public class LogOutputStream
extends OutputStream {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/log/LogOutputStream.java /main/4 2010/02/17 16:23:11 bmoroze Exp $";
    private OutputStream mCustOutStream = null;
    private BufferedOutputStream mLogStream = null;

    public LogOutputStream(OutputStream outStream, String filename) throws IOException {
        this.mCustOutStream = outStream;
        String logDir = Logger.getLogDir();
        if (logDir == null) {
            this.mLogStream = null;
            return;
        }
        String logPath = logDir + File.separator + filename;
        if (logPath != null) {
            this.mLogStream = new BufferedOutputStream(new FileOutputStream(logPath));
        }
    }

    @Override
    public void flush() throws IOException {
        this.mCustOutStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mLogStream != null) {
            this.mLogStream.close();
            this.mLogStream = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mCustOutStream.write(b);
        if (this.mLogStream != null) {
            this.mLogStream.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mCustOutStream.write(b);
        if (this.mLogStream != null) {
            this.mLogStream.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mCustOutStream.write(b, off, len);
        if (this.mLogStream != null) {
            this.mLogStream.write(b, off, len);
        }
    }
}

