/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform.calcColumns;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dss.util.transform.ColumnValue;
import oracle.dss.util.transform.CommonComparator;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.calcColumns.CalcColumnValue;

@Deprecated
public class ColumnMetadata {
    private Object m_min = null;
    private Object m_max = null;
    private BigDecimal m_sum = BigDecimal.valueOf(0L);
    private long m_count = 0L;
    private Object m_median = null;
    private boolean m_calcedMedian = false;
    private List<ColumnValue> m_values = new ArrayList<ColumnValue>();
    private List<CalcColumnValue> m_calcColValues = new ArrayList<CalcColumnValue>();
    private ColumnValue[] m_sortedValues = null;
    private Set<Object> m_uniqueSet = new HashSet<Object>();

    public Object getMin() {
        return this.m_min;
    }

    public Object getMax() {
        return this.m_max;
    }

    public long getValueCount() {
        return this.m_count;
    }

    public int getUniqueValueCount() {
        return this.m_uniqueSet.size();
    }

    public Object getMean() {
        if (this.m_count == 0L) {
            return null;
        }
        if (this.m_min instanceof BigInteger && this.m_max instanceof BigInteger) {
            return this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.HALF_UP).toBigInteger();
        }
        if (this.m_min instanceof BigDecimal && this.m_max instanceof BigDecimal) {
            return this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.HALF_UP);
        }
        if (this.m_min instanceof Number && this.m_max instanceof Number) {
            return this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.HALF_UP).doubleValue();
        }
        return null;
    }

    public Object getMedian() {
        if (this.m_calcedMedian) {
            return this.m_median;
        }
        ColumnValue[] vals = this.getSortedValues();
        int valCount = vals.length;
        if (valCount == 0) {
            this.m_calcedMedian = true;
            return this.m_median;
        }
        if ((double)(valCount / 2) == (double)valCount / 2.0) {
            Object val1 = null;
            Object val2 = null;
            try {
                val1 = vals[valCount / 2 - 1].getValue();
                val2 = vals[valCount / 2].getValue();
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            this.m_calcedMedian = true;
            this.m_median = val1 instanceof BigInteger && val2 instanceof BigInteger ? ((BigInteger)val1).add((BigInteger)val2).divide(BigInteger.valueOf(2L)) : (val1 instanceof BigDecimal && val2 instanceof BigDecimal ? ((BigDecimal)val1).add((BigDecimal)val2).divide(BigDecimal.valueOf(2L)) : (val1 instanceof Number && val2 instanceof Number ? Double.valueOf((((Number)val1).doubleValue() + ((Number)val2).doubleValue()) / 2.0) : null));
        } else {
            this.m_calcedMedian = true;
            try {
                Object obj = vals[vals.length / 2].getValue();
                this.m_median = !(obj instanceof String) && !(obj instanceof Date) ? obj : null;
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        return this.m_median;
    }

    protected ColumnValue[] getSortedValues() {
        if (this.m_sortedValues == null) {
            ColumnValue[] vals = this.m_values.toArray(new ColumnValue[0]);
            Arrays.sort(vals, new CommonComparator(0, false));
            for (int i = 0; i < vals.length; ++i) {
                vals[i].setIndex(i);
            }
            this.m_sortedValues = vals;
        }
        return this.m_sortedValues;
    }

    protected List<ColumnValue> getValues() {
        return this.m_values;
    }

    protected List<CalcColumnValue> getCalcColumnValues() {
        return this.m_calcColValues;
    }

    private void trackValue(ColumnValue value, CalcColumnValue ccv) throws TransformException {
        this.m_values.add(value);
        this.m_calcColValues.add(ccv);
        this.m_uniqueSet.add(value.getValue());
        ++this.m_count;
    }

    protected void update(ColumnValue inputColVal, CalcColumnValue ccv) throws TransformException {
        Object value = inputColVal.getValue();
        if (value instanceof BigInteger) {
            BigInteger biVal = (BigInteger)value;
            this.m_min = this.m_min == null ? value : biVal.min((BigInteger)this.m_min);
            this.m_max = this.m_max == null ? value : biVal.max((BigInteger)this.m_max);
            this.trackValue(inputColVal, ccv);
            this.m_sum = this.m_sum.add(new BigDecimal(biVal));
        } else if (value instanceof BigDecimal) {
            BigDecimal bdVal = (BigDecimal)value;
            this.m_min = this.m_min == null ? value : bdVal.min((BigDecimal)this.m_min);
            this.m_max = this.m_max == null ? value : bdVal.max((BigDecimal)this.m_max);
            this.trackValue(inputColVal, ccv);
            this.m_sum = this.m_sum.add(bdVal);
        } else if (value instanceof Number) {
            double dVal = ((Number)value).doubleValue();
            this.m_min = this.m_min == null ? value : new Double(Math.min(((Number)this.m_min).doubleValue(), dVal));
            this.m_max = this.m_max == null ? value : new Double(Math.max(((Number)this.m_max).doubleValue(), dVal));
            this.trackValue(inputColVal, ccv);
            this.m_sum = this.m_sum.add(BigDecimal.valueOf(dVal));
        } else if (value instanceof String) {
            if (this.m_min == null) {
                this.m_min = value;
            } else {
                Object object = this.m_min = ((String)value).compareTo((String)this.m_min) < 0 ? value : this.m_min;
            }
            this.m_max = this.m_max == null ? value : (((String)value).compareTo((String)this.m_max) > 0 ? value : this.m_max);
            this.trackValue(inputColVal, ccv);
        } else if (value instanceof Date) {
            if (this.m_min == null) {
                this.m_min = value;
            } else {
                Object object = this.m_min = ((Date)value).before((Date)this.m_min) ? value : this.m_min;
            }
            this.m_max = this.m_max == null ? value : (((Date)value).after((Date)this.m_max) ? value : this.m_max);
            this.trackValue(inputColVal, ccv);
        }
    }
}

