/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.map;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapUtils {
    protected static DOMParser m_parser = null;
    private String _url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeRequest(String urlStr, String xml) throws Exception {
        URL url = new URL(urlStr);
        URLConnection connection = url.openConnection();
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        httpConn.setRequestMethod("POST");
        String request = "xml_request=" + xml;
        OutputStreamWriter out = null;
        BufferedReader in = null;
        InputStreamReader isr = null;
        try {
            String inputLine;
            httpConn.setDoOutput(true);
            out = new OutputStreamWriter(connection.getOutputStream());
            out.write(request);
            out.close();
            isr = new InputStreamReader(httpConn.getInputStream());
            in = new BufferedReader(isr);
            StringBuffer buf = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                buf.append(inputLine);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            httpConn.disconnect();
        }
    }

    public static XMLDocument parseXML(String xml) throws Exception {
        if (m_parser == null) {
            m_parser = new DOMParser();
            m_parser.setValidationMode(0);
            m_parser.setPreserveWhitespace(false);
        }
        m_parser.parse((Reader)new StringReader(xml));
        return m_parser.getDocument();
    }

    public MapUtils(String url) {
        if (!url.endsWith("omserver")) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + "omserver";
        }
        this._url = url;
    }

    private String getMapCacheUrl() {
        if (this._url.endsWith("omserver")) {
            String mapCacheUrl = this._url.replace("omserver", "mcserver");
            return mapCacheUrl;
        }
        return this._url + "/mcserver";
    }

    public String getURl() {
        return this._url;
    }

    public Vector getDataSources() {
        String request = this.getXmlForGetDataSources();
        return this.getMapResults(request, "map_data_source");
    }

    public Vector getMaps(String dataSource) {
        String request = this.getXmlForGetMaps(dataSource);
        return this.getMapResults(request, "map");
    }

    public Vector getThemes(String dataSource) {
        String request = this.getXmlForGetThemmes(dataSource);
        return this.getMapResults(request, "predefined_theme");
    }

    public Vector getThemes(String dataSource, String map) {
        String request = this.getXmlForGetThemmes(dataSource, map);
        return this.getMapResults(request, "predefined_theme");
    }

    public Vector getThemeColumns(String dataSource, String theme) {
        String request = this.getXmlForGetThemmeColumns(dataSource, theme);
        return this.getMapResults(request, "column");
    }

    public XMLDocument getSampleData(String dataSource, String theme) {
        String baseTableRequest = this.getXmlForBaseTable(dataSource, theme);
        String result = null;
        String baseTable = null;
        try {
            result = MapUtils.executeRequest(this._url, baseTableRequest);
            if (result != null) {
                XMLDocument _xmlDoc = MapUtils.parseXML(result);
                Node rowsetNode = _xmlDoc.getFirstChild();
                Node rowNode = rowsetNode.getFirstChild();
                Node baseTableNode = rowNode.getFirstChild();
                baseTable = baseTableNode.getTextContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (baseTable != null) {
            String request = this.getXmlForSampleData(dataSource, baseTable);
            try {
                result = MapUtils.executeRequest(this._url, request);
                if (result != null) {
                    XMLDocument _xmlDoc = MapUtils.parseXML(result);
                    return _xmlDoc;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public URL getMapImageURL(String dataSource, String baseMap, String width, String height, String center, String tLong, String tLat) {
        String request = this.getXmlForMapGeneration(dataSource, baseMap, width, height, center, tLong, tLat);
        URL mapURL = null;
        try {
            String response = MapUtils.executeRequest(this._url, request);
            XMLDocument _xmlDoc = MapUtils.parseXML(response);
            NodeList _nList = _xmlDoc.getElementsByTagName("map_content");
            if (_nList != null && _nList.getLength() == 1) {
                String url = _nList.item(0).getAttributes().getNamedItem("url").getNodeValue();
                mapURL = new URL(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mapURL;
    }

    public Vector getStyles(String dataSource, String styleType) {
        String request = this.getXmlForGetStyles(dataSource, styleType);
        return this.getMapResults(request, "style");
    }

    private String getXMLforMapConfiguration(String ds, String ci) {
        String mapconfigRequest = "<?xml version=\"1.0\" standalone=\"yes\"?> <map_cache_admin_request> <get_client_config  map_cache_names = \"" + ds + "." + ci + "\" " + "format=\"XML\"/> " + "</map_cache_admin_request>";
        return mapconfigRequest;
    }

    public int getMapSRID(String ds, String ci) {
        String mapconfigRequest = this.getXMLforMapConfiguration(ds, ci);
        int srid = -1;
        try {
            String mapconfig = MapUtils.executeRequest(this.getMapCacheUrl(), mapconfigRequest);
            XMLDocument _xmlDoc = MapUtils.parseXML(mapconfig);
            NodeList coors = _xmlDoc.getElementsByTagName("coordinate_system");
            if (coors.getLength() > 0) {
                XMLElement coor = null;
                coor = (XMLElement)coors.item(0);
                if (coor != null) {
                    String sSrid = coor.getAttribute("srid");
                    srid = Integer.valueOf(sSrid);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return srid;
    }

    public Point2D transformCoordinate(Point2D orig, String ds, int fromSrid, int toSrid) throws Exception {
        String sFromSid = Integer.toString(fromSrid);
        String sToSid = Integer.toString(toSrid);
        String sX = Double.toString(orig.getX());
        String sY = Double.toString(orig.getY());
        String xml = "<?xml version=\"1.0\" standalone=\"yes\"?> <info_request datasource = \"" + ds + "\" format=\"strict\"  " + "type=\"query_transform_srid\">" + "<query_transform_srid in_srid=\"" + sFromSid + "\" out_srid=\"" + sToSid + "\"> " + sX + "," + sY + "</query_transform_srid>" + "</info_request>";
        String newCoor = MapUtils.executeRequest(this._url, xml);
        XMLDocument xmlDoc = MapUtils.parseXML(newCoor);
        NodeList xe = xmlDoc.getElementsByTagName("coord_X");
        NodeList ye = xmlDoc.getElementsByTagName("coord_Y");
        sX = ((XMLElement)xe.item(0)).getTextContent();
        sY = ((XMLElement)ye.item(0)).getTextContent();
        Point2D.Double outc = new Point2D.Double();
        outc.x = Double.valueOf(sX);
        outc.y = Double.valueOf(sY);
        return outc;
    }

    public double getDefaultMapSize(String ds, String ci, int mapZoom) {
        String mapconfigRequest = this.getXMLforMapConfiguration(ds, ci);
        try {
            String mapconfig = MapUtils.executeRequest(this.getMapCacheUrl(), mapconfigRequest);
            XMLDocument _xmlDoc = MapUtils.parseXML(mapconfig);
            NodeList zoomLevels = _xmlDoc.getElementsByTagName("zoom_level");
            if (zoomLevels.getLength() > 0) {
                XMLElement xmlZoomLevel = null;
                xmlZoomLevel = mapZoom < zoomLevels.getLength() ? (XMLElement)zoomLevels.item(mapZoom) : (XMLElement)zoomLevels.item(0);
                double title_image_height = Double.valueOf(xmlZoomLevel.getAttribute("tile_image_height"));
                double title_height = Double.valueOf(xmlZoomLevel.getAttribute("tile_height"));
                double size = title_height * 355.0 / title_image_height;
                return size;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    private String getXmlForMapGeneration(String dataSource, String baseMap, String width, String height, String center, String tLong, String tLat) {
        return "<?xml version=\"1.0\" standalone=\"yes\"?> <map_request  datasource=\"" + dataSource + "\" " + "width=\"" + width + "\" " + "height=\"" + height + "\" " + "antialiase=\"false\" " + "format=\"GIF_URL\"> " + "<center size=\"" + center + "\"> " + "<geoFeature> " + "<geometricProperty typeName=\"center\"> " + "<Point > " + "<coordinates>" + tLong + "," + tLat + "</coordinates> " + "</Point> " + "</geometricProperty> " + "</geoFeature> " + "</center> " + "<themes>" + "   <theme name=\"mytheme\">" + "     <map_tile_theme map_tile_layer=\"" + baseMap + "\" snap_to_tile_scale=\"true\"/>" + "   </theme>" + " </themes>" + "</map_request>";
    }

    private String getXmlForGetMaps(String dataSource) {
        return "<?xml version=\"1.0\" standalone=\"yes\"?><non_map_request><list_maps data_source=\"" + dataSource + "\"/></non_map_request>";
    }

    private String getXmlForGetDataSources() {
        return "<?xml version=\"1.0\" standalone=\"yes\"?><non_map_request><list_data_sources /></non_map_request>";
    }

    private String getXmlForGetThemmes(String dataSource) {
        return "<?xml version=\"1.0\" standalone=\"yes\"?><non_map_request><list_predefined_themes data_source=\"" + dataSource + "\"/></non_map_request>";
    }

    private String getXmlForGetThemmes(String dataSource, String map) {
        return "<?xml version=\"1.0\" standalone=\"yes\"?><non_map_request><list_predefined_themes data_source=\"" + dataSource + "\" " + "map=\"" + map + "\"/></non_map_request>";
    }

    private String getXmlForGetThemmeColumns(String dataSource, String theme) {
        return "<?xml version=\"1.0\" standalone=\"yes\"?><non_map_request><list_theme_columns data_source=\"" + dataSource + "\" " + "theme=\"" + theme + "\"/></non_map_request>";
    }

    private String getXmlForSampleData(String dataSource, String baseTable) {
        return " <?xml version=\"1.0\" standalone=\"yes\"?> <info_request datasource=\"" + dataSource + "\" format=\"strict\">" + "<![CDATA[select * from (SELECT * FROM " + baseTable + ") where rownum < 6]]>" + " </info_request> ";
    }

    private String getXmlForBaseTable(String dataSource, String theme) {
        return " <?xml version=\"1.0\" standalone=\"yes\"?> <info_request datasource=\"" + dataSource + "\" format=\"strict\">" + "<![CDATA[SELECT base_table FROM user_sdo_themes where name='" + theme + "']]>" + " </info_request> ";
    }

    private String getXmlForGetStyles(String dataSource, String styleTyle) {
        return "<?xml version=\"1.0\" standalone=\"yes\"?><non_map_request><list_styles data_source=\"" + dataSource + "\" " + "style_type=\"" + styleTyle + "\"/></non_map_request>";
    }

    private Vector getMapResults(String xml, String tagname) {
        Vector<String> results = new Vector<String>();
        try {
            String result = MapUtils.executeRequest(this._url, xml);
            XMLDocument _xmlDoc = MapUtils.parseXML(result);
            NodeList _nList = _xmlDoc.getElementsByTagName(tagname);
            int size = _nList.getLength();
            for (int i = 0; i < size; ++i) {
                String value = _nList.item(i).getAttributes().getNamedItem("name").getNodeValue();
                results.add(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static void main(String[] args) {
        MapUtils mapUtils = new MapUtils("http://stadb32.us.oracle.com:8080/mapviewer/omserver");
        mapUtils.getDataSources();
        mapUtils.getMaps("mvdemo");
        mapUtils.getThemes("mvdemo");
        mapUtils.getThemes("mvdemo", "DEMO_MAP");
        mapUtils.getStyles("mvdemo", "COLOR");
    }
}

