/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.util.IDResolver;
import oracle.dss.util.MemberContext;
import oracle.dss.util.NameConverter;
import oracle.dss.util.Utility;
import oracle.dss.util.VectorClone;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.persistence.XMLizable;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class QDRMember
implements VectorClone,
XMLizable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FIXED = 0;
    public static final int VARIES = 1;
    public static final int CURRENT = 2;
    public static final int LIST = 3;
    public static final int TOTAL = 4;
    public static final int AGG = 5;
    protected static final String XML_VARIES = "VARIES";
    protected static final String XML_CURRENT = "CURRENT";
    protected static final String XML_TOTAL = "TOTAL";
    protected static final String XML_AGG = "AGG";
    protected int m_intType = 0;
    protected Object m_data;
    public static final String XML_NAME = "QDRMem";
    public static final String XML_NAME_NEW = "dvt-cube:QDRMem";
    public static final String XML_LIST_NAME = "ListQDRMem";
    private static final String TYPE_PROPERTY = "memType";
    private static final String DATA_PROPERTY = "Data";
    private static final String MEMBER_PROPERTY = "mem";
    private static final String MEMBER_DATATYPE_PROPERTY = "memDataType";
    private static final String LIST_MEMBER_PROPERTY = "ListMem";
    private static final String XML_FIXED = "FIXED";
    private static final String XML_LIST = "LIST";
    private static boolean DEBUG = false;

    public QDRMember() {
    }

    public QDRMember(int type) {
        this.setType(type);
    }

    public QDRMember(String dimMember) {
        this.setData(dimMember);
        this.setType(0);
    }

    public QDRMember(int type, Object data) {
        this.setType(type);
        this.setData(data);
    }

    public int hashCode() {
        switch (this.getType()) {
            case 0: 
            case 4: 
            case 5: {
                return this.m_data == null ? 0 : this.m_data.hashCode();
            }
            case 3: {
                if (!(this.m_data instanceof Vector)) break;
                int code = 0;
                Object obj = null;
                Enumeration elems = ((Vector)this.m_data).elements();
                while (elems.hasMoreElements()) {
                    obj = elems.nextElement();
                    if (obj == null) continue;
                    code += obj.hashCode();
                }
                return code;
            }
            default: {
                return this.getType();
            }
        }
        return 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        QDRMember newQDRMember = null;
        try {
            newQDRMember = (QDRMember)this.getClass().newInstance();
        }
        catch (Exception e) {
            return null;
        }
        if (this.m_data != null) {
            if (this.m_data instanceof Vector) {
                newQDRMember.setData(((Vector)this.m_data).clone());
            } else if (this.m_data instanceof String) {
                newQDRMember.setData(new String((String)this.m_data));
            } else {
                newQDRMember.setData(this.m_data);
            }
        }
        newQDRMember.setType(this.m_intType);
        return newQDRMember;
    }

    public boolean equals(QDRMember qdrMember) {
        if (qdrMember != null && this.getType() == qdrMember.getType()) {
            if (this.getType() == 4) {
                return true;
            }
            Object data = this.getData();
            Object cmpData = qdrMember.getData();
            if (data == null && cmpData == null) {
                return true;
            }
            if (data != null && cmpData != null) {
                if (data.equals(cmpData)) {
                    return true;
                }
                if (this.getType() == 3 && data instanceof Vector && cmpData instanceof Vector) {
                    Vector vData = (Vector)data;
                    Vector vCmpData = (Vector)cmpData;
                    return vData.size() == vCmpData.size() && this.contains(vData, vCmpData);
                }
            }
        }
        return false;
    }

    protected boolean contains(Vector vector1, Vector vector2) {
        if (vector1.size() < vector2.size()) {
            return false;
        }
        Enumeration e = vector2.elements();
        while (e.hasMoreElements()) {
            if (vector1.contains(e.nextElement())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(QDRMember qdrMember) {
        if (qdrMember == null) {
            return false;
        }
        if (this.getType() == 1) {
            return true;
        }
        if (this.equals(qdrMember)) {
            return true;
        }
        int cmpType = qdrMember.getType();
        if (this.getType() == 3 && this.m_data instanceof Vector) {
            Vector vData = (Vector)this.m_data;
            Object cmpData = qdrMember.getData();
            if (cmpData != null) {
                if (cmpType == 3 && cmpData instanceof Vector) {
                    return this.contains(vData, (Vector)cmpData);
                }
                if (cmpType == 0 || cmpType == 4 || cmpType == 5) {
                    return vData.contains(cmpData);
                }
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QDRMember) {
            return this.equals((QDRMember)obj);
        }
        return false;
    }

    public String toString() {
        String output = "";
        switch (this.m_intType) {
            case 0: 
            case 3: 
            case 5: {
                if (this.m_data == null) break;
                output = output + this.m_data.toString();
                break;
            }
            case 1: {
                output = output + XML_VARIES;
                break;
            }
            case 2: {
                output = output + XML_CURRENT;
                break;
            }
            case 4: {
                output = output + XML_TOTAL;
            }
        }
        return output;
    }

    public void setType(int type) {
        this.m_intType = type;
    }

    public int getType() {
        return this.m_intType;
    }

    public void setData(Object newData) {
        this.m_data = newData;
    }

    public Object getData() {
        return this.m_data;
    }

    public Vector getAllDependentIDs(String measDim, NameConverter nc) {
        if (this.m_data == null) {
            return null;
        }
        Vector<Object> depIDs = new Vector<Object>();
        switch (this.m_intType) {
            case 0: 
            case 4: 
            case 5: {
                depIDs.addElement(this.m_data);
                break;
            }
            case 3: {
                if (!(this.m_data instanceof Vector)) break;
                Enumeration elems = ((Vector)this.m_data).elements();
                while (elems.hasMoreElements()) {
                    depIDs.addElement(elems.nextElement());
                }
                break;
            }
        }
        return depIDs.size() == 0 ? null : depIDs;
    }

    @Override
    public Object getXML(XMLContext context) {
        String name;
        ObjectScope scope;
        IDResolver resolver = null;
        boolean allProperties = true;
        if (context != null && (scope = context.getScope()) != null) {
            resolver = (IDResolver)scope.getObject("PersistableIDResolver");
            Boolean allprops = (Boolean)scope.getObject("allProperties");
            if (allprops != null) {
                allProperties = allprops;
            }
        }
        String string = name = this.m_intType == 3 ? XML_LIST_NAME : XML_NAME;
        if (this.m_intType != 3) {
            ObjectNode node = new ObjectNode("dvt-cube:" + name);
            if (allProperties || this.getType() == 1 || this.getType() == 2) {
                node.addProperty(TYPE_PROPERTY, this.convertTypeIntToString(this.getType()));
            }
            if (this.m_data != null) {
                if (this.m_data instanceof String) {
                    node.addProperty(MEMBER_PROPERTY, (String)this.m_data);
                } else {
                    Utility.PropertyType.storeData(node, this.m_data, MEMBER_PROPERTY, MEMBER_DATATYPE_PROPERTY);
                }
            }
            return node;
        }
        ContainerNode root = new ContainerNode("dvt-cube:" + name);
        if (this.m_data != null && this.m_data instanceof Vector) {
            Enumeration members = ((Vector)this.m_data).elements();
            while (members.hasMoreElements()) {
                String member = (String)members.nextElement();
                ObjectNode child = new ObjectNode(LIST_MEMBER_PROPERTY);
                child.addProperty("name", LIST_MEMBER_PROPERTY.toLowerCase());
                child.addProperty("value", member);
                root.addContainedObject(child);
            }
        }
        return root;
    }

    @Override
    public void setXML(XMLContext context, Object node) {
        if (node instanceof ObjectNode) {
            ObjectNode objNode = (ObjectNode)node;
            PropertyNode pNode = objNode.getProperty(TYPE_PROPERTY);
            if (pNode == null) {
                pNode = objNode.getProperty("dvt-cube:memType");
            }
            if (pNode != null) {
                this.setType(this.convertTypeStringToInt(pNode.getValueAsString()));
            } else {
                this.setType(0);
            }
            pNode = objNode.getProperty(MEMBER_PROPERTY);
            if (pNode == null) {
                pNode = objNode.getProperty("dvt-cube:mem");
            }
            if (pNode != null) {
                String type = null;
                PropertyNode dataTypeNode = objNode.getProperty(MEMBER_DATATYPE_PROPERTY);
                if (dataTypeNode == null) {
                    dataTypeNode = objNode.getProperty("dvt-cube:memDataType");
                }
                if (dataTypeNode != null) {
                    type = dataTypeNode.getValueAsString();
                }
                this.setData(Utility.PropertyType.getData(pNode.getValueAsString(), type));
            }
        } else {
            ContainerNode containerNode = (ContainerNode)node;
            this.setType(3);
            this.m_data = new Vector();
            Enumeration members = containerNode.getPropertyNodes(LIST_MEMBER_PROPERTY);
            if (!members.hasMoreElements()) {
                members = containerNode.getPropertyNodes("dvt-cube:ListMem");
            }
            while (members.hasMoreElements()) {
                PropertyNode memberNode = (PropertyNode)members.nextElement();
                ((Vector)this.m_data).addElement(memberNode.getValueAsString());
            }
        }
    }

    @Override
    public String getTagName() {
        if (this.m_intType == 3) {
            return XML_LIST_NAME;
        }
        return XML_NAME;
    }

    protected String convertTypeIntToString(int type) {
        String strType = XML_FIXED;
        switch (type) {
            case 5: {
                strType = XML_AGG;
            }
            case 4: {
                strType = XML_TOTAL;
            }
            case 0: {
                strType = XML_FIXED;
                break;
            }
            case 1: {
                strType = XML_VARIES;
                break;
            }
            case 2: {
                strType = XML_CURRENT;
                break;
            }
            case 3: {
                strType = XML_LIST;
            }
        }
        return strType;
    }

    protected int convertTypeStringToInt(String strType) {
        if (strType.equals(XML_FIXED)) {
            return 0;
        }
        if (strType.equals(XML_VARIES)) {
            return 1;
        }
        if (strType.equals(XML_CURRENT)) {
            return 2;
        }
        if (strType.equals(XML_LIST)) {
            return 3;
        }
        if (strType.equals(XML_TOTAL)) {
            return 4;
        }
        if (strType.equals(XML_AGG)) {
            return 5;
        }
        return -1;
    }

    public String getStateString(MemberContext memberContext) {
        StringBuffer buffer = new StringBuffer();
        switch (this.getType()) {
            case 0: {
                if (this.getData() == null) break;
                this.addMember(memberContext, buffer, this.getData().toString());
                break;
            }
            case 3: {
                if (!(this.getData() instanceof Vector)) break;
                Vector memList = (Vector)this.getData();
                boolean first = true;
                for (int i = 0; i < memList.size(); ++i) {
                    if (!first) {
                        buffer.append(MemberContext.MEMBER_SEPARATOR_S);
                    }
                    first = false;
                    this.addMember(memberContext, buffer, (String)memList.elementAt(i));
                }
                break;
            }
        }
        return buffer.toString();
    }

    private void addMember(MemberContext context, StringBuffer buffer, String member) {
        if (member != null) {
            int memIndex = context.getMemberIndex(member);
            buffer.append(memIndex);
            if (DEBUG) {
                System.out.println(member + ": " + memIndex);
            }
        }
    }
}

