/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.util.Comparison;
import oracle.dss.util.HierarchicalQDRMember;
import oracle.dss.util.IDResolver;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.Utility;
import oracle.dss.util.VectorClone;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class HierarchicalQDR
extends QDR
implements VectorClone {
    private static final long serialVersionUID = 1L;
    public static final String XML_NAME_OLAP = "OlapQDR";
    protected static final String MEASURE_DIM_NAME_PROPERTY = "MeasureDimName";
    private static final String DIM_MEMBER_PAIR_PROPERTY = "DimMemberPair";
    protected static final String DIMENSION_PROPERTY = "Dimension";
    protected static final String TARGET_PROPERTY = "QDRTarget";
    protected HierarchicalQDRMember m_target = null;
    protected HierarchicalQDRMember m_memberVaries = this.createVariesMember();

    public HierarchicalQDR() {
    }

    public HierarchicalQDR(QDR qdr) {
        this(qdr.getMeasureDim());
        Enumeration members = qdr.getDimensions();
        while (members.hasMoreElements()) {
            String dim = (String)members.nextElement();
            this.addDimMemberPair(dim, new HierarchicalQDRMember(qdr.getDimMember(dim).getType(), qdr.getDimMember(dim).getData(), null, null));
        }
        if (qdr.getTarget() != null) {
            this.setTarget(new HierarchicalQDRMember(qdr.getTarget().getType(), qdr.getTarget().getData(), null, null));
        }
    }

    public HierarchicalQDR(HierarchicalQDR qdr) {
        super(qdr);
    }

    public HierarchicalQDR(String measureDim) {
        super(measureDim);
    }

    public HierarchicalQDR(String measureDim, String dimMemberPairs) {
        this(measureDim);
        this.setDimMemberPairs(dimMemberPairs);
    }

    protected HierarchicalQDRMember createQDRMember() {
        return new HierarchicalQDRMember();
    }

    protected HierarchicalQDRMember createVariesMember() {
        return new HierarchicalQDRMember(1);
    }

    @Override
    public boolean isEmpty() {
        return !(this.getMeasureDim() != null && !this.getMeasureDim().equals("") || this.m_dimensions != null && this.m_dimensions.size() != 0);
    }

    @Override
    public boolean isDimensionOnlyQDR() {
        return this.size() == 1 && this.m_members.elementAt(0).equals(this.m_memberVaries);
    }

    @Override
    public void addDimMemberPair(String dimension, String member) {
        HierarchicalQDRMember qdrMember = null;
        if (member != null) {
            qdrMember = this.createQDRMember();
            qdrMember.setData(member);
        } else {
            qdrMember = this.m_memberVaries;
        }
        this.addDimMemberPair(dimension, qdrMember);
    }

    public void addDimMemberPair(String dim, HierarchicalQDRMember member) {
        this.addDimMemberPair(dim, member, true);
    }

    public void addIncrementalDimMemberPair(String dim, HierarchicalQDRMember member) {
        this.addDimMemberPair(dim, member, false);
    }

    private void addDimMemberPair(String dim, HierarchicalQDRMember member, boolean dimensionOnlyCheck) {
        if (dim == null) {
            return;
        }
        if (member == null) {
            member = this.m_memberVaries;
        }
        if (dimensionOnlyCheck && this.isDimensionOnlyQDR()) {
            this.m_dimensions.setElementAt(dim, 0);
        } else {
            int index = this.m_dimensions.indexOf(dim);
            if (index >= 0) {
                this.m_members.setElementAt(member, index);
            } else {
                this.m_dimensions.addElement(dim);
                this.m_members.addElement(member);
            }
        }
    }

    public void addDimMemberPair(String dimension, String member, String hierarchy, String level) {
        HierarchicalQDRMember qdrMember = null;
        if (member != null) {
            qdrMember = this.createQDRMember();
            qdrMember.setData(member);
            qdrMember.setHierarchy(hierarchy);
            qdrMember.setLevel(level);
        } else {
            qdrMember = this.m_memberVaries;
        }
        this.addDimMemberPair(dimension, qdrMember);
    }

    public void setDimMemberPairs(String[] dimensions, HierarchicalQDRMember[] members) {
        if (dimensions == null || members == null || dimensions.length != members.length) {
            return;
        }
        this.m_dimensions.removeAllElements();
        this.m_members.removeAllElements();
        for (int i = 0; i < dimensions.length; ++i) {
            if (dimensions[i] == null) continue;
            this.addIncrementalDimMemberPair(dimensions[i], members[i]);
        }
    }

    @Override
    public void setDimMemberPairs(String dimMemberPairs) {
        if (dimMemberPairs != null) {
            boolean oneString = true;
            if ((dimMemberPairs = this.replaceSeparator(dimMemberPairs, "::", "\u0001\u0001")).indexOf(59) != -1 || dimMemberPairs.indexOf(58) != -1) {
                oneString = false;
            }
            if (!oneString) {
                StringTokenizer pairs = new StringTokenizer(dimMemberPairs, String.valueOf(';'));
                while (pairs.hasMoreTokens()) {
                    String level;
                    String hierarchy;
                    String member;
                    String dim;
                    StringTokenizer tokens = new StringTokenizer(pairs.nextToken(), String.valueOf(':'));
                    if (tokens.countTokens() == 2) {
                        dim = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        member = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        this.addDimMemberPair(dim, member);
                        continue;
                    }
                    if (tokens.countTokens() == 3) {
                        dim = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        member = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        hierarchy = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        this.addDimMemberPair(dim, member, hierarchy, null);
                        continue;
                    }
                    if (tokens.countTokens() == 4) {
                        dim = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        member = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        hierarchy = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        level = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        this.addDimMemberPair(dim, member, hierarchy, level);
                        continue;
                    }
                    if (tokens.countTokens() == 5) {
                        dim = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::") + ':' + this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        member = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        hierarchy = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        level = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        this.addDimMemberPair(dim, member, hierarchy, level);
                        continue;
                    }
                    if (tokens.countTokens() == 6) {
                        dim = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::") + ':' + this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        member = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        hierarchy = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::") + ':' + this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        level = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                        this.addDimMemberPair(dim, member, hierarchy, level);
                        continue;
                    }
                    if (tokens.countTokens() != 7) continue;
                    dim = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::") + ':' + this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                    member = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                    hierarchy = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::") + ':' + this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                    level = this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::") + ':' + this.replaceSeparator(tokens.nextToken(), "\u0001\u0001", "::");
                    this.addDimMemberPair(dim, member, hierarchy, level);
                }
            } else {
                this.addDimMemberPair(this.replaceSeparator(dimMemberPairs, "\u0001\u0001", "::"), this.m_memberVaries);
            }
        }
    }

    @Override
    public String getDimMemberPairs() {
        if (this.isDimensionOnlyQDR()) {
            return (String)this.m_dimensions.elementAt(0);
        }
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        Enumeration keys = this.m_dimensions.elements();
        Enumeration values = this.m_members.elements();
        while (keys.hasMoreElements()) {
            HierarchicalQDRMember qdrMember;
            String dim = (String)keys.nextElement();
            Object member = values.nextElement();
            if (member != null && (qdrMember = (HierarchicalQDRMember)member).getType() == 0) {
                Object data = qdrMember.getData();
                Object hier = qdrMember.getHierarchy();
                Object level = qdrMember.getLevel();
                if (data != null) {
                    if (!first) {
                        buffer.append(';');
                    }
                    buffer.append(dim);
                    buffer.append(':');
                    buffer.append(data.toString());
                    if (hier != null) {
                        buffer.append(':');
                        buffer.append(hier.toString());
                        if (level != null) {
                            buffer.append(':');
                            buffer.append(level.toString());
                        }
                    } else if (level != null) {
                        buffer.append(116);
                        buffer.append(level.toString());
                    }
                }
            }
            first = false;
        }
        return buffer.toString();
    }

    public Vector getAsymmetricDimensions(String dimension) {
        Vector<String> dims = new Vector<String>();
        Enumeration e = this.getDimensions();
        while (e.hasMoreElements()) {
            String strQDRDimension = (String)e.nextElement();
            if (strQDRDimension.equals(dimension) || this.getDimMember(strQDRDimension).getType() != 1 || dims.contains(strQDRDimension)) continue;
            dims.add(strQDRDimension);
        }
        return dims;
    }

    public QDR makeQDR() {
        QDR copy = new QDR();
        copy.setMeasureDim(this.m_measureDim);
        Enumeration members = this.m_dimensions.elements();
        while (members.hasMoreElements()) {
            String dim = (String)members.nextElement();
            copy.addDimMemberPair(dim, this.getDimMember(dim));
        }
        if (this.m_target != null) {
            copy.setTarget(new QDRMember(this.m_target.getType(), this.m_target.getData()));
        }
        return copy;
    }

    protected static boolean contains(HierarchicalQDR qdr1, HierarchicalQDR qdr2, Comparison comparator) {
        if (qdr1 == null || qdr2 == null) {
            return false;
        }
        if (qdr1.size() == 0) {
            return true;
        }
        Enumeration dimensions = qdr1.getDimensions();
        int index = 0;
        while (dimensions.hasMoreElements()) {
            HierarchicalQDRMember member2;
            HierarchicalQDRMember member1 = (HierarchicalQDRMember)qdr1.m_members.elementAt(index);
            if (!member1.contains(member2 = (HierarchicalQDRMember)qdr2.getDimMember((String)dimensions.nextElement()), comparator)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean equals(HierarchicalQDR q2, Comparison comparator) {
        if (q2 == null) {
            return false;
        }
        if (this.isDimensionOnlyQDR()) {
            return q2.isDimensionOnlyQDR() && this.m_dimensions.elementAt(0).equals(q2.m_dimensions.elementAt(0));
        }
        return HierarchicalQDR.contains(this, q2, comparator) && HierarchicalQDR.contains(q2, this, comparator);
    }

    public boolean equals(HierarchicalQDR q2) {
        return this.equals(q2, null);
    }

    @Override
    public boolean equals(QDR qdr) {
        return super.equals(qdr);
    }

    public boolean equals(Object obj, Comparison comparator) {
        if (obj != null && obj instanceof HierarchicalQDR) {
            return this.equals((HierarchicalQDR)obj, comparator);
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof HierarchicalQDR) {
            return this.equals((HierarchicalQDR)obj);
        }
        return super.equals(obj);
    }

    public boolean isProperSupersetOf(HierarchicalQDR q2, Comparison comparator) {
        return HierarchicalQDR.contains(this, q2, comparator) && !HierarchicalQDR.contains(q2, this, comparator);
    }

    public boolean isProperSupersetOf(HierarchicalQDR q2) {
        return this.isProperSupersetOf(q2, null);
    }

    public boolean isProperSubsetOf(HierarchicalQDR q2, Comparison comparator) {
        return HierarchicalQDR.contains(q2, this, comparator) && !HierarchicalQDR.contains(this, q2, comparator);
    }

    public boolean isProperSubsetOf(HierarchicalQDR q2) {
        return this.isProperSubsetOf(q2, null);
    }

    public boolean isSubsetOf(HierarchicalQDR q2, Comparison comparator) {
        return HierarchicalQDR.contains(q2, this, comparator);
    }

    public boolean isSubsetOf(HierarchicalQDR q2) {
        return this.isSubsetOf(q2, null);
    }

    public boolean isSupersetOf(HierarchicalQDR q2, Comparison comparator) {
        return HierarchicalQDR.contains(this, q2, comparator);
    }

    public boolean isSupersetOf(HierarchicalQDR q2) {
        return this.isSupersetOf(q2, null);
    }

    @Override
    public String getTagName() {
        return XML_NAME_OLAP;
    }

    protected String getDimMemberPairTag() {
        return DIM_MEMBER_PAIR_PROPERTY;
    }

    @Override
    public Object getXML(XMLContext context) {
        ObjectScope scope;
        IDResolver resolver = null;
        boolean allProperties = true;
        String measDim = null;
        if (context != null && (scope = context.getScope()) != null) {
            resolver = (IDResolver)scope.getObject("PersistableIDResolver");
            Boolean allprops = (Boolean)scope.getObject("allProperties");
            if (allprops != null) {
                allProperties = allprops;
            }
            measDim = (String)scope.getObject("MeasDimName");
        }
        ContainerNode root = new ContainerNode(this.getTagName());
        root.addProperty(MEASURE_DIM_NAME_PROPERTY, this.getMeasureDim());
        Enumeration dimensions = this.getDimensions();
        while (dimensions.hasMoreElements()) {
            ObjectNode dimMemberPairNode = new ObjectNode(this.getDimMemberPairTag());
            String dimension = (String)dimensions.nextElement();
            dimMemberPairNode.addProperty(DIMENSION_PROPERTY, dimension);
            HierarchicalQDRMember member = (HierarchicalQDRMember)this.getDimMember(dimension);
            if (member != null) {
                ContainerNode qdrMemberNode = (ContainerNode)member.getXML(context);
                dimMemberPairNode.addContainer(qdrMemberNode);
            }
            root.addContainedObject(dimMemberPairNode);
        }
        if (measDim == null) {
            measDim = this.m_measureDim;
        }
        Utility.setDependentID(context, this.getQDRMeasures(measDim, context), false, null);
        if (this.m_target != null) {
            ObjectNode targetObject = new ObjectNode(TARGET_PROPERTY);
            targetObject.addContainer((ContainerNode)this.m_target.getXML(context));
            root.addContainedObject(targetObject);
        }
        return root;
    }

    @Override
    public void setXML(XMLContext xmlContext, Object objectNode) {
        ContainerNode qdrNode = (ContainerNode)objectNode;
        try {
            Enumeration targets;
            Vector oldMeas;
            Vector newMeas;
            this.m_measureDim = qdrNode.getPropertyValueAsString(MEASURE_DIM_NAME_PROPERTY);
            Enumeration dimMemberPairs = qdrNode.getContainedObject(this.getDimMemberPairTag());
            while (dimMemberPairs.hasMoreElements()) {
                ObjectNode dimMemberPairNode = (ObjectNode)dimMemberPairs.nextElement();
                String dimension = dimMemberPairNode.getPropertyValueAsString(DIMENSION_PROPERTY);
                HierarchicalQDRMember member = this.createQDRMember();
                ContainerNode qdrMemberNode = dimMemberPairNode.getContainer(member.getTagName());
                if (qdrMemberNode == null) {
                    qdrMemberNode = dimMemberPairNode.getContainer("ListOlapQDRMember");
                }
                if (qdrMemberNode == null) continue;
                member.setXML(xmlContext, qdrMemberNode);
                this.addDimMemberPair(dimension, member);
            }
            String measDim = Utility.getMeasureDimName(xmlContext);
            if (measDim == null) {
                measDim = this.m_measureDim;
            }
            if ((newMeas = Utility.getDependentID(xmlContext, oldMeas = this.getQDRMeasures(measDim, xmlContext), false, null)) != null) {
                this.setQDRMeasures(measDim, newMeas, xmlContext);
            }
            if ((targets = qdrNode.getContainedObject(TARGET_PROPERTY)) != null && targets.hasMoreElements()) {
                HierarchicalQDRMember member = this.createQDRMember();
                ObjectNode target = (ObjectNode)targets.nextElement();
                member.setXML(xmlContext, target.getContainer("OlapQDRMember"));
                this.setTarget(member);
            } else {
                this.setTarget(null);
            }
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
    }
}

