/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dss.util.BIException;
import oracle.dss.util.ErrorHandler;

public class DefaultErrorHandler
implements ErrorHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SHOW_NONE = 0;
    public static final int SHOW_ERROR = 2;
    public static final int SHOW_LOG = 4;
    public static final int SHOW_TRACE = 8;
    public static final int SHOW_ALL = 255;
    private int m_mode = 255;
    private static final String LOGGER_NAME = "DVTLogger";

    public void setDebugMode(int mode) {
        if ((mode & 4) > 0 || (mode & 8) > 0 || (mode & 2) > 0 || mode == 0 || mode == 255) {
            this.m_mode = mode;
        }
    }

    public int getDebugMode() {
        return this.m_mode;
    }

    public void resetDebugMode() {
        this.m_mode = 255;
    }

    @Override
    public void error(Throwable e, String _class, String routine) {
        if ((this.m_mode & 2) > 0 || this.m_mode == 255) {
            Logger.getLogger(LOGGER_NAME).logp(Level.SEVERE, _class, routine, "", e);
            if (e instanceof BIException) {
                ((BIException)((Object)e)).getBIRootCause().printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void log(String message, String _class, String routine) {
        if ((this.m_mode & 4) > 0 || this.m_mode == 255) {
            Logger.getLogger(LOGGER_NAME).logp(Level.FINE, _class, routine, message);
        }
    }

    @Override
    public void trace(String message, String _class, String routine) {
        if ((this.m_mode & 8) > 0 || this.m_mode == 255) {
            Logger.getLogger(LOGGER_NAME).logp(Level.FINE, _class, routine, message);
        }
    }

    protected String getDate() {
        return new Date().toString();
    }
}

