/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.List;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class NumberValueDiscriminator
extends ValueDiscriminator
implements DiscriminatorState {
    private static final long serialVersionUID = 1L;
    private double m_number;
    protected static final String S_NAME_NUM_VAL_DISC = "ND";
    protected static final String s_number = "n";
    public static final String NAME_NUM_VAL_DISC = "NumValDisc";
    protected static final String a_number = "num";

    public NumberValueDiscriminator() {
    }

    public NumberValueDiscriminator(double number, int relationalOperator) {
        super(relationalOperator);
        this.m_number = number;
    }

    @Override
    public Object clone() {
        return new NumberValueDiscriminator(this.m_number, this.m_relOperator);
    }

    public void setNumber(double d) {
        this.m_number = d;
    }

    public double getNumber() {
        return this.m_number;
    }

    @Override
    public boolean applies(RuleContext context) {
        Number contextNumber = (Number)context.get("NUMBER_VALUE");
        if (contextNumber == null) {
            return false;
        }
        double value = contextNumber.doubleValue();
        switch (this.m_relOperator) {
            case 0: {
                return value == this.m_number;
            }
            case 1: {
                return value < this.m_number;
            }
            case 2: {
                return value <= this.m_number;
            }
            case 3: {
                return value > this.m_number;
            }
            case 4: {
                return value >= this.m_number;
            }
            case 5: {
                return value != this.m_number;
            }
        }
        return value == this.m_number;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NumberValueDiscriminator)) {
            return false;
        }
        NumberValueDiscriminator nvd = (NumberValueDiscriminator)o;
        return this.getNumber() == nvd.getNumber() && this.getRelOperator() == nvd.getRelOperator();
    }

    @Override
    public boolean setXML(ObjectNode node, ComponentTypeConverter converter, String version, int reset) {
        PropertyNode pNode = node.getProperty("relOp");
        if (pNode != null) {
            String tmp = pNode.getValueAsString();
            this.setRelOperator(this.convertRelOperatorToInt(tmp));
        }
        if ((pNode = node.getProperty(a_number)) != null) {
            this.setNumber(pNode.getValueAsDouble());
        }
        return true;
    }

    @Override
    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter converter, boolean emptyElement) {
        ObjectNode node = new ObjectNode(NAME_NUM_VAL_DISC);
        node.addProperty("relOp", this.convertRelOperatorToString(this.getRelOperator()));
        node.addProperty(a_number, this.m_number);
        return node;
    }

    @Override
    public void setStateAsObjectNode(List context, ObjectNode node, DiscriminatorState baseState) {
        NumberValueDiscriminator baseDisc;
        PropertyNode pNode = node.getProperty("r");
        NumberValueDiscriminator numberValueDiscriminator = baseDisc = baseState instanceof NumberValueDiscriminator ? (NumberValueDiscriminator)baseState : null;
        if (pNode != null) {
            this.setRelOperator(pNode.getValueAsInteger());
        } else if (baseDisc != null) {
            this.setRelOperator(baseDisc.getRelOperator());
        } else {
            this.setRelOperator(0);
        }
        pNode = node.getProperty(s_number);
        if (pNode != null) {
            this.setNumber(pNode.getValueAsDouble());
        } else if (baseDisc != null) {
            this.setNumber(baseDisc.getNumber());
        } else {
            this.setNumber(0.0);
        }
    }

    @Override
    public ObjectNode getStateAsObjectNode(List memberContext, DiscriminatorState baseState) {
        NumberValueDiscriminator baseDisc;
        ObjectNode node = new ObjectNode(S_NAME_NUM_VAL_DISC);
        boolean nodeExists = false;
        NumberValueDiscriminator numberValueDiscriminator = baseDisc = baseState instanceof NumberValueDiscriminator ? (NumberValueDiscriminator)baseState : new NumberValueDiscriminator();
        if (baseDisc.getRelOperator() != this.getRelOperator()) {
            node.addProperty("r", this.getRelOperator());
            nodeExists = true;
        }
        if (baseDisc.getNumber() != this.getNumber()) {
            node.addProperty(s_number, this.getNumber());
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }
}

