/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.total;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.EdgeTreeNode;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.RowIterator;
import oracle.adf.model.dvt.util.transform.RowProjection;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.total.AggLocation;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.ColumnValue;
import oracle.adfinternal.model.dvt.util.transform.ColumnValues;
import oracle.adfinternal.model.dvt.util.transform.Cube;
import oracle.adfinternal.model.dvt.util.transform.DataTable;
import oracle.adfinternal.model.dvt.util.transform.Filter;
import oracle.adfinternal.model.dvt.util.transform.PairRowIteratorImpl;
import oracle.adfinternal.model.dvt.util.transform.ProjectionInfo;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.adfinternal.model.dvt.util.transform.ResultTable;
import oracle.adfinternal.model.dvt.util.transform.Row;
import oracle.adfinternal.model.dvt.util.transform.RowBasedCubicDataAccess;
import oracle.adfinternal.model.dvt.util.transform.RowInfo;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.adfinternal.model.dvt.util.transform.total.AggColumn;
import oracle.adfinternal.model.dvt.util.transform.total.AggMethod;
import oracle.adfinternal.model.dvt.util.transform.total.AggSpec;
import oracle.adfinternal.model.dvt.util.transform.total.AggWhat;
import oracle.adfinternal.model.dvt.util.transform.total.Distributor;
import oracle.adfinternal.model.dvt.util.transform.total.TotalData;
import oracle.adfinternal.model.dvt.util.transform.total.TotalMember;
import oracle.sql.NUMBER;

class TotalRow
extends Row {
    private AggSpec m_spec;
    private ProjectionInfo m_projection;
    private long m_aggedRowCount;
    private Map<Row, Boolean> m_rowsSeen = new HashMap<Row, Boolean>();
    private RowInfo[] m_column;
    private RowInfo[] m_row;
    private Cube.PageRowInfo m_pri;
    private Row m_customRow = null;

    public TotalRow(Row row, ProjectionInfo projection, AggSpec spec) throws TransformException {
        this(row.getDataTable());
        this.m_spec = spec;
        this.m_projection = projection;
        this.setMembers(this.getTotalMembers(row.getMembers(), spec));
        this.setCells(this.getTotalCells(row));
    }

    private void _setLocation(RowInfo[] column, RowInfo[] row, Cube.PageRowInfo pri) {
        this.m_column = column;
        this.m_row = row;
        this.m_pri = pri;
    }

    private boolean _replaceWithTotal(String column, Object currMeas, String measDim) throws TransformException {
        Filter[] filters = this.getAggFilter(column);
        if (filters == null || filters.length == 0) {
            return false;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null || !filters[i].filter(this, measDim, currMeas)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void setLocation(RowInfo[] column, RowInfo[] row, Cube.PageRowInfo pri) {
        this._setLocation(column, row, pri);
        this.cleanUp();
    }

    @Override
    protected boolean above() {
        return this.getAggLocation() == AggLocation.BEFORE;
    }

    @Override
    protected boolean replace(MemberInterface member, boolean inserting, String colName, Object currMeas, String measDim) throws TransformException {
        return member instanceof TotalMember && !inserting && this._replaceWithTotal(colName, currMeas, measDim);
    }

    @Override
    public boolean isCalculatedValue() {
        return true;
    }

    protected TotalRow(DataTable dt) {
        super(dt);
    }

    @Override
    public void release() {
        if (this.m_spec != null) {
            this.m_spec.release();
        }
        this.m_spec = null;
        this.m_projection = null;
        this.cleanUp();
        super.release();
    }

    private boolean mustKeepRowCol() {
        if (this.m_spec == null) {
            return false;
        }
        AggMethod[] methods = this.m_spec.getAggMethods();
        if (methods != null) {
            for (int m = 0; m < methods.length; ++m) {
                if (!methods[m].containsAggType(AggType.FIRST) && !methods[m].containsAggType(AggType.LAST)) continue;
                return true;
            }
        }
        return false;
    }

    private void cleanUp() {
        if (!this.mustKeepRowCol()) {
            this.m_column = null;
            this.m_row = null;
            this.m_pri = null;
        }
        this.m_rowsSeen = null;
    }

    public boolean totalDuplicates() {
        return this.m_spec.getOptions().totalDuplicates();
    }

    public AggLocation getAggLocation() {
        return this.m_spec.getOptions().getAggLocation();
    }

    public TotalData getTotalData() {
        return this.m_spec.getOptions().getTotalData();
    }

    public Filter[] getAggFilter(String column) {
        AggWhat[] cols = this.m_spec.getColumnsToAggregate();
        if (cols == null || column == null) {
            return new Filter[0];
        }
        AggColumn col = null;
        for (int i = 0; i < cols.length; ++i) {
            if (!(cols[i] instanceof AggColumn) || !column.equals((col = (AggColumn)cols[i]).getColumn())) continue;
            return col.getShowAggComponentFilters();
        }
        return new Filter[0];
    }

    public void aggregate(Row row, QDRLite groupingKey) throws TransformException {
        if (!this.totalDuplicates() && row != null) {
            Boolean val = this.m_rowsSeen.get(row);
            if (val != null) {
                return;
            }
            this.m_rowsSeen.put(row, Boolean.TRUE);
        }
        if (row.isCustom()) {
            this.m_customRow = row;
        }
        ++this.m_aggedRowCount;
        int cellCount = this.getCells().length;
        for (int i = 0; i < cellCount; ++i) {
            ((DataCellImpl)this.getCells()[i]).addCell(row.getCells()[i], groupingKey, row);
        }
    }

    public boolean include() {
        return this.m_spec.getOptions().allowSingleTotals() || this.m_aggedRowCount > 1L;
    }

    @Override
    public Object clone(DataTable dt) throws CloneNotSupportedException {
        TotalRow row = new TotalRow(dt);
        row.m_spec = this.m_spec;
        row.m_projection = this.m_projection;
        row.setMembers(this.getMembers());
        DataCellInterface[] di = this.getCells();
        DataCellInterface[] newDI = new DataCellInterface[di.length];
        for (int i = 0; i < newDI.length; ++i) {
            newDI[i] = (DataCellImpl)((DataCellImpl)di[i]).clone();
        }
        row.setCells(newDI);
        row._setLocation(this.m_column, this.m_row, this.m_pri);
        return row;
    }

    protected MemberInterface[] getTotalMembers(MemberInterface[] members, AggSpec spec) throws TransformException {
        if (members == null) {
            return new MemberInterface[0];
        }
        MemberInterface[] retVal = new MemberInterface[members.length];
        AggWhat[] aggColumns = spec.getColumnsToAggregate();
        boolean isReplacement = spec.getOptions().getAggLocation() == AggLocation.REPLACE;
        block0: for (int i = 0; i < retVal.length; ++i) {
            for (int c = 0; c < aggColumns.length; ++c) {
                if (aggColumns[c] instanceof AggColumn && ((AggColumn)aggColumns[c]).getColumn().equals((String)members[i].getMetadata("memberMetadataColumn"))) {
                    retVal[i] = new TotalMember(aggColumns[c].getMemberInterface(), isReplacement, spec.getAggMethods());
                    continue block0;
                }
                retVal[i] = members[i];
            }
        }
        return retVal;
    }

    protected DataCellInterface[] getTotalCells(Row row) throws TransformException {
        DataCellInterface[] cells;
        DataCellInterface[] dataCellInterfaceArray = cells = row != null ? row.getCells() : null;
        if (cells == null) {
            return new DataCellInterface[0];
        }
        DataCellInterface[] retVal = new DataCellInterface[cells.length];
        for (int i = 0; i < retVal.length; ++i) {
            if (cells[i] == null) continue;
            retVal[i] = new DataCellImpl(cells[i]);
        }
        return retVal;
    }

    protected class SubCubeProjectionImpl
    implements RowProjection {
        protected PairRowIteratorImpl m_iter = null;
        protected String[][] m_layout = null;
        protected MemberInterface[] m_dataItems = null;
        protected ProjectionInfo m_masterProj = null;

        public SubCubeProjectionImpl(PairRowIteratorImpl iter, String[][] layout, ProjectionInfo masterProj, MemberInterface[] dataItems) {
            this.m_iter = iter;
            this.m_layout = layout;
            this.m_masterProj = masterProj;
            this.m_dataItems = dataItems;
        }

        @Override
        public String[][] getLayout() {
            return this.m_layout;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_masterProj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_dataItems;
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            List<Map<String, Object>> pairs = this.m_iter.getPairs();
            String dataCol = null;
            String dataLayer = null;
            try {
                dataLayer = this.getDataLayer().getValue();
                dataCol = (String)keyPath.get(dataLayer);
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            for (Map<String, Object> pair : pairs) {
                Set<String> cols = keyPath.keySet();
                boolean found = true;
                for (String col : cols) {
                    if (col.equals(dataLayer) || pair.get(col).equals(keyPath.get(col))) continue;
                    found = false;
                    break;
                }
                if (!found || dataCol == null || !(pair.get(dataCol) instanceof DataCellInterface)) continue;
                return (DataCellInterface)pair.get(dataCol);
            }
            return null;
        }

        @Override
        public RowIterator getRowIterator() {
            return this.m_iter;
        }

        @Override
        public LayerInterface getLayer(String layer) {
            return TotalRow.this.m_projection.getLayer(layer);
        }

        @Override
        public String[] getIgnoredColumns() {
            return null;
        }
    }

    protected class ColVal
    extends ColumnValue {
        protected ColVal(String colName, Object value) {
            super(colName, value, 0L, false);
        }
    }

    protected class DataCellImpl
    implements DataCellInterface {
        private List<CellStruct> m_cells = new ArrayList<CellStruct>();
        protected DataCellInterface m_internalImpl = null;
        protected Map<String, LayerValue> m_layerValueMap = new HashMap<String, LayerValue>();
        protected String m_columnName = null;
        protected List<String> m_keyPaths = null;
        protected List<Object> m_rowKeys = null;
        protected List<Object> m_rowObjects = null;
        protected List<Map<String, Object>> m_aggregates = null;
        protected List<Map<String, Object>> m_pureQDRAggs = null;
        protected List<Map<String, Object>> m_postCubeAggs = null;
        private Map<String, Object> m_valCache = new HashMap<String, Object>();
        private boolean m_agged = false;
        protected static final String CELL_AGGS = "DataCellImplTotalCellAggs";
        private List<ColumnValue> m_sortedVals = new ArrayList<ColumnValue>();
        private boolean m_actualValueGotten = false;

        public DataCellImpl(DataCellInterface internal) throws TransformException {
            this.m_internalImpl = internal;
        }

        protected void integrateKeyPathAggs(CellStruct cs) throws TransformException {
            Object keyPath = cs.m_dci.getData("dataKeyPath");
            if (keyPath != null && this.m_keyPaths == null) {
                this.m_keyPaths = new ArrayList<String>();
            }
            if (keyPath instanceof List) {
                this.m_keyPaths.addAll((List)keyPath);
            } else if (keyPath instanceof String) {
                this.m_keyPaths.add((String)keyPath);
            }
            Object rowKey = cs.m_dci.getData("dataRowKey");
            if (rowKey != null && this.m_rowKeys == null) {
                this.m_rowKeys = new ArrayList<Object>();
            }
            if (rowKey instanceof List) {
                this.m_rowKeys.addAll((List)rowKey);
            } else if (rowKey != null) {
                this.m_rowKeys.add(rowKey);
            }
            Object row = cs.m_dci.getData("dataRow");
            if (row != null && this.m_rowObjects == null) {
                this.m_rowObjects = new ArrayList<Object>();
            }
            if (row instanceof List) {
                this.m_rowObjects.addAll((List)row);
            } else if (row != null) {
                this.m_rowObjects.add(row);
            }
            this.doAggregates(cs);
        }

        private void doAggregates(CellStruct cs) throws TransformException {
            if (this.m_aggregates == null) {
                this.m_aggregates = new ArrayList<Map<String, Object>>();
            }
            if (this.m_postCubeAggs == null) {
                this.m_postCubeAggs = new ArrayList<Map<String, Object>>();
            }
            QDRLite qdr = this.getAggColumns(cs.m_row);
            qdr = this.getGroupingColumns(qdr, cs.m_groupingKey);
            try {
                Object oldValue;
                QDRLite postQDR = (QDRLite)qdr.clone();
                String meas = cs.m_groupingKey.getMeasureDim();
                if (meas != null) {
                    postQDR.addDimMemberPair(meas, cs.m_dci.getData("dataTypeColumn"));
                }
                if ((oldValue = postQDR.getDimMember("dataValue")) != null) {
                    postQDR.removeDimMemberPair("dataValue");
                    Logger.getLogger("oracle.adfinternal.model.dvt.util.transform.total").log(Level.WARNING, "dataValue=" + oldValue + " removed");
                }
                postQDR.addDimMemberPair("dataValue", cs.m_dci.getData("dataValue"));
                this.m_postCubeAggs.add(postQDR);
            }
            catch (CloneNotSupportedException e) {
                throw new TransformException(e.getMessage(), e);
            }
            Object subaggs = cs.m_dci.getData(CELL_AGGS);
            if (subaggs instanceof List) {
                this.m_aggregates.addAll((List)subaggs);
            } else {
                qdr.addDimMemberPair((String)cs.m_dci.getData("dataTypeColumn"), cs.m_dci);
                this.m_aggregates.add(qdr);
            }
        }

        private QDRLite getGroupingColumns(QDRLite qdr, QDRLite groupingKey) {
            List<String> cols = groupingKey.getColumns();
            if (cols == null) {
                return qdr;
            }
            Iterator<String> iter = cols.iterator();
            String col = null;
            while (iter.hasNext()) {
                col = iter.next();
                qdr.addDimMemberPair(col, groupingKey.getDimMember(col));
            }
            return qdr;
        }

        private QDRLite getAggColumns(Row row) throws TransformException {
            QDRLite qdr = new QDRLite();
            AggWhat[] aggs = TotalRow.this.m_spec.getColumnsToAggregate();
            if (aggs != null) {
                String col = null;
                for (int i = 0; i < aggs.length; ++i) {
                    if (!(aggs[i] instanceof AggColumn)) continue;
                    col = ((AggColumn)aggs[i]).getColumn();
                    MemberInterface mi = row.getMemberCell(col);
                    if (mi != null) {
                        qdr.addDimMemberPair(col, mi.getMetadata("value"));
                        continue;
                    }
                    Object val = row.getExtraMemberValue(col);
                    if (val == null) continue;
                    qdr.addDimMemberPair(col, val);
                }
            }
            return qdr;
        }

        public Object clone() throws CloneNotSupportedException {
            try {
                DataCellImpl dci = new DataCellImpl(this.m_internalImpl);
                Set<String> keySet = this.m_layerValueMap.keySet();
                Iterator<String> keyIter = keySet.iterator();
                String key = null;
                while (keyIter.hasNext()) {
                    key = keyIter.next();
                    dci.m_layerValueMap.put(key, (LayerValue)this.m_layerValueMap.get(key).clone());
                }
                dci.m_columnName = this.m_columnName;
                dci.m_keyPaths = new ArrayList<String>();
                dci.m_keyPaths.addAll(this.m_keyPaths);
                dci.m_rowKeys = new ArrayList<Object>();
                dci.m_rowKeys.addAll(this.m_rowKeys);
                dci.m_rowObjects = new ArrayList<Object>();
                dci.m_rowObjects.addAll(this.m_rowObjects);
                dci.m_aggregates = new ArrayList<Map<String, Object>>();
                dci.m_aggregates.addAll(this.m_aggregates);
                dci.m_postCubeAggs = new ArrayList<Map<String, Object>>();
                dci.m_postCubeAggs.addAll(this.m_postCubeAggs);
                dci.m_cells = new ArrayList<CellStruct>();
                dci.m_cells.addAll(this.m_cells);
                dci.m_valCache = this.m_valCache;
                return dci;
            }
            catch (TransformException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }

        private LayerValue _getLayerValue(String type) {
            if (type.equals("dataFormattedValue")) {
                return this.m_layerValueMap.get("dataValue");
            }
            return this.m_layerValueMap.get(type);
        }

        public void addCell(DataCellInterface cell, QDRLite groupingKey, Row row) {
            if (cell == null) {
                return;
            }
            this.m_cells.add(new CellStruct(cell, groupingKey, row));
        }

        private void aggregate(CellStruct cs) throws TransformException {
            this.m_columnName = (String)cs.m_dci.getData("dataTypeColumn");
            String[] layerType = TotalRow.this.m_spec.getAllDataLayers();
            block13: for (int i = 0; i < layerType.length; ++i) {
                Object newVal = cs.m_dci.getData(layerType[i]);
                LayerValue lv = this._getLayerValue(layerType[i]);
                if (lv == null) {
                    lv = new LayerValue();
                    this.m_layerValueMap.put(layerType[i], lv);
                }
                AggType aggType = this.getAggType(cs.m_groupingKey, lv, layerType[i]);
                if (lv.m_value != null && !(lv.m_value instanceof Number) && !(lv.m_value instanceof NUMBER) && aggType != AggType.COUNT) {
                    if (aggType != AggType.NONE) {
                        Logger.getLogger("oracle.adfinternal.model.dvt.util.transform.total").log(Level.WARNING, "Could not aggregate value " + lv.m_value + " of type " + lv.m_value.getClass().getName());
                    }
                    if (!lv.m_seenValue) continue;
                    lv.m_value = null;
                    continue;
                }
                if (newVal != null && !(newVal instanceof Number) && !(newVal instanceof NUMBER) && aggType != AggType.COUNT) {
                    if (aggType != AggType.NONE) {
                        Logger.getLogger("oracle.adfinternal.model.dvt.util.transform.total").log(Level.WARNING, "Could not aggregate value " + newVal + " of type " + newVal.getClass().getName());
                    }
                    if (lv.m_seenValue) continue;
                    lv.m_value = newVal;
                    lv.m_seenValue = true;
                    continue;
                }
                if (newVal != null && aggType == AggType.NONE && (newVal instanceof Number || newVal instanceof NUMBER)) {
                    if (!lv.m_seenValue) {
                        lv.m_value = newVal;
                        lv.m_seenValue = true;
                    } else {
                        lv.m_value = null;
                    }
                }
                if (i == 0) {
                    this.integrateKeyPathAggs(cs);
                }
                switch (aggType) {
                    case SUM: {
                        lv.m_value = this.sum(lv.m_value, newVal);
                        continue block13;
                    }
                    case MIN: {
                        lv.m_value = this.min(lv.m_value, newVal);
                        continue block13;
                    }
                    case MAX: {
                        lv.m_value = this.max(lv.m_value, newVal);
                        continue block13;
                    }
                    case AVERAGE: {
                        lv.m_value = this.sum(lv.m_value, newVal);
                        this.countValue(newVal, lv);
                        continue block13;
                    }
                    case COUNT: {
                        this.countValue(newVal, lv);
                        continue block13;
                    }
                    case MEDIAN: {
                        if (newVal == null) continue block13;
                        this.m_sortedVals.add(new ColVal(this.m_columnName, newVal));
                        continue block13;
                    }
                    case STDDEV: 
                    case VARIANCE: {
                        Number n;
                        if (lv.m_value2 != null && !(lv.m_value2 instanceof Number) && !(lv.m_value2 instanceof NUMBER)) {
                            return;
                        }
                        if (newVal instanceof BigInteger) {
                            n = (BigInteger)newVal;
                            lv.m_value = this.sum(lv.m_value, n);
                            if (n != null) {
                                lv.m_value2 = this.sum(lv.m_value2, ((BigInteger)n).multiply((BigInteger)n));
                            }
                        } else if (newVal instanceof BigDecimal) {
                            n = (BigDecimal)newVal;
                            lv.m_value = this.sum(lv.m_value, n);
                            if (n != null) {
                                lv.m_value2 = this.sum(lv.m_value2, ((BigDecimal)n).multiply((BigDecimal)n));
                            }
                        } else if (newVal instanceof Number) {
                            n = (Number)newVal;
                            lv.m_value = this.sum(lv.m_value, n);
                            if (n != null) {
                                double dN = n.doubleValue();
                                lv.m_value2 = this.sum(lv.m_value2, dN * dN);
                            }
                        } else if (newVal instanceof NUMBER) {
                            n = (NUMBER)newVal;
                            lv.m_value = this.sum(lv.m_value, n);
                            try {
                                if (n != null) {
                                    lv.m_value2 = this.sum(lv.m_value2, n.mul((NUMBER)n));
                                }
                            }
                            catch (SQLException e) {
                                throw new TransformException(e.getMessage(), e);
                            }
                        }
                        this.countValue(newVal, lv);
                        continue block13;
                    }
                    case FIRST: 
                    case LAST: 
                    case CUBE: {
                        continue block13;
                    }
                    case CUSTOM: {
                        lv.m_value = TotalRow.this.m_customRow == null ? null : TotalRow.this.m_customRow.getValue(this.m_columnName);
                    }
                }
            }
        }

        private boolean _isAggColumn(String[][] layout, int e, int l) {
            AggWhat[] cols = TotalRow.this.m_spec.getColumnsToAggregate();
            if (cols == null) {
                return false;
            }
            for (int i = 0; i < cols.length; ++i) {
                int[] el = cols[i].getEdgeAndLayer(layout);
                if (el == null || el.length <= 1 || el[0] != e || el[1] != l) continue;
                return true;
            }
            return false;
        }

        private String[] _getSubEdgeLayout() {
            ArrayList<String> colLayers = new ArrayList<String>();
            String[][] layout = TotalRow.this.m_projection.getLayout();
            for (int e = 0; e < layout.length; ++e) {
                if (layout[e] == null) continue;
                for (int l = 0; l < layout[e].length; ++l) {
                    if (!this._isAggColumn(layout, e, l)) continue;
                    for (int i = l; i < layout[e].length; ++i) {
                        if (colLayers.indexOf(layout[e][i]) != -1) continue;
                        colLayers.add(layout[e][i]);
                    }
                    return colLayers.toArray(new String[0]);
                }
            }
            return null;
        }

        private SubCubeProjectionImpl _getSubCubeProjection(PairRowIteratorImpl iter) throws TransformException {
            MemberInterface[] allDataItems = TotalRow.this.m_projection.getDataItems();
            MemberInterface[] dataItems = new MemberInterface[1];
            if (allDataItems != null) {
                for (int i = 0; i < allDataItems.length; ++i) {
                    if (!this.m_internalImpl.getData("dataTypeColumn").equals(allDataItems[i].getValue())) continue;
                    dataItems[0] = allDataItems[i];
                    break;
                }
            }
            String[][] newLayout = new String[][]{this._getSubEdgeLayout(), {TotalRow.this.m_projection.getDataLayer().getValue()}};
            return new SubCubeProjectionImpl(iter, newLayout, TotalRow.this.m_projection, dataItems);
        }

        private List<Map<String, Object>> _getPureQDR() throws TransformException {
            if (this.m_aggregates == null) {
                return null;
            }
            ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> qdr : this.m_aggregates) {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                Set<String> keySet = qdr.keySet();
                for (String key : keySet) {
                    if (qdr.get(key) instanceof DataCellInterface) {
                        newMap.put(key, ((DataCellInterface)qdr.get(key)).getData("dataValue"));
                        continue;
                    }
                    newMap.put(key, qdr.get(key));
                }
                retList.add(newMap);
            }
            return retList;
        }

        private List<EdgeTreeNode> getTotalMemberParentChildren() throws TransformException {
            if (TotalRow.this.getMembers() != null) {
                for (int i = 0; i < TotalRow.this.getMembers().length; ++i) {
                    if (!(TotalRow.this.getMembers()[i] instanceof TotalMember) || TotalRow.this.getMembers()[i].getEdgeTreeNode() == null) continue;
                    EdgeTreeNode etnParent = TotalRow.this.getMembers()[i].getEdgeTreeNode().getParent();
                    return etnParent != null ? etnParent.getChildren() : null;
                }
            }
            return null;
        }

        private List<Map<String, Object>> sortPostCubeAggs() throws TransformException {
            List<EdgeTreeNode> etn = this.getTotalMemberParentChildren();
            if (etn == null) {
                return this.m_postCubeAggs;
            }
            ArrayList<Map<String, Object>> pcaCopy = new ArrayList<Map<String, Object>>();
            pcaCopy.addAll(this.m_postCubeAggs);
            ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
            QDRLite qdr = null;
            for (EdgeTreeNode node : etn) {
                qdr = new QDRLite();
                qdr.addDimMemberPair(node.getLayerName(), node.getMember().getValue());
                QDRLite tempQDR = null;
                ArrayList<Map> removeList = new ArrayList<Map>();
                for (Map map : pcaCopy) {
                    tempQDR = new QDRLite(map);
                    if (!qdr.isSupersetOf(tempQDR)) continue;
                    retList.add(map);
                    removeList.add(map);
                }
                for (Map map : removeList) {
                    pcaCopy.remove(map);
                }
            }
            retList.addAll(pcaCopy);
            return retList;
        }

        @Override
        public Object getData(String type) throws TransformException {
            if (type.equals("dataIsTotal")) {
                return true;
            }
            if ((type.equals("dataKeyPath") || type.equals("dataRowKey") || type.equals("dataRow") || type.equals(CELL_AGGS) || type.equals("dataAggregates") || type.equals("aggregateCollection")) && !this.m_actualValueGotten) {
                this.getActualValue("dataValue");
            }
            if (type.equals("dataKeyPath")) {
                return this.m_keyPaths;
            }
            if (type.equals("dataRowKey")) {
                return this.m_rowKeys;
            }
            if (type.equals("dataRow")) {
                return this.m_rowObjects;
            }
            if (type.equals(CELL_AGGS)) {
                return this.m_aggregates;
            }
            if (type.equals("dataAggregates")) {
                if (this.m_pureQDRAggs == null) {
                    this.m_pureQDRAggs = this._getPureQDR();
                }
                return this.m_pureQDRAggs;
            }
            if (type.equals("aggregateCollection")) {
                return this.sortPostCubeAggs();
            }
            if (type.equals("aggType")) {
                LayerValue lv = this._getLayerValue("dataValue");
                if (lv != null && lv.m_aggType != null) {
                    return lv.m_aggType.toString();
                }
                return AggType.NONE.toString();
            }
            return this.getActualValue(type);
        }

        private Object cacheIt(Object value, String type) {
            this.m_valCache.put(type, value == null ? TransformUtils.m_nullMarker : value);
            return value;
        }

        private Object getActualValue(String type) throws TransformException {
            LayerValue lv;
            this.m_actualValueGotten = true;
            Object val = this.m_valCache.get(type);
            if (val != null) {
                return val instanceof TransformUtils.NullMarker ? null : val;
            }
            if (!this.m_agged) {
                for (CellStruct cs : this.m_cells) {
                    this.aggregate(cs);
                }
                this.m_agged = true;
            }
            if ((lv = this._getLayerValue(type)) != null) {
                TotalData totalData;
                switch (lv.m_aggType) {
                    case FIRST: 
                    case LAST: {
                        QDRLite qdr = this._buildFirstLastQDR(lv.m_aggType);
                        DataCellInterface ci = TotalRow.this.m_projection.getData(qdr);
                        if (ci != null) {
                            return ci.getData(type);
                        }
                        return null;
                    }
                    case CUBE: {
                        if (this.m_aggregates != null) {
                            PairRowIteratorImpl iter = new PairRowIteratorImpl(this.m_aggregates);
                            if (type.equals("dataFormattedValue")) {
                                return this.cacheIt(new RowBasedCubicDataAccess(new ResultTable(this._getSubCubeProjection(iter))), type);
                            }
                            return this.cacheIt(iter, type);
                        }
                        return this.cacheIt(null, type);
                    }
                    case AVERAGE: {
                        TotalData totalData2;
                        if (lv.m_value instanceof String) {
                            return this.cacheIt(null, type);
                        }
                        Object retVal = this.div(lv.m_value, lv.m_count);
                        if (type.equals("dataFormattedValue") && (totalData2 = TotalRow.this.getTotalData()) != null) {
                            return totalData2.getFormattedData(retVal, this.m_columnName, lv.m_aggType);
                        }
                        return this.cacheIt(retVal, type);
                    }
                    case COUNT: {
                        TotalData totalData3;
                        if (type.equals("dataFormattedValue") && (totalData3 = TotalRow.this.getTotalData()) != null) {
                            return this.cacheIt(totalData3.getFormattedData(lv.m_count, this.m_columnName, lv.m_aggType), type);
                        }
                        return this.cacheIt(lv.m_count, type);
                    }
                    case MEDIAN: {
                        ColumnValues _sorted = new ColumnValues(this.m_sortedVals.toArray(new ColumnValue[0]));
                        return this.cacheIt(_sorted.getMedian(), type);
                    }
                    case STDDEV: 
                    case VARIANCE: {
                        TotalData totalData4;
                        if (lv.m_statVal == null) {
                            if (lv.m_count == 0L) {
                                return this.cacheIt(null, type);
                            }
                            Object sum = lv.m_value;
                            long count = lv.m_count;
                            Object mean = this.div(sum, count);
                            Object sumOfSquares = lv.m_value2;
                            Object variance = this.variance(sumOfSquares, sum, mean, count);
                            lv.m_statVal = lv.m_aggType == AggType.VARIANCE ? variance : this.sqrt(variance);
                            lv.m_count = null;
                            lv.m_value = null;
                            lv.m_value2 = null;
                        }
                        if (type.equals("dataFormattedValue") && (totalData4 = TotalRow.this.getTotalData()) != null) {
                            return this.cacheIt(totalData4.getFormattedData(lv.m_statVal, this.m_columnName, lv.m_aggType), type);
                        }
                        return this.cacheIt(lv.m_statVal, type);
                    }
                }
                if (type.equals("dataFormattedValue") && (totalData = TotalRow.this.getTotalData()) != null) {
                    return this.cacheIt(totalData.getFormattedData(lv.m_value, this.m_columnName, lv.m_aggType), type);
                }
                return this.cacheIt(lv.m_value, type);
            }
            return this.cacheIt(this.m_internalImpl.getData(type), type);
        }

        private Object sqrt(Object val) {
            if (val instanceof Integer) {
                return Math.sqrt(((Integer)val).doubleValue());
            }
            if (val instanceof Long) {
                return Math.sqrt(((Long)val).doubleValue());
            }
            if (val instanceof Float) {
                return Math.sqrt(((Float)val).doubleValue());
            }
            if (val instanceof Double) {
                return Math.sqrt((Double)val);
            }
            if (val instanceof BigInteger) {
                return BigDecimal.valueOf(Math.sqrt(((BigInteger)val).doubleValue()));
            }
            if (val instanceof BigDecimal) {
                return BigDecimal.valueOf(Math.sqrt(((BigDecimal)val).doubleValue()));
            }
            try {
                if (val instanceof NUMBER) {
                    return ((NUMBER)val).sqroot();
                }
            }
            catch (SQLException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            return null;
        }

        private Object variance(Object sumOfSquares, Object sum, Object mean, long count) {
            if (sum instanceof BigInteger) {
                BigDecimal bigSumSquares = new BigDecimal((BigInteger)sumOfSquares);
                BigDecimal bigSum = new BigDecimal((BigInteger)sum);
                BigDecimal bigMean = (BigDecimal)mean;
                BigDecimal product = bigSum.multiply(bigMean);
                BigDecimal numerator = bigSumSquares.subtract(product);
                return numerator.divide(BigDecimal.valueOf(count), MathContext.DECIMAL32);
            }
            if (sum instanceof BigDecimal) {
                BigDecimal bigSumSquares = (BigDecimal)sumOfSquares;
                BigDecimal bigSum = (BigDecimal)sum;
                BigDecimal bigMean = (BigDecimal)mean;
                BigDecimal product = bigSum.multiply(bigMean);
                BigDecimal numerator = bigSumSquares.subtract(product);
                return numerator.divide(BigDecimal.valueOf(count), MathContext.DECIMAL32);
            }
            if (sum instanceof NUMBER) {
                try {
                    NUMBER bigSumSquares = (NUMBER)sumOfSquares;
                    NUMBER bigSum = (NUMBER)sum;
                    NUMBER bigMean = (NUMBER)mean;
                    NUMBER product = bigSum.mul(bigMean);
                    NUMBER numerator = bigSumSquares.sub(product);
                    return numerator.div(new NUMBER(count));
                }
                catch (SQLException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            if (sum instanceof Number) {
                return (((Number)sumOfSquares).doubleValue() - ((Number)sum).doubleValue() * ((Number)mean).doubleValue()) / (double)count;
            }
            return null;
        }

        private QDRLite _buildPageEdges(Cube.PageRowInfo pri, QDRLite qdr) throws TransformException {
            if (pri == null || pri.getMembers() == null) {
                return qdr;
            }
            MemberInterface[][][] pageVals = pri.getMembers();
            for (int e = 0; e < pageVals.length; ++e) {
                if (pageVals[e] == null) continue;
                for (int m = 0; m < pageVals[e].length; ++m) {
                    if (pageVals[e][m] == null || pri.getMeasures() != null && (pri.getMeasures() == null || !pri.getMeasures()[m].equals(this.m_internalImpl.getData("dataTypeColumn")))) continue;
                    for (int v = 0; v < pageVals[e][m].length; ++v) {
                        qdr.addDimMemberPair(pageVals[e][m][v].getEdgeTreeNode().getLayerName(), pageVals[e][m][v].getValue());
                    }
                }
            }
            return qdr;
        }

        private QDRLite _buildEdge(RowInfo[] rowInfo, int layer, AggType aggType, QDRLite qdr) throws TransformException {
            if (rowInfo != null) {
                for (int i = 0; i < rowInfo.length; ++i) {
                    MemberInterface[] members;
                    String meas = (String)this.m_internalImpl.getData("dataTypeColumn");
                    if (rowInfo[i].getMeasure() != null && (meas == null || !meas.equals(rowInfo[i].getMeasure())) || (members = rowInfo[i].getFullValues()) == null) continue;
                    EdgeTreeNode node = null;
                    EdgeTreeNode parent = null;
                    MemberInterface last = null;
                    for (int m = 0; m < members.length; ++m) {
                        if (layer == -1 || m < layer) {
                            if (members[m] == null) {
                                node = last.getEdgeTreeNode();
                            } else {
                                node = members[m].getEdgeTreeNode();
                                last = members[m];
                            }
                        } else {
                            parent = members[m] != null ? members[m].getEdgeTreeNode().getParent() : node;
                            if (parent != null) {
                                node = aggType == AggType.FIRST ? parent.getFirstChild(layer > -1) : parent.getLastChild(layer > -1);
                            }
                        }
                        if (node == null) continue;
                        qdr.addDimMemberPair(node.getLayerName(), node.getMember().getValue());
                    }
                }
            }
            return qdr;
        }

        private QDRLite _buildFirstLastQDR(AggType aggType) throws TransformException {
            int[] edgeLayer;
            AggWhat[] cols = TotalRow.this.m_spec.getColumnsToAggregate();
            if (cols != null && cols.length > 0 && (edgeLayer = cols[0].getEdgeAndLayer(TotalRow.this.m_projection.getLayout()))[0] != -1 && edgeLayer[0] < 2) {
                QDRLite qdr = new QDRLite((String)null);
                qdr = this._buildEdge(TotalRow.this.m_row, edgeLayer[0] == 1 ? edgeLayer[1] : -1, aggType, qdr);
                qdr = this._buildEdge(TotalRow.this.m_column, edgeLayer[0] == 0 ? edgeLayer[1] : -1, aggType, qdr);
                qdr = this._buildPageEdges(TotalRow.this.m_pri, qdr);
                return qdr;
            }
            return null;
        }

        protected void countValue(Object newVal, LayerValue lv) {
            if (newVal != null) {
                lv.m_count = lv.m_count + 1L;
            }
        }

        protected Object min(Object oper1, Object oper2) {
            block113: {
                if (oper1 == null && oper2 != null) {
                    return oper2;
                }
                if (oper1 != null && oper2 == null) {
                    return oper1;
                }
                if (oper1 instanceof Integer) {
                    int val1 = (Integer)oper1;
                    if (oper2 instanceof Integer) {
                        return Math.min(val1, (Integer)oper2);
                    }
                    if (oper2 instanceof Long) {
                        return Math.min((long)val1, (Long)oper2);
                    }
                    if (oper2 instanceof Float) {
                        return Float.valueOf(Math.min((float)val1, ((Float)oper2).floatValue()));
                    }
                    if (oper2 instanceof Double) {
                        return Math.min((double)val1, (Double)oper2);
                    }
                    if (oper2 instanceof Short) {
                        return Math.min(val1, ((Short)oper2).shortValue());
                    }
                    if (oper2 instanceof Byte) {
                        return Math.min(val1, ((Byte)oper2).byteValue());
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                        }
                        break block113;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Long) {
                    long val1 = (Long)oper1;
                    if (oper2 instanceof Integer) {
                        return Math.min(val1, (long)((Integer)oper2).intValue());
                    }
                    if (oper2 instanceof Long) {
                        return Math.min(val1, (Long)oper2);
                    }
                    if (oper2 instanceof Float) {
                        return Float.valueOf(Math.min((float)val1, ((Float)oper2).floatValue()));
                    }
                    if (oper2 instanceof Double) {
                        return Math.min((double)val1, (Double)oper2);
                    }
                    if (oper2 instanceof Short) {
                        return Math.min(val1, (long)((Short)oper2).shortValue());
                    }
                    if (oper2 instanceof Byte) {
                        return Math.min(val1, (long)((Byte)oper2).byteValue());
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                        }
                        break block113;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Float) {
                    float val1 = ((Float)oper1).floatValue();
                    if (oper2 instanceof Integer) {
                        return Float.valueOf(Math.min(val1, (float)((Integer)oper2).intValue()));
                    }
                    if (oper2 instanceof Long) {
                        return Float.valueOf(Math.min(val1, (float)((Long)oper2).longValue()));
                    }
                    if (oper2 instanceof Float) {
                        return Float.valueOf(Math.min(val1, ((Float)oper2).floatValue()));
                    }
                    if (oper2 instanceof Double) {
                        return Math.min((double)val1, (Double)oper2);
                    }
                    if (oper2 instanceof Short) {
                        return Float.valueOf(Math.min(val1, (float)((Short)oper2).shortValue()));
                    }
                    if (oper2 instanceof Byte) {
                        return Float.valueOf(Math.min(val1, (float)((Byte)oper2).byteValue()));
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).min(BigInteger.valueOf((long)val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                        }
                        break block113;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Double) {
                    double val1 = (Double)oper1;
                    if (oper2 instanceof Integer) {
                        return Math.min(val1, (double)((Integer)oper2).intValue());
                    }
                    if (oper2 instanceof Long) {
                        return Math.min(val1, (double)((Long)oper2).longValue());
                    }
                    if (oper2 instanceof Float) {
                        return Math.min(val1, (double)((Float)oper2).floatValue());
                    }
                    if (oper2 instanceof Double) {
                        return Math.min(val1, (Double)oper2);
                    }
                    if (oper2 instanceof Short) {
                        return Math.min(val1, (double)((Short)oper2).shortValue());
                    }
                    if (oper2 instanceof Byte) {
                        return Math.min(val1, (double)((Byte)oper2).byteValue());
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).min(BigInteger.valueOf((long)val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                    }
                    if (oper2 instanceof NUMBER) {
                        try {
                            return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                        }
                        catch (SQLException e) {
                            throw new TransformRuntimeException(e.getMessage(), e);
                        }
                    }
                } else {
                    if (oper1 instanceof Short) {
                        short val1 = (Short)oper1;
                        if (oper2 instanceof Integer) {
                            return Math.min(val1, (Integer)oper2);
                        }
                        if (oper2 instanceof Long) {
                            return Math.min((long)val1, (Long)oper2);
                        }
                        if (oper2 instanceof Float) {
                            return Float.valueOf(Math.min((float)val1, ((Float)oper2).floatValue()));
                        }
                        if (oper2 instanceof Double) {
                            return Math.min((double)val1, (Double)oper2);
                        }
                        if (oper2 instanceof Short) {
                            return Math.min(val1, ((Short)oper2).shortValue());
                        }
                        if (oper2 instanceof Byte) {
                            return Math.min(val1, ((Byte)oper2).byteValue());
                        }
                        if (oper2 instanceof BigInteger) {
                            return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                        }
                        if (oper2 instanceof BigDecimal) {
                            return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                        }
                        try {
                            if (oper2 instanceof NUMBER) {
                                return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                            }
                            break block113;
                        }
                        catch (SQLException e) {
                            throw new TransformRuntimeException(e.getMessage(), e);
                        }
                    }
                    if (oper1 instanceof Byte) {
                        byte val1 = (Byte)oper1;
                        if (oper2 instanceof Integer) {
                            return Math.min(val1, (Integer)oper2);
                        }
                        if (oper2 instanceof Long) {
                            return Math.min((long)val1, (Long)oper2);
                        }
                        if (oper2 instanceof Float) {
                            return Float.valueOf(Math.min((float)val1, ((Float)oper2).floatValue()));
                        }
                        if (oper2 instanceof Double) {
                            return Math.min((double)val1, (Double)oper2);
                        }
                        if (oper2 instanceof Short) {
                            return Math.min(val1, ((Short)oper2).shortValue());
                        }
                        if (oper2 instanceof Byte) {
                            return Math.min(val1, ((Byte)oper2).byteValue());
                        }
                        if (oper2 instanceof BigInteger) {
                            return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                        }
                        if (oper2 instanceof BigDecimal) {
                            return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                        }
                        try {
                            if (oper2 instanceof NUMBER) {
                                return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                            }
                            break block113;
                        }
                        catch (SQLException e) {
                            throw new TransformRuntimeException(e.getMessage(), e);
                        }
                    }
                    if (oper1 instanceof BigInteger) {
                        BigInteger val1 = (BigInteger)oper1;
                        if (oper2 instanceof Integer) {
                            return val1.min(BigInteger.valueOf(((Integer)oper2).intValue()));
                        }
                        if (oper2 instanceof Long) {
                            return val1.min(BigInteger.valueOf((Long)oper2));
                        }
                        if (oper2 instanceof Float) {
                            return val1.min(BigInteger.valueOf((long)((Float)oper2).floatValue()));
                        }
                        if (oper2 instanceof Double) {
                            return val1.min(BigInteger.valueOf((long)((Double)oper2).doubleValue()));
                        }
                        if (oper2 instanceof Short) {
                            return val1.min(BigInteger.valueOf(((Short)oper2).shortValue()));
                        }
                        if (oper2 instanceof Byte) {
                            return val1.min(BigInteger.valueOf(((Byte)oper2).byteValue()));
                        }
                        if (oper2 instanceof BigInteger) {
                            return val1.min((BigInteger)oper2);
                        }
                        if (oper2 instanceof BigDecimal) {
                            return val1.min(BigInteger.valueOf(((BigDecimal)oper2).longValue()));
                        }
                        if (oper2 instanceof NUMBER) {
                            try {
                                return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                            }
                            catch (SQLException e) {
                                throw new TransformRuntimeException(e.getMessage(), e);
                            }
                        }
                    } else if (oper1 instanceof BigDecimal) {
                        BigDecimal val1 = (BigDecimal)oper1;
                        if (oper2 instanceof Integer) {
                            return val1.min(BigDecimal.valueOf(((Integer)oper2).intValue()));
                        }
                        if (oper2 instanceof Long) {
                            return val1.min(BigDecimal.valueOf((Long)oper2));
                        }
                        if (oper2 instanceof Float) {
                            return val1.min(BigDecimal.valueOf(((Float)oper2).floatValue()));
                        }
                        if (oper2 instanceof Double) {
                            return val1.min(BigDecimal.valueOf((Double)oper2));
                        }
                        if (oper2 instanceof Short) {
                            return val1.min(BigDecimal.valueOf(((Short)oper2).shortValue()));
                        }
                        if (oper2 instanceof Byte) {
                            return val1.min(BigDecimal.valueOf(((Byte)oper2).byteValue()));
                        }
                        if (oper2 instanceof BigInteger) {
                            return val1.min(new BigDecimal((BigInteger)oper2));
                        }
                        if (oper2 instanceof BigDecimal) {
                            return val1.min((BigDecimal)oper2);
                        }
                        if (oper2 instanceof NUMBER) {
                            try {
                                return ((NUMBER)TransformUtils.min(oper2, new NUMBER(val1))).bigDecimalValue();
                            }
                            catch (SQLException e) {
                                throw new TransformRuntimeException(e.getMessage(), e);
                            }
                        }
                    } else if (oper1 instanceof NUMBER) {
                        try {
                            NUMBER val1 = (NUMBER)oper1;
                            if (oper2 instanceof Integer) {
                                return TransformUtils.min(val1, new NUMBER((Object)((Integer)oper2)).intValue());
                            }
                            if (oper2 instanceof Long) {
                                return TransformUtils.min(val1, new NUMBER(((Long)oper2).longValue()));
                            }
                            if (oper2 instanceof Float) {
                                return TransformUtils.min(val1, new NUMBER(((Float)oper2).floatValue()));
                            }
                            if (oper2 instanceof Double) {
                                return TransformUtils.min(val1, new NUMBER(((Double)oper2).doubleValue()));
                            }
                            if (oper2 instanceof Short) {
                                return TransformUtils.min(val1, new NUMBER(((Short)oper2).shortValue()));
                            }
                            if (oper2 instanceof Byte) {
                                return TransformUtils.min(val1, new NUMBER(((Byte)oper2).byteValue()));
                            }
                            if (oper2 instanceof BigInteger) {
                                return TransformUtils.min(val1, new NUMBER((BigInteger)oper2));
                            }
                            if (oper2 instanceof BigDecimal) {
                                return TransformUtils.min(val1, new NUMBER((BigDecimal)oper2));
                            }
                            if (oper2 instanceof NUMBER) {
                                return TransformUtils.min(oper2, val1);
                            }
                        }
                        catch (SQLException e) {
                            throw new TransformRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
            return null;
        }

        protected Object max(Object oper1, Object oper2) {
            if (oper1 == null && oper2 != null) {
                return oper2;
            }
            if (oper1 != null && oper2 == null) {
                return oper1;
            }
            if (oper1 instanceof Integer) {
                int val1 = (Integer)oper1;
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (Integer)oper2);
                }
                if (oper2 instanceof Long) {
                    return Math.max((long)val1, (Long)oper2);
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, ((Float)oper2).floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, (Double)oper2);
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, ((Short)oper2).shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, ((Byte)oper2).byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, val1);
                }
            } else if (oper1 instanceof Long) {
                long val1 = (Long)oper1;
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (long)((Integer)oper2).intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max(val1, (Long)oper2);
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, ((Float)oper2).floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, (Double)oper2);
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, (long)((Short)oper2).shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, (long)((Byte)oper2).byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, val1);
                }
            } else if (oper1 instanceof Float) {
                float val1 = ((Float)oper1).floatValue();
                if (oper2 instanceof Integer) {
                    return Float.valueOf(Math.max(val1, (float)((Integer)oper2).intValue()));
                }
                if (oper2 instanceof Long) {
                    return Float.valueOf(Math.max(val1, (float)((Long)oper2).longValue()));
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max(val1, ((Float)oper2).floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, (Double)oper2);
                }
                if (oper2 instanceof Byte) {
                    return Float.valueOf(Math.max(val1, (float)((Byte)oper2).byteValue()));
                }
                if (oper2 instanceof Short) {
                    return Float.valueOf(Math.max(val1, (float)((Short)oper2).shortValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, Float.valueOf(val1));
                }
            } else if (oper1 instanceof Double) {
                double val1 = (Double)oper1;
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (double)((Integer)oper2).intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max(val1, (double)((Long)oper2).longValue());
                }
                if (oper2 instanceof Float) {
                    return Math.max(val1, (double)((Float)oper2).floatValue());
                }
                if (oper2 instanceof Double) {
                    return Math.max(val1, (Double)oper2);
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, (double)((Byte)oper2).byteValue());
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, (double)((Short)oper2).shortValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, val1);
                }
            } else if (oper1 instanceof Short) {
                short val1 = (Short)oper1;
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (Integer)oper2);
                }
                if (oper2 instanceof Long) {
                    return Math.max((long)val1, (Long)oper2);
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, ((Float)oper2).floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, (Double)oper2);
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, ((Short)oper2).shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, ((Byte)oper2).byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, val1);
                }
            } else if (oper1 instanceof Byte) {
                byte val1 = (Byte)oper1;
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (Integer)oper2);
                }
                if (oper2 instanceof Long) {
                    return Math.max((long)val1, (Long)oper2);
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, ((Float)oper2).floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, (Double)oper2);
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, ((Short)oper2).shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, ((Byte)oper2).byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, val1);
                }
            } else if (oper1 instanceof BigInteger) {
                BigInteger val1 = (BigInteger)oper1;
                if (oper2 instanceof Integer) {
                    return val1.max(BigInteger.valueOf(((Integer)oper2).intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.max(BigInteger.valueOf((Long)oper2));
                }
                if (oper2 instanceof Float) {
                    return val1.max(BigInteger.valueOf((long)((Float)oper2).floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.max(BigInteger.valueOf((long)((Double)oper2).doubleValue()));
                }
                if (oper2 instanceof Short) {
                    return val1.max(BigInteger.valueOf(((Short)oper2).shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.max(BigInteger.valueOf(((Byte)oper2).byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.max((BigInteger)oper2);
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.max(BigInteger.valueOf(((BigDecimal)oper2).longValue()));
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, val1);
                }
            } else if (oper1 instanceof BigDecimal) {
                BigDecimal val1 = (BigDecimal)oper1;
                if (oper2 instanceof Integer) {
                    return val1.max(BigDecimal.valueOf(((Integer)oper2).intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.max(BigDecimal.valueOf((Long)oper2));
                }
                if (oper2 instanceof Float) {
                    return val1.max(BigDecimal.valueOf(((Float)oper2).floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.max(BigDecimal.valueOf((Double)oper2));
                }
                if (oper2 instanceof Short) {
                    return val1.max(BigDecimal.valueOf(((Short)oper2).shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.max(BigDecimal.valueOf(((Byte)oper2).byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.max(new BigDecimal((BigInteger)oper2));
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.max((BigDecimal)oper2);
                }
                if (oper2 instanceof NUMBER) {
                    return TransformUtils.max(oper2, val1);
                }
            } else if (oper1 instanceof NUMBER) {
                try {
                    NUMBER val1 = (NUMBER)oper1;
                    if (oper2 instanceof Integer) {
                        return TransformUtils.max(val1, new NUMBER((Object)((Integer)oper2)).intValue());
                    }
                    if (oper2 instanceof Long) {
                        return TransformUtils.max(val1, new NUMBER(((Long)oper2).longValue()));
                    }
                    if (oper2 instanceof Float) {
                        return TransformUtils.max(val1, new NUMBER(((Float)oper2).floatValue()));
                    }
                    if (oper2 instanceof Double) {
                        return TransformUtils.max(val1, new NUMBER(((Double)oper2).doubleValue()));
                    }
                    if (oper2 instanceof Short) {
                        return TransformUtils.max(val1, new NUMBER(((Short)oper2).shortValue()));
                    }
                    if (oper2 instanceof Byte) {
                        return TransformUtils.max(val1, new NUMBER(((Byte)oper2).byteValue()));
                    }
                    if (oper2 instanceof BigInteger) {
                        return TransformUtils.max(val1, new NUMBER((BigInteger)oper2));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return TransformUtils.max(val1, new NUMBER((BigDecimal)oper2));
                    }
                    if (oper2 instanceof NUMBER) {
                        return TransformUtils.max(oper2, val1);
                    }
                }
                catch (SQLException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            return null;
        }

        protected Object sum(Object oper1, Object oper2) {
            block112: {
                if (oper1 == null && oper2 != null) {
                    return oper2;
                }
                if (oper1 != null && oper2 == null) {
                    return oper1;
                }
                if (oper1 instanceof Integer) {
                    int val1 = (Integer)oper1;
                    if (oper2 instanceof Integer) {
                        return (long)(val1 + (Integer)oper2);
                    }
                    if (oper2 instanceof Long) {
                        return (long)val1 + (Long)oper2;
                    }
                    if (oper2 instanceof Float) {
                        return (double)((float)val1 + ((Float)oper2).floatValue());
                    }
                    if (oper2 instanceof Double) {
                        return (double)val1 + (Double)oper2;
                    }
                    if (oper2 instanceof Short) {
                        return (long)(val1 + (Short)oper2);
                    }
                    if (oper2 instanceof Byte) {
                        return (long)(val1 + (Byte)oper2);
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        break block112;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Long) {
                    long val1 = (Long)oper1;
                    if (oper2 instanceof Integer) {
                        return val1 + (long)((Integer)oper2).intValue();
                    }
                    if (oper2 instanceof Long) {
                        return val1 + (Long)oper2;
                    }
                    if (oper2 instanceof Float) {
                        return Float.valueOf((float)val1 + ((Float)oper2).floatValue());
                    }
                    if (oper2 instanceof Double) {
                        return (double)val1 + (Double)oper2;
                    }
                    if (oper2 instanceof Short) {
                        return val1 + (long)((Short)oper2).shortValue();
                    }
                    if (oper2 instanceof Byte) {
                        return val1 + (long)((Byte)oper2).byteValue();
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        break block112;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Float) {
                    float val1 = ((Float)oper1).floatValue();
                    if (oper2 instanceof Integer) {
                        return Float.valueOf(val1 + (float)((Integer)oper2).intValue());
                    }
                    if (oper2 instanceof Long) {
                        return Float.valueOf(val1 + (float)((Long)oper2).longValue());
                    }
                    if (oper2 instanceof Float) {
                        return Float.valueOf(val1 + ((Float)oper2).floatValue());
                    }
                    if (oper2 instanceof Double) {
                        return (double)val1 + (Double)oper2;
                    }
                    if (oper2 instanceof Short) {
                        return (double)(val1 + (float)((Short)oper2).shortValue());
                    }
                    if (oper2 instanceof Byte) {
                        return (double)(val1 + (float)((Byte)oper2).byteValue());
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).add(BigInteger.valueOf((long)val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        break block112;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Double) {
                    double val1 = (Double)oper1;
                    if (oper2 instanceof Integer) {
                        return val1 + (double)((Integer)oper2).intValue();
                    }
                    if (oper2 instanceof Long) {
                        return val1 + (double)((Long)oper2).longValue();
                    }
                    if (oper2 instanceof Float) {
                        return val1 + (double)((Float)oper2).floatValue();
                    }
                    if (oper2 instanceof Double) {
                        return val1 + (Double)oper2;
                    }
                    if (oper2 instanceof Short) {
                        return val1 + (double)((Short)oper2).shortValue();
                    }
                    if (oper2 instanceof Byte) {
                        return val1 + (double)((Byte)oper2).byteValue();
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).add(BigInteger.valueOf((long)val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        break block112;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Short) {
                    short val1 = (Short)oper1;
                    if (oper2 instanceof Integer) {
                        return (long)(val1 + (Integer)oper2);
                    }
                    if (oper2 instanceof Long) {
                        return (long)val1 + (Long)oper2;
                    }
                    if (oper2 instanceof Float) {
                        return (double)((float)val1 + ((Float)oper2).floatValue());
                    }
                    if (oper2 instanceof Double) {
                        return (double)val1 + (Double)oper2;
                    }
                    if (oper2 instanceof Short) {
                        return (long)(val1 + (Short)oper2);
                    }
                    if (oper2 instanceof Byte) {
                        return (long)(val1 + (Byte)oper2);
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        break block112;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof Byte) {
                    byte val1 = (Byte)oper1;
                    if (oper2 instanceof Integer) {
                        return (long)(val1 + (Integer)oper2);
                    }
                    if (oper2 instanceof Long) {
                        return (long)val1 + (Long)oper2;
                    }
                    if (oper2 instanceof Float) {
                        return (double)((float)val1 + ((Float)oper2).floatValue());
                    }
                    if (oper2 instanceof Double) {
                        return (double)val1 + (Double)oper2;
                    }
                    if (oper2 instanceof Short) {
                        return (long)(val1 + (Short)oper2);
                    }
                    if (oper2 instanceof Byte) {
                        return (long)(val1 + (Byte)oper2);
                    }
                    if (oper2 instanceof BigInteger) {
                        return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                    }
                    try {
                        if (oper2 instanceof NUMBER) {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        break block112;
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
                if (oper1 instanceof BigInteger) {
                    BigInteger val1 = (BigInteger)oper1;
                    if (oper2 instanceof Integer) {
                        return val1.add(BigInteger.valueOf(((Integer)oper2).intValue()));
                    }
                    if (oper2 instanceof Long) {
                        return val1.add(BigInteger.valueOf((Long)oper2));
                    }
                    if (oper2 instanceof Float) {
                        return val1.add(BigInteger.valueOf((long)((Float)oper2).floatValue()));
                    }
                    if (oper2 instanceof Double) {
                        return val1.add(BigInteger.valueOf((long)((Double)oper2).doubleValue()));
                    }
                    if (oper2 instanceof Short) {
                        return val1.add(BigInteger.valueOf(((Short)oper2).shortValue()));
                    }
                    if (oper2 instanceof Byte) {
                        return val1.add(BigInteger.valueOf(((Byte)oper2).byteValue()));
                    }
                    if (oper2 instanceof BigInteger) {
                        return val1.add((BigInteger)oper2);
                    }
                    if (oper2 instanceof BigDecimal) {
                        return val1.add(BigInteger.valueOf(((BigDecimal)oper2).longValue()));
                    }
                    if (oper2 instanceof NUMBER) {
                        try {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        catch (SQLException e) {
                            throw new TransformRuntimeException(e.getMessage(), e);
                        }
                    }
                } else if (oper1 instanceof BigDecimal) {
                    BigDecimal val1 = (BigDecimal)oper1;
                    if (oper2 instanceof Integer) {
                        return val1.add(BigDecimal.valueOf(((Integer)oper2).intValue()));
                    }
                    if (oper2 instanceof Long) {
                        return val1.add(BigDecimal.valueOf((Long)oper2));
                    }
                    if (oper2 instanceof Float) {
                        return val1.add(BigDecimal.valueOf(((Float)oper2).floatValue()));
                    }
                    if (oper2 instanceof Double) {
                        return val1.add(BigDecimal.valueOf((Double)oper2));
                    }
                    if (oper2 instanceof Short) {
                        return val1.add(BigDecimal.valueOf(((Short)oper2).shortValue()));
                    }
                    if (oper2 instanceof Byte) {
                        return val1.add(BigDecimal.valueOf(((Byte)oper2).byteValue()));
                    }
                    if (oper2 instanceof BigInteger) {
                        return val1.add(new BigDecimal((BigInteger)oper2));
                    }
                    if (oper2 instanceof BigDecimal) {
                        return val1.add((BigDecimal)oper2);
                    }
                    if (oper2 instanceof NUMBER) {
                        try {
                            return ((NUMBER)oper2).add(new NUMBER(val1));
                        }
                        catch (SQLException e) {
                            throw new TransformRuntimeException(e.getMessage(), e);
                        }
                    }
                } else if (oper1 instanceof NUMBER) {
                    NUMBER val1 = (NUMBER)oper1;
                    try {
                        if (oper2 instanceof Integer) {
                            return val1.add(new NUMBER(((Integer)oper2).intValue()));
                        }
                        if (oper2 instanceof Long) {
                            return val1.add(new NUMBER(((Long)oper2).longValue()));
                        }
                        if (oper2 instanceof Float) {
                            return val1.add(new NUMBER(((Float)oper2).floatValue()));
                        }
                        if (oper2 instanceof Double) {
                            return val1.add(new NUMBER(((Double)oper2).doubleValue()));
                        }
                        if (oper2 instanceof Short) {
                            return val1.add(new NUMBER(((Short)oper2).shortValue()));
                        }
                        if (oper2 instanceof Byte) {
                            return val1.add(new NUMBER(((Byte)oper2).byteValue()));
                        }
                        if (oper2 instanceof BigInteger) {
                            return val1.add(new NUMBER((BigInteger)oper2));
                        }
                        if (oper2 instanceof BigDecimal) {
                            return val1.add(new NUMBER((BigDecimal)oper2));
                        }
                        if (oper2 instanceof NUMBER) {
                            return val1.add((NUMBER)oper2);
                        }
                    }
                    catch (SQLException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
            }
            return null;
        }

        protected Object div(Object oper1, Long oper2) {
            long val2 = oper2;
            if (oper1 instanceof Integer) {
                return (double)((long)((Integer)oper1).intValue() / val2);
            }
            if (oper1 instanceof Long) {
                return (double)((Long)oper1 / val2);
            }
            if (oper1 instanceof Float) {
                return Float.valueOf(((Float)oper1).floatValue() / (float)val2);
            }
            if (oper1 instanceof Double) {
                return (Double)oper1 / (double)val2;
            }
            if (oper1 instanceof Short) {
                return (double)((long)((Short)oper1).shortValue() / val2);
            }
            if (oper1 instanceof Byte) {
                return (double)((long)((Byte)oper1).byteValue() / val2);
            }
            if (oper1 instanceof BigInteger) {
                try {
                    return new BigDecimal((BigInteger)oper1).divide(BigDecimal.valueOf(val2));
                }
                catch (ArithmeticException e) {
                    return new BigDecimal((BigInteger)oper1).divide(BigDecimal.valueOf(val2), MathContext.DECIMAL32);
                }
            }
            if (oper1 instanceof BigDecimal) {
                try {
                    return ((BigDecimal)oper1).divide(BigDecimal.valueOf(val2));
                }
                catch (ArithmeticException e) {
                    return ((BigDecimal)oper1).divide(BigDecimal.valueOf(val2), MathContext.DECIMAL32);
                }
            }
            if (oper1 instanceof NUMBER) {
                try {
                    return ((NUMBER)oper1).div(new NUMBER(val2));
                }
                catch (SQLException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            return null;
        }

        protected boolean isGroupingMatch(QDRLite qdr, QDRLite groupingKey) {
            return qdr.isSupersetOf(groupingKey);
        }

        protected AggType getAggType(QDRLite groupingKey, LayerValue lv, String layerType) throws TransformException {
            if (lv.m_aggType != null) {
                return lv.m_aggType;
            }
            AggMethod[] methods = TotalRow.this.m_spec.getAggMethods();
            if (methods == null) {
                lv.m_aggType = AggType.NONE;
                return lv.m_aggType;
            }
            QDRLite qdr = null;
            String measColName = (String)this.m_internalImpl.getData("dataTypeColumn");
            try {
                for (int i = 0; i < methods.length; ++i) {
                    qdr = methods[i].getQDRLite();
                    if (qdr == null) {
                        lv.m_aggType = methods[i].getAggType(layerType);
                        return lv.m_aggType;
                    }
                    QDRLite groupingKeyClone = (QDRLite)groupingKey.clone();
                    LayerInterface li = TotalRow.this.m_projection.getDataLayer();
                    groupingKeyClone.addDimMemberPair(li != null ? li.getValue() : null, measColName);
                    boolean groupingMatch = this.isGroupingMatch(qdr, groupingKeyClone);
                    if (groupingMatch) {
                        lv.m_aggType = methods[i].getAggType(layerType);
                        return lv.m_aggType;
                    }
                    if (lv.m_aggType != null) continue;
                    lv.m_aggType = AggType.NONE;
                }
            }
            catch (CloneNotSupportedException e) {
                throw new TransformException(e.getMessage(), e);
            }
            return lv.m_aggType;
        }

        private boolean distributeData(Object value, String type, List<CellStruct> cells) throws TransformException {
            if (TotalRow.this.m_spec != null) {
                ArrayList<Distributor.TypeCell> dataCells = new ArrayList<Distributor.TypeCell>();
                for (CellStruct cs : cells) {
                    LayerValue lv = this._getLayerValue(type);
                    if (lv == null) {
                        lv = new LayerValue();
                    }
                    AggType aggType = this.getAggType(cs.m_groupingKey, lv, type);
                    dataCells.add(new Distributor.TypeCell(cs.m_dci, aggType));
                }
                return TotalRow.this.m_spec.getOptions().getDistributor().setConstituentValues(value, type, dataCells.toArray(new Distributor.TypeCell[0]));
            }
            return true;
        }

        @Override
        public boolean setData(Object value, String type) throws TransformException {
            return this.distributeData(value, type, this.m_cells);
        }

        private class CellStruct {
            protected DataCellInterface m_dci = null;
            protected QDRLite m_groupingKey = null;
            protected Row m_row = null;

            public CellStruct(DataCellInterface dci, QDRLite groupingKey, Row row) {
                this.m_dci = dci;
                this.m_groupingKey = groupingKey;
                this.m_row = row;
            }
        }

        private class LayerValue {
            protected Object m_value = null;
            protected boolean m_seenValue = false;
            protected Object m_value2 = null;
            Object m_statVal = null;
            protected Long m_count = new Long(0L);
            protected AggType m_aggType = null;

            public LayerValue() {
            }

            public LayerValue(Object value, boolean seenValue, Object value2, Object statVal, Long count, AggType aggType) {
                this.m_value = value;
                this.m_seenValue = seenValue;
                this.m_value2 = value2;
                this.m_statVal = statVal;
                this.m_count = count;
                this.m_aggType = aggType;
            }

            public Object clone() throws CloneNotSupportedException {
                return new LayerValue(this.m_value, this.m_seenValue, this.m_value2, this.m_statVal, this.m_count, this.m_aggType);
            }
        }
    }
}

